/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.UnauthorizedAccessException;
import org.rvpf.base.som.SubscriberSession;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.SOMSessionImpl;
import org.rvpf.som.topic.Topic;
import org.rvpf.som.topic.TopicServerImpl;

public class SubscriberSessionImpl
extends SOMSessionImpl
implements SubscriberSession {
    private final Topic.Subscriber _subscriber;
    private final TopicServerImpl _topicServer;

    SubscriberSessionImpl(@Nonnull TopicServerImpl topicServer, @Nonnull Session.ConnectionMode connectionMode, @Nonnull String clientName) {
        super(topicServer, connectionMode, clientName);
        this._topicServer = topicServer;
        this._subscriber = this._topicServer.getTopic().newSubscriber();
    }

    @Override
    public synchronized void close() {
        this._subscriber.close();
        super.close();
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this._topicServer.isClosed();
    }

    @Override
    public Serializable[] receive(int limit, long timeout) throws UnauthorizedAccessException, SessionException {
        try {
            this.securityCheck("Read");
            return this._subscriber.receive(limit, this.adjustTimeout(timeout));
        }
        catch (Error | RuntimeException throwable) {
            this.getThisLogger().warn(throwable, ServiceMessages.UNEXPECTED_SESSION_EXCEPTION, throwable);
            throw throwable;
        }
    }

    @Override
    protected String getType() {
        return ServiceMessages.TOPIC_SUBSCRIBER.toString();
    }
}

