/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.som.TopicInfo;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.ConcurrentIdentityHashSet;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.som.topic.PublisherImpl;
import org.rvpf.som.topic.SubscriberImpl;
import org.rvpf.som.topic.Topic;
import org.rvpf.som.topic.TopicStats;

@ThreadSafe
public final class TopicImpl
implements Topic {
    private final TopicInfo _info = new TopicInfo();
    private final Set<Topic.Publisher> _publishers = new IdentityHashSet<Topic.Publisher>();
    private final Object _receiveLatch = new Object();
    private final TopicStats _stats;
    private final Set<SubscriberImpl> _subscribers = new ConcurrentIdentityHashSet<SubscriberImpl>();

    TopicImpl(@Nonnull TopicStats stats) {
        this._stats = stats;
    }

    @Override
    public synchronized void close() {
        for (Topic.Publisher publisher : new ArrayList<Topic.Publisher>(this._publishers)) {
            publisher.close();
        }
        Require.success(this._publishers.isEmpty());
        for (Topic.Subscriber subscriber : new ArrayList<SubscriberImpl>(this._subscribers)) {
            subscriber.close();
        }
        Require.success(this._subscribers.isEmpty());
    }

    @Override
    public TopicInfo getInfo() {
        return this._info;
    }

    @Override
    public synchronized Topic.Publisher newPublisher() {
        PublisherImpl publisher = new PublisherImpl(this);
        this._publishers.add(publisher);
        this._info.updatePublisherCount(1);
        return publisher;
    }

    @Override
    public synchronized Topic.Subscriber newSubscriber() {
        SubscriberImpl subscriber = new SubscriberImpl(this);
        this._subscribers.add(subscriber);
        this._info.updateSubscriberCount(1);
        return subscriber;
    }

    @Override
    public boolean setUp(KeyedValues somProperties) {
        return true;
    }

    @Override
    public void tearDown() {
        this.close();
    }

    void onPublisherClosed(@Nonnull Topic.Publisher publisher) {
        if (this._publishers.remove(publisher)) {
            this._info.updatePublisherCount(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void onSubscriberClosed(@Nonnull Topic.Subscriber subscriber) {
        if (this._subscribers.remove(subscriber)) {
            this._info.updateSubscriberCount(-1);
        }
        Object object = this._receiveLatch;
        synchronized (object) {
            this._receiveLatch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish(@Nonnull Serializable message) {
        boolean notify = false;
        for (SubscriberImpl subscriber : this._subscribers) {
            notify |= subscriber.accept(message);
        }
        if (notify) {
            Object object = this._receiveLatch;
            synchronized (object) {
                this._receiveLatch.notifyAll();
            }
        }
        this._info.setLastPublish(DateTime.now());
        this._stats.messagePublished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitOnReceive(long waitMillis) throws InterruptedException {
        Object object = this._receiveLatch;
        synchronized (object) {
            this._receiveLatch.wait(waitMillis);
        }
    }
}

