/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.rvpf.base.UUID;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.PublisherSession;
import org.rvpf.base.som.SubscriberSession;
import org.rvpf.base.som.TopicInfo;
import org.rvpf.base.som.TopicServer;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.SessionImpl;
import org.rvpf.service.rmi.SessionSecurityContext;
import org.rvpf.som.SOMServerImpl;
import org.rvpf.som.SOMSessionImpl;
import org.rvpf.som.SOMStatsHolder;
import org.rvpf.som.topic.PublisherSessionImpl;
import org.rvpf.som.topic.PublisherWrapper;
import org.rvpf.som.topic.SubscriberSessionImpl;
import org.rvpf.som.topic.SubscriberWrapper;
import org.rvpf.som.topic.Topic;
import org.rvpf.som.topic.TopicImpl;
import org.rvpf.som.topic.TopicStats;

public final class TopicServerImpl
extends SOMServerImpl
implements TopicServer {
    private static final String _PUBLISHER = "publisher";
    private static final String _SUBSCRIBER = "subscriber";
    private final AtomicReference<TopicStats> _stats = new AtomicReference();
    private final AtomicReference<Topic> _topic = new AtomicReference();

    public TopicServerImpl(@Nonnull Optional<SessionSecurityContext> securityContext) {
        super(securityContext);
    }

    @Override
    public void close() {
        Topic topic = this._topic.get();
        if (topic != null) {
            super.close();
            topic.close();
        }
    }

    @Override
    public PublisherSession createPublisherSession(UUID uuid, String clientName) throws SessionException {
        return (PublisherSession)this.createSession(uuid, new SOMServerImpl.Descriptor(_PUBLISHER, clientName));
    }

    @Nonnull
    @CheckReturnValue
    public PublisherWrapper createPublisherWrapper() {
        return new PublisherWrapper(this.getTopic().newPublisher(), this);
    }

    @Override
    public SubscriberSession createSubscriberSession(UUID uuid, String clientName) throws SessionException {
        return (SubscriberSession)this.createSession(uuid, new SOMServerImpl.Descriptor(_SUBSCRIBER, clientName));
    }

    @Nonnull
    @CheckReturnValue
    public SubscriberWrapper createSubscriberWrapper() {
        return new SubscriberWrapper(this.getTopic().newSubscriber(), this);
    }

    @Override
    public TopicInfo getInfo() {
        return this.getTopic().getInfo();
    }

    @Override
    public boolean removeSession(SessionImpl session) {
        boolean removed = super.removeSession(session);
        TopicStats stats = this._stats.get();
        if (stats != null) {
            if (session instanceof PublisherSessionImpl) {
                stats.publisherSessionClosed();
            } else if (session instanceof SubscriberSessionImpl) {
                stats.subscriberSessionClosed();
            }
        }
        return removed;
    }

    @Override
    public boolean setUp(Config config, KeyedGroups topicProperties) {
        if (!super.setUp(config, topicProperties, "topic/")) {
            return false;
        }
        if (!this.hasSecurityContext()) {
            this.getThisLogger().info(ServiceMessages.TOPIC_IS_PRIVATE, this.getName());
        }
        SOMStatsHolder statsOwner = new SOMStatsHolder(this.getName());
        TopicStats stats = new TopicStats(statsOwner);
        statsOwner.setStats(stats);
        if (this.hasSecurityContext() && !stats.register(config)) {
            return false;
        }
        this._stats.set(stats);
        TopicImpl topic = new TopicImpl(stats);
        if (!topic.setUp(topicProperties)) {
            return false;
        }
        this._topic.set(topic);
        return this.hasSecurityContext() ? this.bind() : true;
    }

    @Override
    public void tearDown() {
        TopicStats stats;
        Topic topic = this._topic.getAndSet(null);
        if (topic != null) {
            if (this.hasSecurityContext()) {
                super.tearDown();
            }
            topic.tearDown();
        }
        if ((stats = (TopicStats)this._stats.getAndSet(null)) != null && this.hasSecurityContext()) {
            stats.unregister();
        }
    }

    @Override
    @GuardedBy(value="this")
    protected Session newSession(Session.ConnectionMode connectionMode, Optional<RMIClientSocketFactory> clientSocketFactory, Optional<RMIServerSocketFactory> serverSocketFactory, Object reference) {
        SOMSessionImpl session;
        SOMServerImpl.Descriptor descriptor = (SOMServerImpl.Descriptor)reference;
        String modeName = descriptor.getModeName();
        String clientName = descriptor.getClientName();
        if (modeName == _PUBLISHER) {
            session = new PublisherSessionImpl(this, connectionMode, clientName);
            this._stats.get().publisherSessionOpened();
        } else if (modeName == _SUBSCRIBER) {
            session = new SubscriberSessionImpl(this, connectionMode, clientName);
            this._stats.get().subscriberSessionOpened();
        } else {
            throw new AssertionError();
        }
        session.open(clientSocketFactory.orElse(null), serverSocketFactory.orElse(null));
        return session;
    }

    @Nonnull
    @CheckReturnValue
    Topic getTopic() {
        return Require.notNull(this._topic.get());
    }
}

