/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.som.topic;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.Stats;
import org.rvpf.base.StatsOwner;
import org.rvpf.service.ServiceMessages;
import org.rvpf.som.SOMStats;

@ThreadSafe
public final class TopicStats
extends SOMStats {
    public static final String OBJECT_TYPE = "SOMTopic";
    private static final long serialVersionUID = 1L;
    private AtomicInteger _messagesPublished = new AtomicInteger();
    private AtomicInteger _publisherSessionsClosed = new AtomicInteger();
    private AtomicInteger _publisherSessionsOpened = new AtomicInteger();
    private AtomicInteger _subscriberSessionsClosed = new AtomicInteger();
    private AtomicInteger _subscriberSessionsOpened = new AtomicInteger();

    TopicStats(@Nonnull StatsOwner statsOwner) {
        super(statsOwner);
    }

    @Override
    public void buildText() {
        this.addLine(ServiceMessages.TOPIC_PUBLISHER_SESSIONS, String.valueOf(this.getPublisherSessionsOpened()), String.valueOf(this.getPublisherSessionsClosed()));
        this.addLine(ServiceMessages.TOPIC_SUBSCRIBER_SESSIONS, String.valueOf(this.getSubscriberSessionsOpened()), String.valueOf(this.getSubscriberSessionsClosed()));
        this.addLine(ServiceMessages.TOPIC_MESSAGES_STATS, String.valueOf(this.getMessagesPublished()));
        super.buildText();
    }

    @Override
    public Stats clone() {
        TopicStats clone = (TopicStats)super.clone();
        clone._messagesPublished = new AtomicInteger(this.getMessagesPublished());
        clone._publisherSessionsClosed = new AtomicInteger(this.getPublisherSessionsClosed());
        clone._publisherSessionsOpened = new AtomicInteger(this.getPublisherSessionsOpened());
        clone._subscriberSessionsClosed = new AtomicInteger(this.getSubscriberSessionsClosed());
        clone._subscriberSessionsOpened = new AtomicInteger(this.getSubscriberSessionsOpened());
        return clone;
    }

    @CheckReturnValue
    public int getMessagesPublished() {
        return this._messagesPublished.get();
    }

    @Override
    public String getObjectType() {
        return OBJECT_TYPE;
    }

    @CheckReturnValue
    public int getPublisherSessionsClosed() {
        return this._publisherSessionsClosed.get();
    }

    @CheckReturnValue
    public int getPublisherSessionsOpened() {
        return this._publisherSessionsOpened.get();
    }

    @CheckReturnValue
    public int getSubscriberSessionsClosed() {
        return this._subscriberSessionsClosed.get();
    }

    @CheckReturnValue
    public int getSubscriberSessionsOpened() {
        return this._subscriberSessionsOpened.get();
    }

    @Override
    protected void substract(Stats snapshot) {
        TopicStats stats = (TopicStats)snapshot;
        this._messagesPublished.addAndGet(-stats.getMessagesPublished());
        this._publisherSessionsClosed.addAndGet(-stats.getPublisherSessionsClosed());
        this._publisherSessionsOpened.addAndGet(-stats.getPublisherSessionsOpened());
        this._subscriberSessionsClosed.addAndGet(-stats.getSubscriberSessionsClosed());
        this._subscriberSessionsOpened.addAndGet(-stats.getSubscriberSessionsOpened());
        super.substract(snapshot);
    }

    void messagePublished() {
        this._messagesPublished.incrementAndGet();
        this.updated();
    }

    void publisherSessionClosed() {
        this._publisherSessionsClosed.incrementAndGet();
        this.updated();
    }

    void publisherSessionOpened() {
        this._publisherSessionsOpened.incrementAndGet();
        this.updated();
    }

    void subscriberSessionClosed() {
        this._subscriberSessionsClosed.incrementAndGet();
        this.updated();
    }

    void subscriberSessionOpened() {
        this._subscriberSessionsOpened.incrementAndGet();
        this.updated();
    }
}

