/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.client;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.store.Store;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.value.PointValue;
import org.rvpf.config.Config;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.Proxied;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.service.ServiceMessages;

public abstract class AbstractStore
extends Proxied.Abstract
implements Store {
    public static final String QUERIES_BATCH_LIMIT_PROPERTY = "store.client.queries.batch.limit";
    public static final String RESPONSE_LIMIT_PROPERTY = "store.client.response.limit";
    private static final long _DEFAULT_CONFIRM_RETRY_DELAY = 15000L;
    private static final int _DEFAULT_QUERIES_BATCH_LIMIT = 100;
    private static final int _DEFAULT_RESPONSE_LIMIT = 100;
    private Set<Point> _bindPoints;
    private int _confirmRetries;
    private long _confirmRetryDelay;
    private final Logger _logger = Logger.getInstance(this.getClass());
    private boolean _nullRemoves;
    private int _queriesBatchLimit;
    private int _responseLimit;
    private final List<PointValue> _updates = new LinkedList<PointValue>();

    @Override
    public final boolean addQuery(StoreValuesQuery query) {
        if (query.isCancelled()) {
            return false;
        }
        StoreValuesQuery.Builder queryBuilder = StoreValuesQuery.newBuilder().copyFrom(query);
        this.doAddQuery(queryBuilder.limit(this._responseLimit) ? queryBuilder.build() : query);
        return true;
    }

    @Override
    public final void addUpdate(PointValue pointValue) {
        this._updates.add(pointValue);
    }

    @Override
    public final void bind(Point point) {
        if (this._bindPoints != null) {
            this._bindPoints.add(point);
        }
    }

    @Override
    public boolean canConfirm() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public final int compareTo(Store other) {
        return this.getName().compareTo(other.getName());
    }

    @Override
    public boolean confirm(PointValue pointValue, boolean confirmValue) throws InterruptedException, StoreAccessException {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_CONFIRM, this.getName()).toString());
    }

    @Override
    public StoreValues deliver(int limit, long timeout) throws InterruptedException, StoreAccessException {
        return new StoreValues(new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_DELIVER, this.getName()).toString()));
    }

    @Override
    public final int getQueriesBatchLimit() {
        return this._queriesBatchLimit;
    }

    @Override
    public final int getResponseLimit() {
        return this._responseLimit;
    }

    @Override
    public Optional<StoreValues[]> getSubscribedValues() {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_SUBSCRIBE, this.getName()).toString());
    }

    @Override
    public UUID getUUID() {
        return this.getProxyEntity().getUUID().get();
    }

    @Override
    public final int getUpdateCount() {
        return this._updates.size();
    }

    @Override
    public final Collection<PointValue> getUpdates() {
        return this._updates;
    }

    @Override
    public void impersonate(Optional<String> user) throws StoreAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNullRemoves() {
        return this._nullRemoves;
    }

    @Override
    public Iterable<PointValue> iterate(StoreValuesQuery query) {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_GET, this.getName()).toString());
    }

    @Override
    public StoreValues pull(StoreValuesQuery query, long timeout) throws InterruptedException, StoreAccessException {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_PULL, this.getName()).toString());
    }

    @Override
    public int purge(UUID[] pointUUIDs, TimeInterval timeInterval) throws StoreAccessException {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_PURGE, this.getName()).toString());
    }

    @Override
    public final boolean sendUpdates() throws StoreAccessException {
        return this.sendUpdates(this.getUpdates());
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        if (proxyEntity.getParams().getBoolean("BindPoints")) {
            this._bindPoints = new HashSet<Point>();
            this.getThisLogger().info(ServiceMessages.POINTS_BOUND, new Object[0]);
        }
        this._nullRemoves = proxyEntity.getParams().getBoolean("NullRemoves");
        return true;
    }

    @Override
    public boolean subscribe(Collection<UUID> points) throws StoreAccessException {
        return this.subscribe(points.toArray(new UUID[points.size()]));
    }

    @Override
    public boolean subscribe(UUID[] points) throws StoreAccessException {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_SUBSCRIBE, this.getName()).toString());
    }

    @Override
    public EnumSet<Externalizer.ValueType> supportedValueTypes() throws StoreAccessException {
        return Externalizer.ValueType.stringToSet(this.supportedValueTypeCodes());
    }

    @Override
    public boolean supportsCount() throws StoreAccessException {
        return false;
    }

    @Override
    public boolean supportsDelete() throws StoreAccessException {
        return false;
    }

    @Override
    public boolean supportsDeliver() throws StoreAccessException {
        return false;
    }

    @Override
    public boolean supportsPull() throws StoreAccessException {
        return false;
    }

    @Override
    public boolean supportsPurge() throws StoreAccessException {
        return false;
    }

    @Override
    public boolean supportsSubscribe() throws StoreAccessException {
        return false;
    }

    @Override
    public void tearDown() {
        this.close();
        this._bindPoints = null;
        super.tearDown();
        this.getThisLogger().debug(ServiceMessages.TEAR_DOWN_COMPLETED, new Object[0]);
    }

    @Override
    public boolean unsubscribe(UUID[] points) throws StoreAccessException {
        throw new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_UNSUBSCRIBE, this.getName()).toString());
    }

    protected final StoreAccessException accessException(@Nonnull SessionException cause) {
        this.reset();
        return new StoreAccessException(this.getProxyEntity().getUUID(), cause);
    }

    protected final void bindPoints() throws InterruptedException, StoreAccessException {
        if (this._bindPoints != null && !this._bindPoints.isEmpty()) {
            this.bindPoints(this._bindPoints);
            this._bindPoints.clear();
        }
    }

    protected void bindPoints(@Nonnull Set<Point> points) throws InterruptedException, StoreAccessException {
    }

    protected abstract void doAddQuery(@Nonnull StoreValuesQuery var1);

    @CheckReturnValue
    protected final int getConfirmRetries() {
        return this._confirmRetries;
    }

    @CheckReturnValue
    protected final long getConfirmRetryDelay() {
        return this._confirmRetryDelay;
    }

    @Override
    protected Logger getThisLogger() {
        return this._logger;
    }

    protected void reset() {
        this._updates.clear();
    }

    protected final void setConfirmRetries() {
        Params params;
        Optional<ElapsedTime> confirmRetryDelay = (params = this.getParams()).getElapsed("ConfirmRetryDelay", Optional.empty(), Optional.empty());
        this._confirmRetries = params.getInt("ConfirmRetries", confirmRetryDelay.isPresent() ? 1 : 0);
        if (this._confirmRetries > 0) {
            long l = this._confirmRetryDelay = confirmRetryDelay.isPresent() ? confirmRetryDelay.get().toMillis() : 15000L;
            if (this._confirmRetryDelay <= 0L) {
                this._confirmRetries = 0;
            }
        }
        if (this._confirmRetries > 0 && this.getThisLogger().isDebugEnabled()) {
            this.getThisLogger().debug(ServiceMessages.CONFIRM_RETRIES, String.valueOf(this._confirmRetries));
            this.getThisLogger().debug(ServiceMessages.CONFIRM_RETRY_DELAY, ElapsedTime.fromMillis(this._confirmRetryDelay));
        }
    }

    protected final void setQueriesBatchLimit(@Nonnull Config config) {
        this._queriesBatchLimit = config.getIntValue(QUERIES_BATCH_LIMIT_PROPERTY, 100);
        if (this._queriesBatchLimit < 1) {
            this._queriesBatchLimit = 1;
        }
        this.getThisLogger().debug(ServiceMessages.QUERIES_BATCH_LIMIT, String.valueOf(this._queriesBatchLimit));
    }

    protected final void setResponseLimit(@Nonnull Config config) {
        this._responseLimit = config.getIntValue(RESPONSE_LIMIT_PROPERTY, 0);
        if (this._responseLimit <= 0) {
            this._responseLimit = 100;
        }
        this.getThisLogger().debug(ServiceMessages.RESPONSE_LIMIT, String.valueOf(this._responseLimit));
    }

    @Nonnull
    @CheckReturnValue
    protected abstract String supportedValueTypeCodes() throws StoreAccessException;
}

