/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.client;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.http.ServiceSessionException;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;

public class ProxyStoreClient {
    private static final Logger _LOGGER = Logger.getInstance(ProxyStoreClient.class);
    private boolean _identified;
    private volatile boolean _impersonating;
    private volatile StoreSessionProxy _store;

    @Nonnull
    @CheckReturnValue
    public StoreSessionProxy getStore() {
        return Require.notNull(this._store);
    }

    public void impersonate(@Nonnull Optional<String> user) throws ServiceSessionException {
        if (this._identified) {
            StoreSessionProxy store = this.getStore();
            if (user.isPresent() || this._impersonating) {
                try {
                    store.impersonate(user.orElse(null));
                }
                catch (SessionException exception) {
                    throw new ServiceSessionException(exception);
                }
            }
            this._impersonating = user.isPresent();
        }
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull Config config, @Nonnull KeyedGroups contextProperties) {
        Optional<String> user;
        KeyedGroups storeProperties = contextProperties.getGroup("store");
        KeyedGroups securityProperties = storeProperties.getGroup("security");
        if (securityProperties.isMissing()) {
            securityProperties = contextProperties.getGroup("security");
        }
        if (!(user = storeProperties.getString("user")).isPresent()) {
            user = contextProperties.getString("user");
        }
        Optional<char[]> password = storeProperties.getPassword("password");
        RegistryEntry registryEntry = RegistryEntry.newBuilder().setBinding(storeProperties.getString("binding")).setName(storeProperties.getString("name", Optional.of("ProxyStore"))).setDefaultName("Store").setDefaultRegistryAddress(ServiceRegistry.getRegistryAddress()).setDefaultRegistryPort(ServiceRegistry.getRegistryPort()).build();
        StoreSessionProxy store = (StoreSessionProxy)StoreSessionProxy.newBuilder().setRegistryEntry(registryEntry).setConfigProperties(config.getProperties()).setSecurityProperties(securityProperties).setLoginUser(user).setLoginPassword(password).setClientName(config.getServiceName()).setClientLogger(_LOGGER).setAutoconnect(true).build();
        if (store == null) {
            return false;
        }
        if (store.isRemote()) {
            _LOGGER.warn(ServiceMessages.REMOTE_SERVICE_WARNING, this._store.getServerURI());
        }
        this._identified = store.hasLoginInfo();
        this._store = store;
        return true;
    }

    public void tearDown() {
        StoreSessionProxy store = this._store;
        if (store != null) {
            try {
                this.impersonate(Optional.empty());
            }
            catch (ServiceSessionException serviceSessionException) {
                // empty catch block
            }
            this._store = null;
            store.tearDown();
            this._identified = false;
        }
    }
}

