/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionProxy;
import org.rvpf.base.store.PointBinding;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;
import org.rvpf.store.client.AbstractStore;

public final class RMIStore
extends AbstractStore
implements SessionProxy.Listener {
    private final List<StoreValuesQuery> _queries = new LinkedList<StoreValuesQuery>();
    private final LinkedList<StoreValues> _queriesResponses = new LinkedList();
    private volatile StoreSessionProxy _sessionProxy;
    private volatile String _supportedValueTypeCodes;
    private volatile Boolean _supportsCount;
    private volatile Boolean _supportsDelete;
    private volatile Boolean _supportsDeliver;
    private volatile Boolean _supportsPull;
    private volatile Boolean _supportsSubscribe;

    @Override
    public boolean canConfirm() {
        return true;
    }

    @Override
    public synchronized void close() {
        if (this._sessionProxy != null) {
            this._sessionProxy.disconnect();
            this._sessionProxy = null;
        }
    }

    @Override
    public boolean confirm(PointValue pointValue, boolean confirmValue) throws InterruptedException, StoreAccessException {
        boolean confirmed;
        Optional<Point> point = pointValue.getPoint();
        int retries = 0;
        while (true) {
            boolean missing;
            StoreValuesQuery.Builder storeQueryBuilder = point.isPresent() ? StoreValuesQuery.newBuilder().setPoint(point.get()) : StoreValuesQuery.newBuilder().setPointUUID(pointValue.getPointUUID());
            storeQueryBuilder.setAt(pointValue.getStamp());
            StoreValues storeValues = this.select(storeQueryBuilder.build());
            if (storeValues == null) {
                throw this.accessException(new ServiceClosedException());
            }
            Optional<PointValue> storeValue = storeValues.getPointValue();
            boolean bl = missing = !storeValue.isPresent() || storeValue.get().isDeleted();
            confirmed = missing ? pointValue.isDeleted() : (pointValue.isDeleted() ? false : (confirmValue ? storeValue.get().sameValueAs(pointValue) : true));
            if (confirmed || retries >= this.getConfirmRetries()) break;
            if (retries == 0) {
                this.getThisLogger().debug(ServiceMessages.CONFIRM_RETRY, pointValue);
            }
            Thread.sleep(this.getConfirmRetryDelay());
            ++retries;
        }
        if (confirmed) {
            this.getThisLogger().trace(ServiceMessages.CONFIRMED, pointValue);
        } else {
            this.getThisLogger().debug(ServiceMessages.CONFIRM_FAILED, pointValue);
        }
        return confirmed;
    }

    @Override
    public void connect() throws StoreAccessException {
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy == null) {
            throw this.accessException(new ServiceClosedException());
        }
        try {
            sessionProxy.connect();
        }
        catch (SessionException exception) {
            throw this.accessException(exception);
        }
    }

    @Override
    public StoreValues deliver(int limit, long timeout) throws InterruptedException, StoreAccessException {
        StoreValues response;
        if (!this.supportsDeliver()) {
            return super.deliver(limit, timeout);
        }
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            try {
                response = sessionProxy.deliver(limit, timeout);
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        } else {
            response = null;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (response == null) {
            throw this.accessException(new ServiceClosedException());
        }
        this._acceptQueryResponse(Optional.empty(), response);
        return response;
    }

    @Override
    public Optional<Exception[]> getExceptions() {
        return this._sessionProxy != null ? this._sessionProxy.getExceptions() : Optional.empty();
    }

    @Override
    public Optional<StoreValues[]> getSubscribedValues() {
        return this._sessionProxy != null ? this._sessionProxy.getResponses() : Optional.empty();
    }

    @Override
    public void impersonate(Optional<String> user) throws StoreAccessException {
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            try {
                sessionProxy.impersonate(user.orElse(null));
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        } else {
            throw this.accessException(new ServiceClosedException());
        }
    }

    @Override
    public Iterable<PointValue> iterate(StoreValuesQuery query) {
        return this._sessionProxy.iterate(query, Optional.of(this.getMetadata()));
    }

    @Override
    public Optional<StoreValues> nextValues() throws InterruptedException, StoreAccessException {
        if (!this._queries.isEmpty()) {
            LinkedList<StoreValuesQuery> queries = new LinkedList<StoreValuesQuery>();
            for (StoreValuesQuery query : this._queries) {
                this.getThisLogger().trace(ServiceMessages.SENDING_QUERY, query);
                queries.add(query);
                if (queries.size() < this.getQueriesBatchLimit()) continue;
                this._sendQueries(queries.toArray(new StoreValuesQuery[queries.size()]));
                queries.clear();
            }
            if (!queries.isEmpty()) {
                this._sendQueries(queries.toArray(new StoreValuesQuery[queries.size()]));
            }
            this._queries.clear();
        }
        return Optional.ofNullable(!this._queriesResponses.isEmpty() ? this._queriesResponses.removeFirst() : null);
    }

    @Override
    public boolean onSessionConnected(SessionProxy sessionProxy) {
        try {
            this.bindPoints();
        }
        catch (InterruptedException exception) {
            this.getThisLogger().debug(ServiceMessages.INTERRUPTED, new Object[0]);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (StoreAccessException exception) {
            this.getThisLogger().warn((Throwable)exception, ServiceMessages.BIND_POINTS_FAILED, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onSessionDisconnected(SessionProxy sessionProxy) {
    }

    @Override
    public boolean probe() throws StoreAccessException {
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy == null) {
            throw this.accessException(new ServiceClosedException());
        }
        try {
            return sessionProxy.probe();
        }
        catch (SessionException exception) {
            throw this.accessException(exception);
        }
    }

    @Override
    public StoreValues pull(StoreValuesQuery query, long timeout) throws InterruptedException, StoreAccessException {
        StoreValues response;
        if (!this.supportsPull()) {
            return super.pull(query, timeout);
        }
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            this.getThisLogger().trace(ServiceMessages.PULLING_VALUES, new Object[0]);
            try {
                response = sessionProxy.pull(query, timeout);
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        } else {
            response = null;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (response == null) {
            throw this.accessException(new ServiceClosedException());
        }
        this._acceptQueryResponse(Optional.empty(), response);
        return response;
    }

    @Override
    public int purge(UUID[] pointUUIDs, TimeInterval timeInterval) throws StoreAccessException {
        int purged;
        if (!this.supportsPurge()) {
            return super.purge(pointUUIDs, timeInterval);
        }
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy == null) {
            throw this.accessException(new ServiceClosedException());
        }
        try {
            purged = sessionProxy.purge(pointUUIDs, timeInterval);
        }
        catch (SessionException exception) {
            throw this.accessException(exception);
        }
        return purged;
    }

    @Override
    public StoreValues select(StoreValuesQuery query) throws InterruptedException, StoreAccessException {
        Optional<Object> response;
        if (query.isCount() && !this.supportsCount()) {
            return new StoreValues(new UnsupportedOperationException(Message.format(ServiceMessages.STORE_CANT_COUNT, this.getName()).toString()));
        }
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            this.getThisLogger().trace(ServiceMessages.SENDING_QUERY, query);
            try {
                response = sessionProxy.select(query);
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        } else {
            response = Optional.empty();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!response.isPresent()) {
            throw this.accessException(new ServiceClosedException());
        }
        this._acceptQueryResponse(Optional.of(query), (StoreValues)response.get());
        return (StoreValues)response.get();
    }

    @Override
    public boolean sendUpdates(Collection<PointValue> updates) throws StoreAccessException {
        boolean success;
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            try {
                success = sessionProxy.updateAndCheck(updates, this.getThisLogger());
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        } else {
            throw this.accessException(new ServiceClosedException());
        }
        updates.clear();
        return success;
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        Params params = this.getParams();
        Optional<String> securityParam = this.getParams().getString("Security");
        KeyedGroups securityProperties = securityParam.isPresent() ? metadata.getPropertiesGroup(securityParam.get()) : KeyedGroups.MISSING_KEYED_GROUP;
        RegistryEntry registryEntry = RegistryEntry.newBuilder().setBinding(params.getString("Binding")).setName(params.getString("Name", proxyEntity.getName())).setDefaultName("Store").setDefaultRegistryAddress(ServiceRegistry.getRegistryAddress()).setDefaultRegistryPort(ServiceRegistry.getRegistryPort()).build();
        this._sessionProxy = (StoreSessionProxy)StoreSessionProxy.newBuilder().setRegistryEntry(registryEntry).setConfigProperties(metadata.getProperties()).setSecurityProperties(securityProperties).setLoginUser(params.getString("User")).setLoginPassword(params.getPassword("Password")).setAutoconnect(true).setListener(this).setClientName(metadata.getServiceName()).setClientLogger(this.getThisLogger()).build();
        if (this._sessionProxy == null) {
            return false;
        }
        this.setResponseLimit(metadata);
        this.setQueriesBatchLimit(metadata);
        this.setConfirmRetries();
        this.getThisLogger().debug(ServiceMessages.SET_UP_COMPLETED, new Object[0]);
        return true;
    }

    @Override
    public boolean subscribe(UUID[] points) throws StoreAccessException {
        if (!this.supportsSubscribe()) {
            return super.subscribe(points);
        }
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            try {
                return sessionProxy.subscribeAndCheck(points, this.getThisLogger());
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        throw this.accessException(new ServiceClosedException());
    }

    @Override
    public boolean supportsCount() throws StoreAccessException {
        if (this._supportsCount == null) {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            if (sessionProxy == null) {
                throw this.accessException(new ServiceClosedException());
            }
            try {
                this._supportsCount = sessionProxy.supportsCount();
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        return this._supportsCount;
    }

    @Override
    public boolean supportsDelete() throws StoreAccessException {
        if (this._supportsDelete == null) {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            if (sessionProxy == null) {
                throw this.accessException(new ServiceClosedException());
            }
            try {
                this._supportsDelete = sessionProxy.supportsDelete();
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        return this._supportsDelete;
    }

    @Override
    public boolean supportsDeliver() throws StoreAccessException {
        if (this._supportsDeliver == null) {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            if (sessionProxy == null) {
                throw this.accessException(new ServiceClosedException());
            }
            try {
                this._supportsDeliver = sessionProxy.supportsDeliver();
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        return this._supportsDeliver;
    }

    @Override
    public boolean supportsPull() throws StoreAccessException {
        if (this._supportsPull == null) {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            if (sessionProxy == null) {
                throw this.accessException(new ServiceClosedException());
            }
            try {
                this._supportsPull = sessionProxy.supportsPull();
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        return this._supportsPull;
    }

    @Override
    public boolean supportsSubscribe() throws StoreAccessException {
        if (this._supportsSubscribe == null) {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            if (sessionProxy == null) {
                throw this.accessException(new ServiceClosedException());
            }
            try {
                this._supportsSubscribe = sessionProxy.supportsSubscribe();
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        return this._supportsSubscribe;
    }

    @Override
    public boolean unsubscribe(UUID[] points) throws StoreAccessException {
        if (!this.supportsSubscribe()) {
            return super.unsubscribe(points);
        }
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy == null) {
            throw this.accessException(new ServiceClosedException());
        }
        try {
            return sessionProxy.unsubscribeAndCheck(points, this.getThisLogger());
        }
        catch (SessionException exception) {
            throw this.accessException(exception);
        }
    }

    @Override
    protected void bindPoints(Set<Point> points) throws InterruptedException, StoreAccessException {
        PointBinding[] bindings;
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy == null) {
            throw this.accessException(new ServiceClosedException());
        }
        HashMap<String, PointBinding.Request> requests = new HashMap<String, PointBinding.Request>(KeyedValues.hashCapacity(points.size()));
        this.getThisLogger().debug(ServiceMessages.BINDING_POINTS, new Object[0]);
        for (Point point : points) {
            UUID pointUUID = point.getUUID().get();
            PointBinding.Request.Builder requestBuilder = PointBinding.Request.newBuilder();
            String tag = point.getParams().getString("Tag", point.getName()).orElse(null);
            requestBuilder.selectName(tag);
            requestBuilder.bindTo(pointUUID);
            PointBinding.Request request = requestBuilder.build();
            requests.put(request.getSelectionName().get(), request);
        }
        try {
            bindings = sessionProxy.getPointBindings(requests.values().toArray(new PointBinding.Request[requests.size()]));
        }
        catch (SessionException exception) {
            throw this.accessException(exception);
        }
        if (bindings == null || Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (PointBinding binding : bindings) {
            if (requests.remove(binding.getName()) != null) continue;
            this.getThisLogger().warn(ServiceMessages.BIND_UNEXPECTED, binding.getName());
        }
        for (String name : requests.keySet()) {
            this.getThisLogger().warn(ServiceMessages.BIND_NAME_FAILED, name);
        }
    }

    @Override
    protected void doAddQuery(StoreValuesQuery query) {
        this._queries.add(query);
    }

    @Override
    protected void reset() {
        this._queries.clear();
        this._queriesResponses.clear();
        super.reset();
    }

    @Override
    protected String supportedValueTypeCodes() throws StoreAccessException {
        if (this._supportedValueTypeCodes == null) {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            if (sessionProxy == null) {
                throw this.accessException(new ServiceClosedException());
            }
            try {
                this._supportedValueTypeCodes = sessionProxy.supportedValueTypeCodes();
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        }
        return this._supportedValueTypeCodes;
    }

    private void _acceptQueryResponse(Optional<StoreValuesQuery> query, StoreValues response) {
        if (response.isSuccess()) {
            Point point = query.isPresent() ? (Point)query.get().getPoint().orElse(null) : null;
            Iterator iterator = response.iterator();
            while (iterator.hasNext()) {
                PointValue pointValue = (PointValue)iterator.next();
                pointValue = point != null ? pointValue.restore(point) : pointValue.restore(this.getMetadata());
                iterator.set(pointValue);
                this.getThisLogger().trace(ServiceMessages.RECEIVED_VALUE, pointValue);
            }
            if (response.getCount() >= 0L) {
                this.getThisLogger().trace(ServiceMessages.RECEIVED_COUNT, response.getCount());
            }
            response.setQuery(query);
        } else {
            this.getThisLogger().warn((Throwable)response.getException().get(), ServiceMessages.STORE_REJECTED_QUERY, response.getException().get().getMessage());
        }
    }

    private void _sendQueries(@Nonnull StoreValuesQuery[] queries) throws InterruptedException, StoreAccessException {
        StoreValues[] responses;
        StoreSessionProxy sessionProxy = this._sessionProxy;
        if (sessionProxy != null) {
            try {
                responses = sessionProxy.select(queries);
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
        } else {
            responses = null;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (responses == null) {
            throw this.accessException(new ServiceClosedException());
        }
        for (int i = 0; i < queries.length; ++i) {
            StoreValues response = responses[i];
            if (response == null) continue;
            StoreValuesQuery query = queries[i];
            this._acceptQueryResponse(Optional.of(query), response);
            if (response.isEmpty() && !query.isCount()) continue;
            this._queriesResponses.add(response);
        }
    }
}

