/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.store.client;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Params;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.som.QueueProxy;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.service.ServiceMessages;
import org.rvpf.store.client.AbstractSink;

public final class SOMSink
extends AbstractSink {
    private volatile QueueProxy.Sender _sender;
    private volatile int _updateExceptions;

    @Override
    public synchronized void close() {
        if (this._sender != null) {
            this._sender.disconnect();
            this._sender = null;
        }
        super.close();
    }

    @Override
    public void connect() throws StoreAccessException {
        QueueProxy.Sender sender = this._sender;
        if (sender == null) {
            throw this.accessException(new ServiceClosedException());
        }
        try {
            sender.connect();
        }
        catch (SessionException exception) {
            throw this.accessException(exception);
        }
    }

    @Override
    public Optional<Exception[]> getExceptions() {
        return Optional.of(new Exception[this._updateExceptions]);
    }

    @Override
    public boolean probe() throws StoreAccessException {
        return true;
    }

    @Override
    public boolean sendUpdates(Collection<PointValue> updates) throws StoreAccessException {
        this._updateExceptions = updates.size();
        if (!updates.isEmpty()) {
            Serializable[] updatesArray = updates.toArray(new PointValue[updates.size()]);
            if (this.getThisLogger().isTraceEnabled()) {
                Arrays.stream(updatesArray).forEach(update -> this.getThisLogger().trace(BaseMessages.SENDING_POINT_UPDATE, update));
            }
            try {
                this._sender.send(updatesArray, true);
            }
            catch (SessionException exception) {
                throw this.accessException(exception);
            }
            this.getThisLogger().trace(BaseMessages.POINT_UPDATES_SUCCEEDED, new Object[0]);
            updates.clear();
        }
        return true;
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        QueueProxy.Sender sender;
        KeyedGroups queueProperties;
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        Params params = this.getParams();
        Optional<String> queuePropertiesName = params.getString("Queue");
        if (queuePropertiesName.isPresent()) {
            queueProperties = metadata.getPropertiesGroup(queuePropertiesName.get());
            if (queueProperties.isMissing()) {
                this.getThisLogger().warn(ServiceMessages.MISSING_PROPERTIES, queuePropertiesName.get());
                return false;
            }
        } else {
            queueProperties = new KeyedGroups();
            SOMSink._setPropertiesValue(queueProperties, "binding", params.getString("Binding"));
            SOMSink._setPropertiesValue(queueProperties, "name", params.getString("Name", proxyEntity.getName()));
            Optional<String> securityParam = this.getParams().getString("Security");
            if (securityParam.isPresent()) {
                queueProperties.setGroup("security", metadata.getPropertiesGroup(securityParam.get()));
            } else {
                queueProperties.removeGroup("security");
            }
            SOMSink._setPropertiesValue(queueProperties, "user", params.getString("User"));
            SOMSink._setPropertiesValue(queueProperties, "password", params.getString("Password"));
        }
        if ((sender = QueueProxy.Sender.newBuilder().prepare(this.getMetadata().getProperties(), queueProperties, metadata.getServiceName(), this.getThisLogger()).setAutoconnect(true).build()) == null) {
            return false;
        }
        this._sender = sender;
        this.getThisLogger().debug(ServiceMessages.SET_UP_COMPLETED, new Object[0]);
        return true;
    }

    @Override
    protected void doAddQuery(StoreValuesQuery query) {
    }

    @Override
    protected String supportedValueTypeCodes() {
        return Externalizer.ValueType.setToString(EnumSet.allOf(Externalizer.ValueType.class));
    }

    private static void _setPropertiesValue(KeyedGroups properties, String propertyName, Optional<String> value) {
        if (value.isPresent()) {
            properties.setValue(propertyName, value.get());
        } else {
            properties.removeValue(propertyName);
        }
    }
}

