/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.valve;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class Controller
implements ServiceThread.Target {
    public static final String CONTROL_ADDRESS_PROPERTY = "control.address";
    public static final ElapsedTime DEFAULT_RETRY_DELAY = ElapsedTime.fromMillis(15000L);
    public static final String REQUIRED_PROPERTY = "required";
    public static final String RETRY_DELAY_PROPERTY = "retry.delay";
    public static final String RETRY_PROPERTY = "retry";
    private static final Logger _LOGGER = Logger.getInstance(Controller.class);
    private final Config _config;
    private boolean _required;
    private final AtomicReference<Socket> _socket = new AtomicReference();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    public Controller(@Nonnull Config config) {
        this._config = config;
    }

    public void close() {
        Socket socket = this._socket.getAndSet(null);
        if (socket != null) {
            ServiceThread thread = this._thread.getAndSet(null);
            if (thread != null) {
                _LOGGER.debug(ServiceMessages.STOPPING_THREAD, thread.getName());
            }
            try {
                socket.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            _LOGGER.debug(ServiceMessages.VALVE_CLOSED, socket.getRemoteSocketAddress());
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                }
                if (thread.getThrowable().isPresent()) {
                    throw new RuntimeException(thread.getThrowable().get());
                }
            }
        }
    }

    @CheckReturnValue
    public boolean open(@Nonnull String propertiesName) {
        ServiceThread thread;
        KeyedGroups valveProperties = this._config.getPropertiesGroup(propertiesName);
        if (valveProperties.isMissing()) {
            _LOGGER.error(ServiceMessages.MISSING_PROPERTIES, propertiesName);
            return false;
        }
        String addressString = valveProperties.getString(CONTROL_ADDRESS_PROPERTY).orElse(null);
        if (addressString == null) {
            _LOGGER.error(ServiceMessages.NO_CONTROL_ADDRESS, propertiesName);
            return false;
        }
        Optional<InetSocketAddress> socketAddress = Inet.socketAddress(addressString);
        if (!socketAddress.isPresent()) {
            _LOGGER.error(BaseMessages.BAD_ADDRESS, addressString);
            return false;
        }
        ElapsedTime retryDelay = valveProperties.getElapsed(RETRY_DELAY_PROPERTY, Optional.of(DEFAULT_RETRY_DELAY), Optional.of(ElapsedTime.INFINITY)).get();
        boolean retry = valveProperties.getBoolean(RETRY_PROPERTY);
        this._required = valveProperties.getBoolean(REQUIRED_PROPERTY, retry);
        if (this._required && _LOGGER.isDebugEnabled()) {
            _LOGGER.debug(ServiceMessages.VALVE_CONNECTION_REQUIRED, new Object[0]);
            if (retry) {
                _LOGGER.debug(ServiceMessages.CONNECTION_RETRY_DELAY, retryDelay);
            }
        }
        SecurityContext securityContext = new SecurityContext(_LOGGER);
        KeyedGroups securityProperties = valveProperties.getGroup("security");
        if (!securityContext.setUp(this._config.getProperties(), securityProperties)) {
            return false;
        }
        boolean secure = securityContext.isCertified() || securityContext.isSecure() || !Inet.isOnLocalHost(socketAddress.get().getAddress());
        boolean connected = this._connect(socketAddress.get(), securityContext, secure, retry, retryDelay);
        if (connected && this._thread.compareAndSet(null, thread = new ServiceThread(this, "Valve connection monitor"))) {
            _LOGGER.debug(ServiceMessages.STARTING_THREAD, thread.getName());
            thread.start();
        }
        return connected;
    }

    @Override
    public void run() {
        Socket socket = this._socket.get();
        if (socket == null) {
            return;
        }
        try {
            InputStream inputStream = socket.getInputStream();
            while (inputStream.read() >= 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._socket.get() != null) {
            Message message = new Message(ServiceMessages.VALVE_CONNECTION_LOST, new Object[0]);
            if (this._required) {
                _LOGGER.error(message);
                if (this._config.hasService()) {
                    this._config.getService().fail();
                }
            } else {
                _LOGGER.warn(message);
            }
        }
    }

    private boolean _connect(SocketAddress socketAddress, SecurityContext securityContext, boolean secure, boolean retry, ElapsedTime retryDelay) {
        boolean retrying = false;
        while (true) {
            try {
                Socket socket;
                if (secure) {
                    try {
                        securityContext.checkForSecureOperation();
                    }
                    catch (SSLException exception) {
                        _LOGGER.error(BaseMessages.VERBATIM, exception.getMessage());
                        return false;
                    }
                    SSLContext sslContext = securityContext.createSSLContext();
                    socket = sslContext.getSocketFactory().createSocket();
                    socket.connect(socketAddress);
                    ((SSLSocket)socket).startHandshake();
                } else {
                    socket = new Socket();
                    socket.connect(socketAddress);
                }
                this._socket.set(socket);
                _LOGGER.info(ServiceMessages.VALVE_OPENED, socketAddress);
            }
            catch (FileNotFoundException exception) {
                if (this._required) {
                    _LOGGER.error(BaseMessages.VERBATIM, exception.getMessage());
                    return false;
                }
                _LOGGER.warn(BaseMessages.VERBATIM, exception.getMessage());
            }
            catch (IOException exception) {
                Message message = new Message(ServiceMessages.VALVE_CONNECTION_FAILED, socketAddress, exception.getMessage());
                if (retry) {
                    if (!retrying) {
                        _LOGGER.warn(message);
                        _LOGGER.info(ServiceMessages.RETRYING, new Object[0]);
                        retrying = true;
                    }
                    try {
                        this._config.getService().snooze(retryDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        _LOGGER.warn(ServiceMessages.INTERRUPTED, new Object[0]);
                        Thread.currentThread().interrupt();
                        return false;
                    }
                    continue;
                }
                if (this._required) {
                    _LOGGER.error(message);
                    return false;
                }
                _LOGGER.info(message);
            }
            break;
        }
        return true;
    }
}

