/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.tool.ClassConstantsLoader;
import org.rvpf.tool.ToolsMessages;

public final class MessagesVerifier {
    private static final String _CLASS = ".class";
    private static final Logger _LOGGER = Logger.getInstance(MessagesVerifier.class);
    private static final String _MESSAGES_CLASS = "Messages.class";
    private static final Pattern _MESSAGE_PATTERN = Pattern.compile("([A-Z][A-Z0-9_]*+)\\s*+[:=]?+\\s*+(.+)");
    private static final String _RVPF_PACKAGE = "org.rvpf";
    private final Map<String, Set<String>> _entryNamesMap = new LinkedHashMap<String, Set<String>>();
    private final List<Class<?>> _messagesClasses = new LinkedList();
    private final String _packageName;

    private MessagesVerifier(String packageName) {
        this._packageName = packageName;
    }

    public static void main(@Nonnull String[] args) {
        _LOGGER.reset();
        MessagesVerifier verifier = new MessagesVerifier(args.length > 0 ? args[0] : _RVPF_PACKAGE);
        verifier._verifyMessages();
        System.exit(_LOGGER.hasLogged(Logger.LogLevel.WARN) ? 1 : 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> _readMessagesNames(File resource) {
        LinkedList<String> names = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(resource), StandardCharsets.UTF_8));){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return names;
                }
                if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith("!")) continue;
                Matcher matcher = _MESSAGE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    names.add(matcher.group(1));
                    try {
                        new MessageFormat(matcher.group(2), Locale.ROOT);
                    }
                    catch (IllegalArgumentException exception) {
                        _LOGGER.warn((Messages.Entry)ToolsMessages.BAD_MESSAGE, new Object[]{resource, matcher.group(1), exception.getMessage()});
                    }
                    continue;
                }
                _LOGGER.warn((Messages.Entry)ToolsMessages.BAD_LINE, new Object[]{resource, line});
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static File _relativeFile(File absoluteFile) {
        int index;
        File currentDirectory = new File(".").getAbsoluteFile().getParentFile();
        String currentPath = currentDirectory.getPath();
        String absolutePath = absoluteFile.getPath();
        for (index = 0; index < currentPath.length() && absolutePath.charAt(index) == currentPath.charAt(index); ++index) {
        }
        File rootDirectory = new File(currentPath.substring(0, index));
        if (!rootDirectory.isDirectory()) {
            return absoluteFile;
        }
        if (!currentDirectory.equals(rootDirectory)) {
            return null;
        }
        String relativePath = absolutePath.substring(index);
        if (relativePath.startsWith(File.separator)) {
            relativePath = relativePath.substring(1);
        }
        return new File(relativePath);
    }

    private static void _verifyMessagesResource(File resource, Class<?> messagesClass) {
        File relativeResource = MessagesVerifier._relativeFile(resource);
        if (relativeResource == null) {
            return;
        }
        _LOGGER.debug((Messages.Entry)ToolsMessages.VERIFYING_MESSAGES_RESOURCE, new Object[]{relativeResource});
        List<String> names = MessagesVerifier._readMessagesNames(resource);
        HashSet<String> namesSet = new HashSet<String>();
        String previousName = "";
        for (String name : names) {
            if (!namesSet.add(name)) {
                _LOGGER.warn((Messages.Entry)ToolsMessages.DUPLICATE_MESSAGE_NAME, new Object[]{name});
            }
            if (name.compareToIgnoreCase(previousName) <= 0) {
                _LOGGER.warn((Messages.Entry)ToolsMessages.MESSAGE_NAME_ORDER, new Object[]{name, relativeResource});
            }
            previousName = name;
            try {
                Enum.valueOf(messagesClass, name);
            }
            catch (IllegalArgumentException exception) {
                _LOGGER.warn((Messages.Entry)ToolsMessages.MESSAGE_NAME_NOT_DEFINED, new Object[]{name, relativeResource, messagesClass.getName()});
            }
        }
        boolean isBase = resource.getName().indexOf(95) < 0;
        ?[] entries = messagesClass.getEnumConstants();
        int missingNames = 0;
        for (Object object : entries) {
            Messages.Entry entry = (Messages.Entry)object;
            if (namesSet.contains(entry.name())) continue;
            Message message = new Message((Messages.Entry)ToolsMessages.MESSAGE_NAME_MISSING, new Object[]{entry.name(), relativeResource});
            if (isBase) {
                _LOGGER.warn(message);
            } else {
                _LOGGER.debug(message);
            }
            ++missingNames;
        }
        if (missingNames > 0 && !isBase) {
            _LOGGER.info((Messages.Entry)ToolsMessages.MISSING_MESSAGE_NAMES, new Object[]{relativeResource, String.valueOf(missingNames)});
        }
    }

    private List<File> _getRootDirectories() {
        Enumeration<URL> urls;
        LinkedList<File> roots = new LinkedList<File>();
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(this._packageName.replace('.', '/'));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
            File file = new File(url.getFile());
            Require.success((boolean)file.isDirectory());
            roots.add(file);
        }
        return roots;
    }

    private void _loadMessagesClasses() {
        for (File directory : this._getRootDirectories()) {
            if (MessagesVerifier._relativeFile(directory) == null) continue;
            this._loadMessagesClasses(directory, this._packageName);
        }
    }

    private void _loadMessagesClasses(File directory, String prefix) {
        String[] entries;
        for (String entry : entries = (String[])Require.notNull((Object)directory.list())) {
            if (entry.indexOf(46) >= 0) {
                if (!entry.endsWith(_MESSAGES_CLASS)) continue;
                try {
                    Class<?> entryClass = Class.forName(prefix + '.' + entry.substring(0, entry.length() - _CLASS.length()), false, Thread.currentThread().getContextClassLoader());
                    if (!Messages.Entry.class.isAssignableFrom(entryClass)) continue;
                    Class.forName(entryClass.getName(), true, Thread.currentThread().getContextClassLoader());
                    this._messagesClasses.add(entryClass);
                    continue;
                }
                catch (ClassNotFoundException exception) {
                    throw new RuntimeException(exception);
                }
            }
            File subdirectory = new File(directory, entry);
            if (!subdirectory.isDirectory()) continue;
            this._loadMessagesClasses(subdirectory, prefix + '.' + entry);
        }
    }

    private void _scanClasses(File directory) {
        File[] files;
        for (File file : files = (File[])Require.notNull((Object)directory.listFiles())) {
            ClassConstantsLoader loader;
            if (file.isDirectory()) {
                this._scanClasses(file);
                continue;
            }
            if (!file.getName().endsWith(_CLASS)) continue;
            try {
                loader = new ClassConstantsLoader(file);
            }
            catch (ClassFormatError exception) {
                _LOGGER.warn((Messages.Entry)ToolsMessages.FORMAT_ERROR, new Object[]{file, exception.getMessage()});
                continue;
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            if (this._entryNamesMap.containsKey(loader.getClassName())) continue;
            for (String className : loader.getClassNames()) {
                Set<String> entryNames = this._entryNamesMap.get(className);
                if (entryNames == null || entryNames.isEmpty()) continue;
                for (String fieldName : loader.getFieldNames(className)) {
                    entryNames.remove(fieldName);
                }
            }
        }
    }

    private void _verifyMessages() {
        this._loadMessagesClasses();
        this._verifyMessagesClasses();
        this._verifyMessagesResources();
        this._verifyMessagesReferences();
        if (_LOGGER.hasLogged(Logger.LogLevel.WARN)) {
            _LOGGER.info((Messages.Entry)ToolsMessages.MESSAGES_VERIFICATION_FAILED, new Object[0]);
        } else {
            _LOGGER.info((Messages.Entry)ToolsMessages.MESSAGES_VERIFICATION_SUCCESSFUL, new Object[0]);
        }
    }

    private void _verifyMessagesClasses() {
        _LOGGER.info((Messages.Entry)ToolsMessages.VERIFYING_MESSAGES_CLASSES, new Object[0]);
        for (Class<?> messagesClass : this._messagesClasses) {
            String className = messagesClass.getName();
            ?[] entries = messagesClass.getEnumConstants();
            if (entries.length > 0) {
                _LOGGER.debug((Messages.Entry)ToolsMessages.VERIFYING_MESSAGES_CLASS, new Object[]{className});
                LinkedHashSet<String> entryNames = new LinkedHashSet<String>();
                String previousName = "";
                for (Object object : entries) {
                    Messages.Entry entry = (Messages.Entry)object;
                    if (entry.name().compareToIgnoreCase(previousName) <= 0) {
                        _LOGGER.warn((Messages.Entry)ToolsMessages.MESSAGE_ENTRY_ORDER, new Object[]{entry.name(), className});
                    }
                    previousName = entry.name();
                    entryNames.add(previousName);
                }
                this._entryNamesMap.put(className, entryNames);
                continue;
            }
            _LOGGER.info((Messages.Entry)ToolsMessages.CLASS_NO_ENTRIES, new Object[]{className});
        }
    }

    private void _verifyMessagesReferences() {
        _LOGGER.info((Messages.Entry)ToolsMessages.SCANNING_MESSAGE_REFERENCES, new Object[0]);
        for (File file : this._getRootDirectories()) {
            File relativeDirectory = MessagesVerifier._relativeFile(file);
            if (relativeDirectory == null) continue;
            _LOGGER.debug((Messages.Entry)ToolsMessages.SCANNING_MESSAGE_REFERENCES_UNDER, new Object[]{relativeDirectory});
            this._scanClasses(file);
        }
        for (Map.Entry entry : this._entryNamesMap.entrySet()) {
            for (String entryName : (Set)entry.getValue()) {
                _LOGGER.warn((Messages.Entry)ToolsMessages.MESSAGE_ENTRY_UNREFERENCED, new Object[]{entry.getKey(), entryName});
            }
        }
    }

    private void _verifyMessagesResources() {
        _LOGGER.info((Messages.Entry)ToolsMessages.VERIFYING_MESSAGES_RESOURCES, new Object[0]);
        for (Class<?> messagesClass : this._messagesClasses) {
            File[] resources;
            ?[] entries = messagesClass.getEnumConstants();
            if (entries.length <= 0) continue;
            String bundleName = ((Messages.Entry)entries[0]).getBundleName();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL bundleURL = classLoader.getResource(bundleName.replace('.', '/') + ".properties");
            if (bundleURL == null) {
                _LOGGER.error((Messages.Entry)ToolsMessages.MESSAGE_RESOURCE_NOT_FOUND, new Object[]{bundleName});
                continue;
            }
            File bundleBase = new File(bundleURL.getFile());
            File directory = bundleBase.getParentFile();
            String baseName = bundleBase.getName();
            int periodIndex = baseName.indexOf(46);
            final String namePrefix = baseName.substring(0, periodIndex);
            final String nameSuffix = baseName.substring(periodIndex);
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String fileName;
                    if (!file.isDirectory() && (fileName = file.getName()).startsWith(namePrefix) && fileName.endsWith(nameSuffix)) {
                        return fileName.length() == namePrefix.length() + nameSuffix.length() || fileName.charAt(namePrefix.length()) == '_';
                    }
                    return false;
                }
            };
            if (directory == null || !directory.exists()) continue;
            for (File resource : resources = (File[])Require.notNull((Object)directory.listFiles(fileFilter))) {
                MessagesVerifier._verifyMessagesResource(resource, messagesClass);
            }
        }
    }
}

