/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.jnlp.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.jnlp.launcher.Loader;

@ThreadSafe
public final class Launcher
implements Runnable,
Thread.UncaughtExceptionHandler {
    public static final String DEFAULT_LOADER_CLASS = "org.rvpf.jnlp.loader.LoaderImpl";
    public static final String DEFAULT_LOADER_JAR = "lib/rvpf-jnlp-loader.jar";
    public static final String LOADER_CLASS_PROPERTY = "rvpf.jnlp.loader.class";
    public static final String LOADER_JAR_PROPERTY = "rvpf.jnlp.loader.jar";
    private String[] _arguments;
    private Optional<URL> _jnlpURL;
    private String _mainClassName;
    private Map<String, String> _properties;
    private boolean _success;
    private URL[] _urls;

    private Launcher() {
    }

    public static void main(@Nonnull String[] args) {
        Launcher launcher = new Launcher();
        Thread.setDefaultUncaughtExceptionHandler(launcher);
        try {
            launcher._launch(args);
        }
        catch (Throwable throwable) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
        }
    }

    @Override
    public void run() {
        try {
            URL loaderJar = Launcher._getJarURL(LOADER_JAR_PROPERTY, DEFAULT_LOADER_JAR);
            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{loaderJar}));
            Loader loader = (Loader)Class.forName(System.getProperty(LOADER_CLASS_PROPERTY, DEFAULT_LOADER_CLASS), true, Thread.currentThread().getContextClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (loader.loadJNLP(this._jnlpURL)) {
                this._urls = loader.getURLs();
                this._mainClassName = loader.getMainClassName();
                this._arguments = loader.getArguments();
                this._properties = loader.getProperties();
                this._success = true;
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.SEVERE, "Exception in thread \"" + thread.getName() + "\": ", throwable);
    }

    private static URL _getJarURL(String jarProperty, String defaultJar) throws Exception {
        String name = System.getProperty(jarProperty, defaultJar);
        File file = new File(name);
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return file.toURI().toURL();
    }

    private void _launch(String[] args) throws Exception {
        this._jnlpURL = args.length > 0 ? Optional.of(new URL(args[0])) : Optional.empty();
        Thread thread = new Thread(this);
        thread.start();
        thread.join();
        if (this._success) {
            URLClassLoader classLoader = new URLClassLoader(this._urls);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> mainClass = Class.forName(this._mainClassName, true, Thread.currentThread().getContextClassLoader());
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] jnlpArgs = this._arguments;
            String[] arguments = new String[args.length - 1 + jnlpArgs.length];
            System.arraycopy(args, 1, arguments, 0, args.length - 1);
            System.arraycopy(jnlpArgs, 0, arguments, args.length - 1, jnlpArgs.length);
            for (Map.Entry<String, String> entry : this._properties.entrySet()) {
                System.setProperty(entry.getKey(), entry.getValue());
            }
            mainMethod.invoke(null, new Object[]{arguments});
        }
    }
}

