@ECHO OFF

REM $Id: wrap.cmd 3852 2018-12-06 19:56:12Z SFB $

REM NOTE If RVPF_ACTION is defined, must be executed 'as administrator'!

REM NOTE The system 'Administrators' account must then have complete
REM NOTE access to the 'RVPF' directory!

SETLOCAL EnableDelayedExpansion

SET JVM_MODE=server
SET JVM_OPTIONS=-ea

SET STOP_TIMEOUT=30

SET LOG_LEVEL=Debug

SET DISPLAY_NAME=RVPF '!RVPF_TARGET!' service

CALL "!RVPF_CONFIG!/wrap/!RVPF_TARGET!"

SET LOG_PATH=!RVPF_LOG!

IF DEFINED USER_LANGUAGE SET JVM_OPTIONS=!JVM_OPTIONS! -Duser.language=!USER_LANGUAGE!

IF NOT DEFINED RVPF_ACTION (
    SET CLASSPATH=!CLASS_PATH:/=\!
    SET JVM_OPTIONS=!JVM_OPTIONS:;= !
    IF DEFINED JVM_MODE SET JVM_OPTIONS=-!JVM_MODE! !JVM_OPTIONS!
    IF DEFINED INITIAL_MEMORY SET JVM_OPTIONS=!JVM_OPTIONS! -Xms!INITIAL_MEMORY!M
    IF DEFINED MAXIMUM_MEMORY SET JVM_OPTIONS=!JVM_OPTIONS! -Xmx!MAXIMUM_MEMORY!M
    IF DEFINED STACK_SIZE SET JVM_OPTIONS=!JVM_OPTIONS! -Xss!STACK_SIZE!M
    IF DEFINED LIBRARY_PATH SET PATH=!LIBRARY_PATH:/=\!;!PATH!
    ECHO Executing !DISPLAY_NAME!...
    !JAVA! !JVM_OPTIONS! !MAIN_CLASS! !PARAMETERS!
) ELSE IF "!RVPF_ACTION!"=="run" (
    ECHO Running !DISPLAY_NAME!...
    "!RVPF_BIN!/rvpf-service" run !SERVICE_NAME!
) ELSE IF "!RVPF_ACTION!"=="install" (
    ECHO Installing !DISPLAY_NAME!...
    SET PR_StartMode=jvm
    SET PR_StartPath=!CD!
    SET PR_StopMode=jvm
    SET PR_StopClass=org.rvpf.base.tool.SystemExit
    SET PR_StdOutput=auto
    SET PR_StdError=auto
    IF DEFINED JAVA_HOME SET PR_Jvm=!JAVA_HOME!/jre/bin/!JVM_MODE!/jvm.dll
    IF DEFINED MAIN_CLASS SET PR_StartClass=!MAIN_CLASS!
    IF DEFINED PARAMETERS SET PR_StartParams=!PARAMETERS!
    IF DEFINED ENVIRONMENT SET PR_Environment=!ENVIRONMENT!
    IF DEFINED JVM_OPTIONS SET PR_JvmOptions=!JVM_OPTIONS!
    IF DEFINED CLASS_PATH SET PR_Classpath=!CLASS_PATH!
    IF DEFINED LIBRARY_PATH SET PR_LibraryPath=!LIBRARY_PATH!
    IF DEFINED INITIAL_MEMORY SET PR_JvmMs=!INITIAL_MEMORY!
    IF DEFINED MAXIMUM_MEMORY SET PR_JvmMx=!MAXIMUM_MEMORY!
    IF DEFINED STACK_SIZE SET PR_JvmSs=!STACK_SIZE!
    IF DEFINED LOG_PATH SET PR_LogPath=!LOG_PATH!
    IF DEFINED LOG_PREFIX SET PR_LogPrefix=!LOG_PREFIX!
    IF DEFINED LOG_LEVEL SET PR_LogLevel=!LOG_LEVEL!
    IF DEFINED SERVICE_DISPLAY_NAME SET PR_DisplayName=!SERVICE_DISPLAY_NAME!
    IF DEFINED SERVICE_DESCRIPTION SET PR_Description=!SERVICE_DESCRIPTION!
    IF DEFINED SERVICE_DEPENDS_ON SET PR_DependsOn=!SERVICE_DEPENDS_ON!
    IF DEFINED SERVICE_STARTUP SET PR_Startup=!SERVICE_STARTUP!
    IF DEFINED STOP_TIMEOUT SET PR_StopTimeout=!STOP_TIMEOUT!
    "!RVPF_BIN!/rvpf-service" install !SERVICE_NAME!
) ELSE IF "!RVPF_ACTION!"=="remove" (
    ECHO Removing !DISPLAY_NAME!...
    "!RVPF_BIN!/rvpf-service" delete !SERVICE_NAME!
) ELSE IF "!RVPF_ACTION!"=="start" (
    ECHO Starting !DISPLAY_NAME!...
    NET START !SERVICE_NAME!
) ELSE IF "!RVPF_ACTION!"=="stop" (
    ECHO Stopping !DISPLAY_NAME!...
    NET STOP !SERVICE_NAME!
) ELSE IF "!RVPF_ACTION!"=="restart" (
    ECHO Stopping !DISPLAY_NAME!...
    NET STOP !SERVICE_NAME!
    ECHO Starting !DISPLAY_NAME!...
    NET START !SERVICE_NAME!
) ELSE IF "!RVPF_ACTION!"=="automatic" (
    ECHO Setting !DISPLAY_NAME! automatic start...
    "!RVPF_BIN!/rvpf-service" update !SERVICE_NAME! --Startup=auto
) ELSE IF "!RVPF_ACTION!"=="manual" (
    ECHO Setting !DISPLAY_NAME! manual start...
    "!RVPF_BIN!/rvpf-service" update !SERVICE_NAME! --Startup=manual
)

REM End.
