/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input.pap;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPServer;
import org.rvpf.pap.PAPSupport;

public abstract class PAPModule
extends InputModule {
    private String[] _originNames;

    public boolean needsMetadata() {
        return true;
    }

    public boolean onMetadataRefreshed() {
        if (!super.onMetadataRefreshed() || !this.loadMetadata()) {
            return false;
        }
        PAPSupport support = this.newSupport();
        PAPContext serverContext = support.newServerContext(this.getMetadata(), this._originNames, Optional.of(this.getTraces()));
        ((PAPInput)this.getInput()).replaceServer(support.newServer(serverContext));
        return true;
    }

    @CheckReturnValue
    protected boolean loadMetadata() {
        return this.loadMetadata(new _MetadataFilter());
    }

    @Nonnull
    @CheckReturnValue
    protected abstract PAPInput newInput(@Nonnull PAPServer var1);

    @Nonnull
    @CheckReturnValue
    protected abstract PAPSupport newSupport();

    @Nonnull
    @CheckReturnValue
    protected abstract KeyedGroups protocolProperties(@Nonnull KeyedGroups var1);

    protected boolean setUp(KeyedGroups moduleProperties) {
        PAPServer server;
        if (!this.loadMetadata()) {
            return false;
        }
        KeyedGroups protocolProperties = this.protocolProperties(moduleProperties);
        this._originNames = protocolProperties.getStrings("origin");
        PAPSupport support = this.newSupport();
        PAPContext serverContext = support.newServerContext(this.getMetadata(), this._originNames, Optional.of(this.getTraces()));
        PAPServer pAPServer = server = serverContext != null ? support.newServer(serverContext) : null;
        if (server == null || !server.setUp(protocolProperties)) {
            return false;
        }
        this.setInput((InputModule.ModuleInput)this.newInput(server));
        return super.setUp(moduleProperties);
    }

    @Nonnull
    @CheckReturnValue
    protected abstract String usage();

    private final class _MetadataFilter
    extends MetadataFilter {
        _MetadataFilter() {
            super(false);
        }

        public boolean areAttributesNeeded() {
            return true;
        }

        public boolean areAttributesNeeded(String usage) {
            return PAPModule.this.usage().equalsIgnoreCase(usage);
        }

        public final boolean areContentsNeeded() {
            return true;
        }

        public boolean areOriginsFiltered() {
            return true;
        }

        public boolean areOriginsNeeded() {
            return true;
        }

        public boolean arePointsNeeded() {
            return true;
        }

        public boolean isOriginNeeded(OriginEntity originEntity) {
            return originEntity.getAttributes(PAPModule.this.usage()).isPresent();
        }

        public boolean isPointNeeded(PointEntity pointEntity) {
            return pointEntity.getAttributes(PAPModule.this.usage()).isPresent();
        }
    }

    protected abstract class PAPInput
    extends InputModule.AbstractInput {
        private final AtomicBoolean _closed = new AtomicBoolean();
        private volatile PAPServer _server;

        protected PAPInput(PAPServer server) {
            this._server = server;
        }

        public void close() {
            if (this._closed.compareAndSet(false, true)) {
                this._server.stop();
            }
        }

        public Optional<Serializable[]> input(BatchControl batchControl) throws InterruptedException {
            PointValue pointValue;
            int limit = batchControl.getLimit();
            LinkedList<PointValue> pointValues = new LinkedList<PointValue>();
            long timeout = -1L;
            batchControl.reset();
            while ((pointValue = (PointValue)this.getServer().nextUpdate(timeout).orElse(null)) != null) {
                pointValues.add(pointValue);
                if (pointValues.size() >= limit) break;
                Optional wait = batchControl.getWait();
                if (!wait.isPresent()) continue;
                timeout = ((ElapsedTime)wait.get()).toMillis();
            }
            return Optional.of(pointValues.toArray(new PointValue[pointValues.size()]));
        }

        public boolean isClosed() {
            return this._closed.get();
        }

        public boolean open() {
            this._closed.set(false);
            this._server.start();
            return true;
        }

        public void replaceServer(@Nonnull PAPServer server) {
            this.close();
            this._server = server;
            this.open();
        }

        public void tearDown() {
            this.close();
            super.tearDown();
        }

        @Nonnull
        @CheckReturnValue
        protected PAPServer getServer() {
            return this._server;
        }
    }
}

