/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;

public interface PAPClient {
    public boolean addConnectionListener(@Nonnull PAPConnectionListener var1);

    public void close();

    @CheckReturnValue
    public boolean connect(@Nonnull Origin var1) throws InterruptedException;

    public void disconnect();

    public void disconnect(@Nonnull Origin var1);

    @Nonnull
    @CheckReturnValue
    public PointValue[] fetchPointValues(@Nonnull Point[] var1) throws InterruptedException, ServiceNotAvailableException;

    @Nonnull
    @CheckReturnValue
    public Optional<Origin> getOrigin(@Nonnull Optional<String> var1);

    @Nonnull
    @CheckReturnValue
    public Optional<? extends PAPProxy> getPointProxy(Point var1);

    @CheckReturnValue
    public boolean isPointActive(@Nonnull Point var1);

    public void open();

    public boolean removeConnectionListener(PAPConnectionListener var1);

    @Nonnull
    @CheckReturnValue
    public Exception[] updatePointValues(@Nonnull PointValue[] var1) throws InterruptedException, ServiceNotAvailableException;

    public static abstract class Abstract
    implements PAPClient,
    PAPConnectionListener {
        private final PAPConnectionListener.Manager _connectionListenerManager = new PAPConnectionListener.Manager();
        private final PAPContext _context;
        private final Map<Origin, PAPProxy> _knownServerProxies = new IdentityHashMap<Origin, PAPProxy>();
        private final Logger _logger = Logger.getInstance(this.getClass());

        protected Abstract(@Nonnull PAPContext clientContext) {
            this._context = clientContext;
        }

        @Override
        public final boolean addConnectionListener(PAPConnectionListener connectionListener) {
            return this._connectionListenerManager.addListener(connectionListener);
        }

        @Override
        public void close() {
            this._connectionListenerManager.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void disconnect() {
            Map<Origin, PAPProxy> map = this._knownServerProxies;
            synchronized (map) {
                ArrayList<PAPProxy> knownServerProxies = new ArrayList<PAPProxy>(this._knownServerProxies.values());
                for (PAPProxy knownServerProxyroxy : knownServerProxies) {
                    this.disconnect(knownServerProxyroxy.getOrigin());
                }
            }
        }

        @Override
        public final Optional<Origin> getOrigin(Optional<String> originName) {
            return this.getContext().getRemoteOrigin(originName);
        }

        @Override
        public final Optional<? extends PAPProxy> getPointProxy(Point point) {
            return this.getContext().getRemoteProxy(point);
        }

        @Override
        public boolean isPointActive(Point point) {
            return this.getContext().isPointActive(point);
        }

        @Override
        public final boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
            return this._connectionListenerManager.onLostConnection(remoteProxy, cause);
        }

        @Override
        public final boolean onNewConnection(PAPProxy remoteProxy) {
            return this._connectionListenerManager.onNewConnection(remoteProxy);
        }

        @Override
        public final boolean removeConnectionListener(PAPConnectionListener connectionListener) {
            return this._connectionListenerManager.removeListener(connectionListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        protected final Optional<PAPProxy> forgetServerProxy(@Nonnull Origin origin) {
            PAPProxy knownServerProxy;
            Map<Origin, PAPProxy> map = this._knownServerProxies;
            synchronized (map) {
                knownServerProxy = this._knownServerProxies.get(Require.notNull((Object)origin));
                if (knownServerProxy != null) {
                    this.forgetServerProxy(knownServerProxy);
                }
            }
            return Optional.ofNullable(knownServerProxy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void forgetServerProxy(@Nonnull PAPProxy knownServerProxy) {
            Map<Origin, PAPProxy> map = this._knownServerProxies;
            synchronized (map) {
                this._knownServerProxies.remove(knownServerProxy.getOrigin());
                knownServerProxy.disconnect();
            }
        }

        @Nonnull
        @CheckReturnValue
        protected final PAPContext getContext() {
            return this._context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        @CheckReturnValue
        protected final Collection<PAPProxy> getKnownServerProxies() {
            Map<Origin, PAPProxy> map = this._knownServerProxies;
            synchronized (map) {
                return this._knownServerProxies.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        @CheckReturnValue
        protected Optional<? extends PAPProxy> getServerProxy(@Nonnull Origin origin) {
            PAPProxy knownServerProxy;
            Map<Origin, PAPProxy> map = this._knownServerProxies;
            synchronized (map) {
                knownServerProxy = this._knownServerProxies.get(origin);
                if (knownServerProxy == null) {
                    Optional<? extends PAPProxy> serverProxy = this.getContext().getRemoteProxyByOrigin(origin);
                    if (serverProxy.isPresent()) {
                        knownServerProxy = serverProxy.get().copy();
                        this._knownServerProxies.put(origin, knownServerProxy);
                        knownServerProxy.setConnectionListener(this);
                    } else {
                        this.getThisLogger().warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN, new Object[]{origin});
                    }
                }
            }
            return Optional.ofNullable(knownServerProxy);
        }

        @Nonnull
        @CheckReturnValue
        protected final Logger getThisLogger() {
            return this._logger;
        }
    }
}

