/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.pap.PAPMessages;

public interface PAPConnection {
    public void close();

    @CheckReturnValue
    public boolean isClosed();

    public static abstract class Abstract
    implements PAPConnection {
        private final AtomicBoolean _closed = new AtomicBoolean();

        @Override
        public final void close() {
            if (this._closed.compareAndSet(false, true)) {
                try {
                    this.doClose();
                }
                catch (IOException exception) {
                    this.getThisLogger().debug((Messages.Entry)PAPMessages.CLOSE_FAILED, new Object[]{this.getName(), exception});
                }
            }
        }

        @Override
        public final boolean isClosed() {
            return this._closed.get();
        }

        protected abstract void doClose() throws IOException;

        @Nonnull
        @CheckReturnValue
        protected abstract String getName();

        @Nonnull
        @CheckReturnValue
        protected final Logger getThisLogger() {
            return Logger.getInstance(this.getClass());
        }
    }
}

