/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.value.filter.ValueFilter;
import org.rvpf.document.loader.MetadataDocumentLoader;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPMetadataFilter;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.PAPSupport;
import org.rvpf.pap.PAPVersion;

public abstract class PAPContext {
    private final Set<Point> _inactivePoints = new IdentityHashSet();
    private final Logger _logger;
    private final Metadata _metadata;
    private final Map<Origin, PAPProxy> _remoteProxyByOrigin = new IdentityHashMap<Origin, PAPProxy>();
    private final Map<UUID, Point> _remotePointByUUID = new HashMap<UUID, Point>();
    private final Map<String, Origin> _remoteOriginByName = new HashMap<String, Origin>();
    private final PAPSupport _support;
    private final Traces _traces;
    private final Map<Point, ValueFilter> _valueFilters = new IdentityHashMap<Point, ValueFilter>();

    protected PAPContext(@Nonnull PAPSupport support, @Nonnull Optional<Metadata> metadata, @Nonnull Optional<Traces> traces) {
        Require.notNull((Object)support);
        this._support = (PAPSupport)Require.notNull((Object)support);
        this._metadata = metadata.orElse(null);
        this._traces = traces.orElse(new Traces());
        this._logger = Logger.getInstance(this.getClass());
        PAPVersion papVersion = new PAPVersion();
        papVersion.logSpecification(true);
        papVersion.logImplementation(true);
    }

    @Nullable
    @CheckReturnValue
    public static Metadata fetchMetadata(@Nonnull PAPMetadataFilter metadataFilter, @Nonnull Optional<String> from, @Nonnull Optional<UUID> uuid) {
        Metadata metadata = MetadataDocumentLoader.fetchMetadata((MetadataFilter)((MetadataFilter)Require.notNull((Object)((Object)metadataFilter))), Optional.empty(), uuid, from);
        if (metadata != null) {
            if (!metadata.validatePointsRelationships()) {
                return null;
            }
            metadata.cleanUp();
        }
        return metadata;
    }

    @CheckReturnValue
    public abstract boolean addRemoteOrigin(@Nonnull Origin var1, @Nonnull Attributes var2);

    @CheckReturnValue
    public abstract boolean addRemotePoint(@Nonnull Point var1, @Nonnull Attributes var2);

    @Nonnull
    @CheckReturnValue
    public final Metadata getMetadata() {
        return this._metadata;
    }

    @Nonnull
    @CheckReturnValue
    public abstract String getProtocolName();

    @Nonnull
    @CheckReturnValue
    public final Optional<Origin> getRemoteOrigin(@Nonnull Optional<String> remoteOriginName) {
        if (remoteOriginName.isPresent()) {
            return Optional.ofNullable(this._remoteOriginByName.get(remoteOriginName.get().trim().toUpperCase(Locale.ROOT)));
        }
        return Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Point> getRemotePoint(@Nonnull UUID uuid) {
        return Optional.ofNullable(this._remotePointByUUID.get(uuid));
    }

    @Nonnull
    @CheckReturnValue
    public final Collection<Point> getRemotePoints() {
        return this._remotePointByUUID.values();
    }

    @Nonnull
    @CheckReturnValue
    public Collection<? extends PAPProxy> getRemoteProxies() {
        return this._remoteProxyByOrigin.values();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<? extends PAPProxy> getRemoteProxy(Point remotePoint) {
        Optional origin = remotePoint.getOrigin();
        if (!origin.isPresent()) {
            this._logger.warn((Messages.Entry)PAPMessages.MISSING_ORIGIN, new Object[]{remotePoint});
            return Optional.empty();
        }
        Optional<? extends PAPProxy> remoteProxy = this.getRemoteProxyByOrigin((Origin)origin.get());
        if (!remoteProxy.isPresent()) {
            this._logger.warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN, new Object[]{((Origin)origin.get()).getName().get()});
        }
        return remoteProxy;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<? extends PAPProxy> getRemoteProxyByOrigin(Origin remoteOrigin) {
        return Optional.ofNullable(this._remoteProxyByOrigin.get(remoteOrigin));
    }

    @Nonnull
    @CheckReturnValue
    public PAPSupport getSupport() {
        return this._support;
    }

    @Nonnull
    @CheckReturnValue
    public final Traces getTraces() {
        return this._traces;
    }

    @Nonnull
    @CheckReturnValue
    public final Map<Point, ValueFilter> getValueFilters() {
        return this._valueFilters;
    }

    @CheckReturnValue
    public final boolean hasLogged(@Nonnull Logger.LogLevel logLevel) {
        return this._logger.hasLogged(logLevel);
    }

    @CheckReturnValue
    public abstract boolean isClientContext();

    @CheckReturnValue
    public final boolean isPointActive(@Nonnull Point point) {
        return !this._inactivePoints.contains(point);
    }

    @CheckReturnValue
    public final boolean isServerContext() {
        return !this.isClientContext();
    }

    @CheckReturnValue
    public boolean setUp() {
        String attributesUsage = this._support.getAttributesUsage();
        for (Origin origin : this.getMetadata().getOriginEntities()) {
            Optional originAttributes = origin.getAttributes(attributesUsage);
            if (!originAttributes.isPresent() || !this.isRemoteOriginNeeded(origin, (Attributes)originAttributes.get()) || this.addRemoteOrigin(origin, (Attributes)originAttributes.get())) continue;
            return false;
        }
        for (Point point : this.getMetadata().getPointsCollection()) {
            Optional originAttributes;
            Optional pointAttributes = point.getAttributes(attributesUsage);
            if (!pointAttributes.isPresent()) continue;
            if (((Attributes)pointAttributes.get()).getBoolean("INACTIVE")) {
                this._inactivePoints.add(point);
            }
            if (!(originAttributes = ((Origin)point.getOrigin().get()).getAttributes(((Attributes)pointAttributes.get()).getUsage())).isPresent() || !this.isRemotePointNeeded(point, (Attributes)pointAttributes.get())) continue;
            if (!this.addRemotePoint(point, (Attributes)pointAttributes.get()) && this.hasLogged(Logger.LogLevel.ERROR)) {
                return false;
            }
            if (!((Attributes)originAttributes.get()).getBoolean("INACTIVE")) continue;
            this._inactivePoints.add(point);
        }
        return !this.hasLogged(Logger.LogLevel.WARN);
    }

    public void tearDown() {
        this._valueFilters.clear();
        this._remotePointByUUID.clear();
        this._remoteOriginByName.clear();
        this._remoteProxyByOrigin.clear();
        this._traces.tearDown();
    }

    @CheckReturnValue
    protected int getDefaultPortForRemoteOrigin() {
        return 0;
    }

    @Nonnull
    @CheckReturnValue
    protected final Map<Origin, PAPProxy> getRemoteProxyByOrigin() {
        return Collections.unmodifiableMap(this._remoteProxyByOrigin);
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    @CheckReturnValue
    protected boolean isRemoteOriginNeeded(@Nonnull Origin remoteOrigin, @Nonnull Attributes originAttributes) {
        return true;
    }

    @CheckReturnValue
    protected boolean isRemotePointNeeded(@Nonnull Point remotePoint, @Nonnull Attributes pointAttributes) {
        return true;
    }

    @Nonnull
    @CheckReturnValue
    protected abstract PAPProxy newRemoteProxy(@Nonnull Origin var1);

    protected final void registerRemotePoint(@Nonnull Point remotePoint) {
        ValueFilter valueFilter = remotePoint.filter();
        if (!valueFilter.isDisabled()) {
            this._valueFilters.put(remotePoint, valueFilter);
        }
        this._remotePointByUUID.put((UUID)remotePoint.getUUID().get(), remotePoint);
    }

    protected final void registerRemoteProxy(@Nonnull PAPProxy remoteProxy) {
        Origin remoteOrigin = remoteProxy.getOrigin();
        String remoteOriginName = (String)remoteOrigin.getName().get();
        this._remoteOriginByName.put(remoteOriginName.toUpperCase(Locale.ROOT), remoteOrigin);
        this._remoteProxyByOrigin.put(remoteOrigin, remoteProxy);
        this._logger.debug((Messages.Entry)PAPMessages.CONFIGURED_PROXY, new Object[]{remoteOrigin});
    }
}

