/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;

public abstract class PAPProxy {
    private PAPConnectionListener _connectionListener;
    private Point _connectionStatePoint;
    private final PAPContext _context;
    private final Logger _logger;
    private final Origin _origin;

    protected PAPProxy(@Nonnull PAPProxy other) {
        this._context = other._context;
        this._origin = other._origin;
        this._logger = other._logger;
        this._connectionStatePoint = other._connectionStatePoint;
    }

    protected PAPProxy(@Nonnull PAPContext context, @Nonnull Origin origin) {
        this._context = (PAPContext)Require.notNull((Object)context);
        this._origin = (Origin)Require.notNull((Object)origin);
        this._logger = Logger.getInstance(this.getClass());
    }

    @Nonnull
    @CheckReturnValue
    public abstract PAPProxy copy();

    public void disconnect() {
        this._connectionListener = null;
    }

    @Nonnull
    @CheckReturnValue
    public PAPConnectionListener getConnectionListener() {
        return (PAPConnectionListener)Require.notNull((Object)this._connectionListener);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Point> getConnectionStatePoint() {
        return Optional.ofNullable(this._connectionStatePoint);
    }

    @Nonnull
    @CheckReturnValue
    public PAPContext getContext() {
        return this._context;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getName() {
        return this._origin.getName();
    }

    @Nonnull
    @CheckReturnValue
    public final Origin getOrigin() {
        return this._origin;
    }

    public final void setConnectionListener(@Nonnull PAPConnectionListener connectionListener) {
        this._connectionListener = (PAPConnectionListener)Require.notNull((Object)connectionListener);
    }

    @CheckReturnValue
    public final boolean setConnectionStatePoint(@Nonnull Point connectionStatePoint) {
        if (this._connectionStatePoint != null) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MULTIPLE_CONNECTION_STATE, new Object[]{this.getOrigin()});
            return false;
        }
        this._connectionStatePoint = connectionStatePoint;
        return true;
    }

    @CheckReturnValue
    public boolean supportsWildcardAddress() {
        return false;
    }

    public String toString() {
        return "Node " + (String)this.getName().orElse(null);
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    public static interface Responder {
        @Nonnull
        @CheckReturnValue
        public PointValue[] select(@Nonnull Point[] var1) throws InterruptedException, ServiceNotAvailableException;
    }
}

