/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPMessages;
import org.rvpf.service.ServiceMessages;

public abstract class PAPSplitter {
    private final Logger _logger = Logger.getInstance(this.getClass());

    @CheckReturnValue
    public abstract boolean setUp(@Nonnull Point var1);

    @Nonnull
    @CheckReturnValue
    public abstract Optional<Splitted> split(@Nonnull PointValue var1);

    @CheckReturnValue
    protected final int getResultPosition(@Nonnull PointRelation resultRelation) {
        String positionKey;
        Params resultRelationParams = resultRelation.getParams();
        if (resultRelationParams.containsValueKey("Index")) {
            if (resultRelationParams.containsValueKey("Offset")) {
                this.getThisLogger().warn((Messages.Entry)ServiceMessages.PARAM_CONFLICT, new Object[]{"Index", "Offset"});
                return -1;
            }
            positionKey = "Index";
        } else if (resultRelationParams.containsValueKey("Offset")) {
            positionKey = "Offset";
        } else {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_POSITION_PARAMETER, new Object[]{resultRelation.getResultPoint()});
            return -1;
        }
        int index = resultRelationParams.getInt(positionKey, -1);
        if (index < 0) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_PARAMETER_VALUE, new Object[]{positionKey, String.valueOf(index)});
        }
        return index;
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    protected static abstract class Plan {
        private final Detail[] _details;

        protected Plan(@Nonnull Detail[] details) {
            this._details = details;
        }

        @Nonnull
        @CheckReturnValue
        protected Detail[] getDetails() {
            return this._details;
        }
    }

    protected static abstract class Detail {
        private final int _bit;
        private final Point _point;
        private final int _position;

        protected Detail(@Nonnull Point point, int position, int bit) {
            this._point = point;
            this._position = position;
            this._bit = bit;
        }

        @CheckReturnValue
        public int getBit() {
            return this._bit;
        }

        @Nonnull
        @CheckReturnValue
        public Point getPoint() {
            return this._point;
        }

        @CheckReturnValue
        public int getPosition() {
            return this._position;
        }
    }

    public static final class Splitted
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<UUID, Optional<Serializable>> _splitted = new LinkedHashMap<UUID, Optional<Serializable>>();

        @Nonnull
        @CheckReturnValue
        public Optional<Serializable> get(@Nonnull Point point) {
            return this._splitted.get(point.getUUID().get());
        }

        public void put(@Nonnull Point point, @Nonnull Optional<Serializable> value) {
            this._splitted.put((UUID)point.getUUID().get(), value);
        }

        @CheckReturnValue
        public int size() {
            return this._splitted.size();
        }
    }
}

