/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.ResultValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.base.value.filter.ValueFilter;
import org.rvpf.metadata.processor.Batch;
import org.rvpf.processor.ProcessorMessages;
import org.rvpf.processor.engine.AbstractTransform;
import org.rvpf.processor.engine.pap.PAPSplitter;

public final class PAPSplitterTransform
extends AbstractTransform {
    private final Map<Point, ValueFilter> _filters = new IdentityHashMap<Point, ValueFilter>();
    private final PAPSplitter _splitter;

    public PAPSplitterTransform(@Nonnull PAPSplitter splitter) {
        this._splitter = splitter;
    }

    public Optional<PointValue> applyTo(ResultValue resultValue, Batch batch) throws InterruptedException, ServiceNotAvailableException {
        PointValue inputValue = (PointValue)resultValue.getInputValues().get(0);
        Optional<PAPSplitter.Splitted> splitted = this._splitter.split(inputValue);
        if (!splitted.isPresent()) {
            return Optional.empty();
        }
        if (inputValue.getValue() instanceof Tuple) {
            PointValue thawed = inputValue.thawed();
            thawed.setValue((Serializable)splitted.get());
            if (thawed != inputValue) {
                thawed.freeze();
            }
        }
        Point resultPoint = (Point)resultValue.getPoint().get();
        resultValue.setValue((Serializable)splitted.get().get(resultPoint).orElse(null));
        ValueFilter filter = this._filters.get(resultValue.getPoint().get());
        if (filter != null) {
            for (PointValue filteredValue : filter.filter(Optional.of(resultValue))) {
                resultValue.setValue(filteredValue.getValue());
            }
        }
        return Optional.of(resultValue);
    }

    public boolean setUp(Point point) {
        List pointInputs = point.getInputs();
        if (pointInputs.size() != 1) {
            this.getThisLogger().error((Messages.Entry)ProcessorMessages.POINT_EQ_1_INPUT, new Object[]{point});
            return false;
        }
        ValueFilter filter = point.filter();
        if (!filter.isDisabled()) {
            this._filters.put(point, point.filter());
        }
        Point splittedPoint = ((PointRelation)pointInputs.get(0)).getInputPoint();
        return this._splitter.setUp(splittedPoint);
    }
}

