/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap.captor;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.ResultValue;
import org.rvpf.metadata.processor.Batch;
import org.rvpf.processor.engine.pap.captor.CaptorEngine;
import org.rvpf.processor.engine.pap.captor.Capture;
import org.rvpf.processor.engine.pap.captor.CapturedBehavior;
import org.rvpf.processor.engine.pap.captor.CapturesBehavior;
import org.rvpf.processor.engine.rpn.Program;
import org.rvpf.processor.engine.rpn.Task;
import org.rvpf.processor.engine.rpn.selector.SelectedBehavior;
import org.rvpf.processor.engine.rpn.selector.SelectorEngine;
import org.rvpf.processor.engine.rpn.selector.SelectorTransform;
import org.rvpf.processor.engine.rpn.selector.SelectsBehavior;

public final class CaptorTransform
extends SelectorTransform {
    CaptorTransform(@Nonnull CaptorEngine engine) {
        super((SelectorEngine)engine);
    }

    protected boolean executeFinalProgram(Task task, Optional<Program> finalProgram) {
        if (!super.executeFinalProgram(task, finalProgram)) {
            return false;
        }
        Context context = (Context)task.getContext();
        for (PointValue result : context.getResults()) {
            context.addUpdate(result);
        }
        return true;
    }

    protected boolean executeInitialProgram(Task task, Optional<Program> initialProgram) {
        Context context = (Context)task.getContext();
        if (!context.getFirstStep().isPresent()) {
            return false;
        }
        return super.executeInitialProgram(task, initialProgram);
    }

    protected boolean executeStepProgram(Task task, Optional<Program> stepProgram) {
        Context context = (Context)task.getContext();
        PointValue currentStep = (PointValue)context.getCurrentStep().get();
        if (stepProgram.isPresent()) {
            PointValue result = (PointValue)context.getResult().get();
            Serializable savedState = result.getState();
            result.setStamp(currentStep.getStamp());
            result.setState(currentStep.getState());
            context.clearUpdated();
            if (!task.execute(stepProgram.get()).isPresent()) {
                return false;
            }
            if (context.isUpdated()) {
                context.addResult(result.copy());
            }
            result.setState(savedState);
        } else {
            context.addResult(currentStep.morph(context.getResultPoint(), Optional.empty()));
        }
        return true;
    }

    protected Context newContext(ResultValue resultValue, Batch batch) {
        return new Context(resultValue, batch);
    }

    protected Optional<PointValue> returnResult(ResultValue resultValue, Optional<PointValue> pointValue) {
        return Optional.of(Batch.DISABLED_UPDATE);
    }

    protected Class<? extends SelectedBehavior> selectedBehaviorClass() {
        return CapturedBehavior.class;
    }

    protected Class<? extends SelectsBehavior> selectsBehaviorClass() {
        return CapturesBehavior.class;
    }

    class Context
    extends SelectorTransform.Context {
        private final Collection<PointValue> _results;
        private boolean _updated;

        public Context(@Nonnull ResultValue resultValue, Batch batch) {
            super((SelectorTransform)CaptorTransform.this, resultValue, batch);
            this._results = new LinkedList<PointValue>();
        }

        protected void update(Serializable value) {
            super.update(value);
            this._updated = true;
        }

        void addResult(@Nonnull PointValue result) {
            this._results.add(result);
        }

        void clearUpdated() {
            this._updated = false;
        }

        @Nonnull
        @CheckReturnValue
        Capture getCapture() {
            return (Capture)((Object)this.getSelection().get());
        }

        @Nonnull
        @CheckReturnValue
        Collection<PointValue> getResults() {
            return this._results;
        }

        @CheckReturnValue
        boolean isUpdated() {
            return this._updated;
        }
    }
}

