/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap.captor;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Params;
import org.rvpf.base.PointRelation;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.ResultValue;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointInput;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.metadata.processor.Batch;
import org.rvpf.metadata.processor.BatchValuesQuery;
import org.rvpf.processor.ProcessorMessages;
import org.rvpf.processor.engine.pap.captor.Capture;
import org.rvpf.processor.engine.pap.captor.CapturesBehavior;
import org.rvpf.processor.engine.rpn.selector.SelectedBehavior;

public final class CapturedBehavior
extends SelectedBehavior {
    public static final String CAPTURE_LIMIT_PARAM = "CaptureLimit";
    public static final String CAPTURE_TIME_PARAM = "CaptureTime";
    public static final String EXCLUDE_NULLS_PARAM = "ExcludeNulls";
    private int _captureLimit;
    private Optional<ElapsedTime> _captureTime;
    private boolean _excludeNullSteps;

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        CapturedBehavior otherBehavior = (CapturedBehavior)((Object)other);
        return this._excludeNullSteps == otherBehavior._excludeNullSteps && this._captureLimit == otherBehavior._captureLimit && Objects.equals(this._captureTime, otherBehavior._captureTime);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Capture newResultValue(Optional<DateTime> stamp) {
        throw Require.failure();
    }

    public boolean prepareSelect(ResultValue resultValue, Batch batch) {
        if (!(resultValue instanceof Capture)) {
            return true;
        }
        switch (batch.getLookUpPass()) {
            case 1: {
                Capture capture = (Capture)resultValue;
                if (!capture.getStartValue().isPresent()) {
                    return true;
                }
                if (!capture.getStopValue().isPresent()) {
                    this._prepareSelectNotAfter(capture, batch);
                } else {
                    this._prepareSelectAfter(capture, batch);
                }
                return true;
            }
        }
        return true;
    }

    public boolean select(ResultValue resultValue, Batch batch) {
        if (!(resultValue instanceof Capture)) {
            this.getThisLogger().warn((Messages.Entry)ProcessorMessages.UNEXPECTED_RESULT_SET_UP, new Object[]{resultValue});
            return false;
        }
        Capture capture = (Capture)resultValue;
        if (!capture.getStartStamp().isPresent()) {
            return true;
        }
        if (!capture.getStopValue().isPresent()) {
            return this._selectNotAfter(capture, batch);
        }
        return this._selectAfter(capture, batch);
    }

    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        Optional capturedRelation = this.getRelation();
        if (capturedRelation.isPresent()) {
            Params relationParams = ((PointRelation)capturedRelation.get()).getParams();
            this._captureLimit = relationParams.getInt(CAPTURE_LIMIT_PARAM, 0);
            this._captureTime = relationParams.getElapsed(CAPTURE_TIME_PARAM, Optional.empty(), Optional.empty());
            this._excludeNullSteps = relationParams.getBoolean(EXCLUDE_NULLS_PARAM, false);
            Optional capturesRelation = this.getInput(CapturesBehavior.class, false);
            if (!capturesRelation.isPresent()) {
                return false;
            }
            ((CapturesBehavior)((Object)((PointInput)capturesRelation.get()).getPrimaryBehavior().get())).setCapturedBehavior(this);
        }
        return true;
    }

    @CheckReturnValue
    int getCaptureLimit() {
        return this._captureLimit;
    }

    @Nonnull
    @CheckReturnValue
    Optional<ElapsedTime> getCaptureTime() {
        return (Optional)Require.notNull(this._captureTime);
    }

    private void _prepareSelectAfter(Capture capture, Batch batch) {
        StoreValuesQuery.Builder storeValuesQueryBuilder = StoreValuesQuery.newBuilder().setPoint(this.getInputPoint());
        Optional startStamp = capture.getStartStamp();
        Optional stopStamp = capture.getStopStamp();
        int limitAfter = capture.getLimitAfter();
        storeValuesQueryBuilder.setAfter((DateTime)startStamp.get());
        storeValuesQueryBuilder.setNotNull(this._excludeNullSteps);
        if (stopStamp.isPresent()) {
            storeValuesQueryBuilder.setNotAfter((DateTime)stopStamp.get());
        }
        if (limitAfter > 0) {
            storeValuesQueryBuilder.setRows(limitAfter);
        }
        batch.addStoreValuesQuery(storeValuesQueryBuilder.build());
    }

    private void _prepareSelectNotAfter(Capture capture, Batch batch) {
        DateTime startStamp = (DateTime)capture.getStartStamp().get();
        int limitBefore = capture.getLimitBefore();
        Optional<ElapsedTime> timeBefore = capture.getTimeBefore();
        StoreValuesQuery.Builder storeValuesQueryBuilder = StoreValuesQuery.newBuilder().setPoint(this.getInputPoint());
        if (timeBefore.isPresent()) {
            DateTime stampBefore = startStamp.before(timeBefore.get());
            storeValuesQueryBuilder.setBefore(stampBefore);
            storeValuesQueryBuilder.setNotNull(this._excludeNullSteps);
            batch.addStoreValuesQuery(storeValuesQueryBuilder.build());
            storeValuesQueryBuilder.clear();
            storeValuesQueryBuilder.setNotAfter(startStamp);
            storeValuesQueryBuilder.setNotBefore(stampBefore);
            storeValuesQueryBuilder.setNotNull(this._excludeNullSteps);
            storeValuesQueryBuilder.setReverse(true);
            if (limitBefore > 0) {
                storeValuesQueryBuilder.setRows(limitBefore);
            }
            batch.addStoreValuesQuery(storeValuesQueryBuilder.build());
        } else {
            storeValuesQueryBuilder.setNotAfter(startStamp);
            storeValuesQueryBuilder.setNotNull(this._excludeNullSteps);
            storeValuesQueryBuilder.setRows(Math.max(limitBefore, 1));
            batch.addStoreValuesQuery(storeValuesQueryBuilder.build());
        }
    }

    private boolean _selectAfter(Capture capture, Batch batch) {
        BatchValuesQuery.Builder batchValuesQueryBuilder = BatchValuesQuery.newBuilder().setPoint(Optional.of(this.getInputPoint()));
        batchValuesQueryBuilder.setAfter((DateTime)capture.getStartStamp().get());
        batchValuesQueryBuilder.setNotAfter((DateTime)capture.getStopStamp().get());
        batchValuesQueryBuilder.setNotNull(this._excludeNullSteps);
        Collection inputValues = batch.getPointValues(batchValuesQueryBuilder.build());
        int limitAfter = capture.getLimitAfter();
        int count = 0;
        for (PointValue inputValue : inputValues) {
            if (!this.addInputToResult(inputValue, (ResultValue)capture)) {
                return false;
            }
            if (limitAfter <= 0 || ++count < limitAfter) continue;
            break;
        }
        return true;
    }

    private boolean _selectNotAfter(Capture capture, Batch batch) {
        DateTime startStamp = (DateTime)capture.getStartStamp().get();
        int limitBefore = capture.getLimitBefore();
        Optional<ElapsedTime> timeBefore = capture.getTimeBefore();
        BatchValuesQuery.Builder batchValuesQueryBuilder = BatchValuesQuery.newBuilder().setPoint(Optional.of(this.getInputPoint()));
        batchValuesQueryBuilder.setNotAfter(startStamp);
        batchValuesQueryBuilder.setNotNull(this._excludeNullSteps);
        if (timeBefore.isPresent()) {
            batchValuesQueryBuilder.setNotBefore(startStamp.before(timeBefore.get()));
        } else if (limitBefore <= 0) {
            batchValuesQueryBuilder.setNotBefore(startStamp);
        }
        Collection inputValues = batch.getPointValues(batchValuesQueryBuilder.build());
        if (inputValues.isEmpty()) {
            batchValuesQueryBuilder = BatchValuesQuery.newBuilder().setPoint(Optional.of(this.getInputPoint()));
            batchValuesQueryBuilder.setBefore(timeBefore.isPresent() ? startStamp.before(timeBefore.get()) : startStamp);
            batchValuesQueryBuilder.setNotNull(this._excludeNullSteps);
            if (!this.addInputToResult(batch.getPointValue(batchValuesQueryBuilder.build()), (ResultValue)capture)) {
                return false;
            }
        } else {
            int skip = limitBefore > 0 ? inputValues.size() - limitBefore : 0;
            for (PointValue inputValue : inputValues) {
                if (skip <= 0) {
                    if (this.addInputToResult(inputValue, (ResultValue)capture)) continue;
                    return false;
                }
                --skip;
            }
        }
        return true;
    }
}

