/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap.captor;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.ResultValue;
import org.rvpf.content.BooleanContent;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.metadata.processor.Batch;
import org.rvpf.metadata.processor.BatchValuesQuery;
import org.rvpf.metadata.processor.Behavior;
import org.rvpf.pap.PAPMessages;
import org.rvpf.processor.ProcessorMessages;
import org.rvpf.processor.engine.pap.captor.Capture;
import org.rvpf.processor.engine.pap.captor.CapturedBehavior;
import org.rvpf.processor.engine.rpn.selector.SelectsBehavior;

public final class CapturesBehavior
extends SelectsBehavior {
    public static final String CAPTURE_LIMIT_PARAM = "CaptureLimit";
    public static final String CAPTURE_TIME_PARAM = "CaptureTime";
    private static final BooleanContent _BOOLEAN_CONTENT = new BooleanContent();
    private int _captureLimit;
    private Optional<ElapsedTime> _captureTime;
    private CapturedBehavior _capturedBehavior;

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        CapturesBehavior otherBehavior = (CapturesBehavior)((Object)other);
        return this._captureLimit == otherBehavior._captureLimit && Objects.equals(this._captureTime, otherBehavior._captureTime);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Capture newResultValue(Optional<DateTime> stamp) {
        return new Capture(this.getResultPoint(), stamp, this);
    }

    public boolean prepareTrigger(PointValue noticeValue, Batch batch) {
        switch (batch.getLookUpPass()) {
            case 1: {
                if (this.isStartStop()) {
                    Boolean startStopValue = _BOOLEAN_CONTENT.decode(noticeValue);
                    if (startStopValue == null) {
                        return true;
                    }
                    if (!startStopValue.booleanValue()) {
                        StoreValuesQuery.Builder storeValuesQueryBuilder = StoreValuesQuery.newBuilder().setPoint(this.getInputPoint());
                        storeValuesQueryBuilder.setBefore(noticeValue.getStamp());
                        batch.addStoreValuesQuery(storeValuesQueryBuilder.build());
                    }
                }
                return true;
            }
        }
        return true;
    }

    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        Optional capturesRelation = this.getRelation();
        if (capturesRelation.isPresent()) {
            Params relationParams = ((PointRelation)capturesRelation.get()).getParams();
            this._captureLimit = relationParams.getInt(CAPTURE_LIMIT_PARAM, 0);
            if (!this.isStartStop() && this._captureLimit > 0) {
                this.getThisLogger().error((Messages.Entry)PAPMessages.START_STOP_NEEDED, new Object[]{CAPTURE_LIMIT_PARAM});
                return false;
            }
            this._captureTime = relationParams.getElapsed(CAPTURE_TIME_PARAM, Optional.empty(), Optional.empty());
            if (!this.isStartStop() && this._captureTime.isPresent()) {
                this.getThisLogger().error((Messages.Entry)PAPMessages.START_STOP_NEEDED, new Object[]{CAPTURE_TIME_PARAM});
                return false;
            }
        }
        return true;
    }

    public void trigger(PointValue noticeValue, Batch batch) {
        Capture capture = this.newResultValue(Optional.of(noticeValue.getStamp()));
        if (this.isStartStop()) {
            Boolean startStopValue = _BOOLEAN_CONTENT.decode(noticeValue);
            if (startStopValue == null) {
                return;
            }
            BatchValuesQuery.Builder batchValuesQueryBuilder = BatchValuesQuery.newBuilder().setPoint(Optional.of(this.getInputPoint()));
            if (startStopValue.booleanValue()) {
                capture.setStartValue(noticeValue);
                if (this._captureTime.isPresent()) {
                    batch.scheduleUpdate(new PointValue((Point)noticeValue.getPoint().get(), Optional.of(noticeValue.getStamp().after((ElapsedTime)this._captureTime.orElse(null))), null, (Serializable)Boolean.FALSE));
                }
            } else {
                capture.setStopValue(noticeValue);
                batchValuesQueryBuilder.setBefore(noticeValue.getStamp());
                PointValue startPointValue = batch.getPointValue(batchValuesQueryBuilder.build());
                Boolean startValue = _BOOLEAN_CONTENT.decode(startPointValue);
                if (startValue == null || !startValue.booleanValue()) {
                    return;
                }
                capture.setStartValue(startPointValue);
            }
        } else {
            capture.setStartValue(noticeValue);
        }
        batch.setUpResultValue((ResultValue)capture, (Behavior)this);
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this._capturedBehavior == null) {
            this.getThisLogger().warn((Messages.Entry)ProcessorMessages.INPUT_BEHAVIOR_NOT_FOUND, new Object[]{CapturedBehavior.class.getSimpleName()});
            return false;
        }
        return true;
    }

    @CheckReturnValue
    int getLimitAfter() {
        return this._captureLimit;
    }

    @CheckReturnValue
    int getLimitBefore() {
        return this._capturedBehavior.getCaptureLimit();
    }

    @Nonnull
    @CheckReturnValue
    Optional<ElapsedTime> getTimeAfter() {
        return (Optional)Require.notNull(this._captureTime);
    }

    @Nonnull
    @CheckReturnValue
    Optional<ElapsedTime> getTimeBefore() {
        return this._capturedBehavior.getCaptureTime();
    }

    void setCapturedBehavior(@Nonnull CapturedBehavior capturedBehavior) {
        this._capturedBehavior = capturedBehavior;
    }
}

