/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.pap.datalogger;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.pap.PAPMetadataFilter;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.metadata.MetadataService;
import org.rvpf.service.pap.PAPServiceAppImpl;
import org.rvpf.service.pap.datalogger.Output;
import org.rvpf.service.pap.datalogger.Scanner;

public final class DataloggerAppImpl
extends PAPServiceAppImpl {
    public static final String DATALOGGER_PROPERTIES = "datalogger";
    public static final String OUTPUT_PROPERTIES = "output";
    public static final String SCANNER_PROPERTIES = "scanner";
    private volatile MetadataFilter _metadataFilter;
    private Output _output;
    private final List<Scanner> _scanners = new LinkedList<Scanner>();

    @Override
    public boolean setUp(MetadataService service) {
        if (!super.setUp(service)) {
            return false;
        }
        KeyedGroups dataloggerProperties = this.getConfigProperties().getGroup(DATALOGGER_PROPERTIES);
        if (dataloggerProperties.isMissing()) {
            this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES, new Object[]{DATALOGGER_PROPERTIES});
            return false;
        }
        if (!this._setUpScanners(dataloggerProperties)) {
            return false;
        }
        return this._setUpOutput(dataloggerProperties);
    }

    public void start() {
        for (Scanner scanner : this._scanners) {
            scanner.start();
        }
        this._output.start();
    }

    public void stop() {
        long joinTimeout = this.getJoinTimeout();
        for (Scanner scanner : this._scanners) {
            scanner.stop(joinTimeout);
        }
        this._output.stop(joinTimeout);
    }

    @Override
    protected MetadataFilter getMetadataFilter() {
        if (this._metadataFilter == null) {
            this._metadataFilter = new PAPMetadataFilter(this.getProtocolAttributesUsages()){

                public boolean areContentsRequired() {
                    return false;
                }

                public boolean arePointInputsNeeded() {
                    return true;
                }

                public boolean areStoresNeeded() {
                    return true;
                }

                public boolean areStoresRequired() {
                    return false;
                }
            };
        }
        return this._metadataFilter;
    }

    @Nonnull
    @CheckReturnValue
    Logger getLogger() {
        return this.getThisLogger();
    }

    void limitUpdates() throws InterruptedException {
        this._output.limitUpdates();
    }

    void sendUpdates(@Nonnull Collection<PointValue> pointValues) {
        this._output.sendUpdates(pointValues);
    }

    @CheckReturnValue
    boolean storageMonitorCheck() {
        return this._output.storageMonitorCheck();
    }

    private boolean _setUpOutput(KeyedGroups dataloggerProperties) {
        KeyedGroups outputProperties = dataloggerProperties.getGroup(OUTPUT_PROPERTIES);
        if (outputProperties.isMissing()) {
            this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES_IN, new Object[]{OUTPUT_PROPERTIES, dataloggerProperties.getName().orElse(null)});
            return false;
        }
        Output.Builder outputBuilder = Output.newBuilder().setDataloggerApp(this).applyProperties(outputProperties);
        this._output = outputBuilder != null ? outputBuilder.build() : null;
        return this._output != null;
    }

    private boolean _setUpScanners(KeyedGroups dataloggerProperties) {
        KeyedGroups[] scannersProperties = dataloggerProperties.getGroups(SCANNER_PROPERTIES);
        if (scannersProperties.length == 0) {
            this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES_IN, new Object[]{SCANNER_PROPERTIES, dataloggerProperties.getName().orElse(null)});
            return false;
        }
        for (KeyedGroups scannerProperties : scannersProperties) {
            Scanner.Builder scannerBuilder = Scanner.newBuilder().setDataloggerApp(this);
            if (scannerBuilder.applyProperties(scannerProperties) == null) {
                return false;
            }
            this._scanners.add(scannerBuilder.build());
        }
        return true;
    }
}

