/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.pap.datalogger;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.store.Store;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.StorageMonitor;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.pap.datalogger.DataloggerAppImpl;
import org.rvpf.service.som.SOMFactory;
import org.rvpf.service.som.SOMSender;
import org.rvpf.store.client.ProxyStoreClient;

final class Output
implements ServiceThread.Target {
    private static final Logger _LOGGER = Logger.getInstance(Output.class);
    private final AtomicReference<CountDownLatch> _latch = new AtomicReference();
    private final Optional<SOMSender> _sender;
    private final StorageMonitor _storageMonitor;
    private final Optional<ProxyStoreClient> _storeClient;
    private ServiceThread _thread;
    private final Traces _traces;
    private final BlockingQueue<PointValue> _updates = new LinkedBlockingQueue<PointValue>();
    private final int _updatesLimit;

    Output(@Nonnull Optional<SOMSender> sender, @Nonnull Optional<ProxyStoreClient> storeClient, @Nonnull StorageMonitor storageMonitor, int updatesLimit, @Nonnull Traces traces) {
        this._storeClient = storeClient;
        this._sender = sender;
        this._storageMonitor = storageMonitor;
        this._updatesLimit = updatesLimit;
        this._traces = traces;
    }

    public void run() throws InterruptedException, ServiceNotAvailableException {
        LinkedList<PointValue> pointValues = new LinkedList<PointValue>();
        boolean stopping = false;
        do {
            Object pointValue = this._updates.take();
            do {
                if (pointValue == PointValue.NULL) {
                    stopping = true;
                    if (!pointValues.isEmpty()) break;
                    return;
                }
                _LOGGER.trace((Messages.Entry)ModbusMessages.OUTPUT_POINT_VALUE, new Object[]{pointValue});
                pointValues.add((PointValue)pointValue);
            } while ((pointValue = (PointValue)this._updates.poll()) != null);
            if (this._traces.isEnabled()) {
                for (PointValue pointValue2 : pointValues) {
                    this._traces.add((Object)pointValue2);
                }
                this._traces.commit();
            }
            if (this._sender.isPresent()) {
                if (!this._sender.get().send((Serializable[])pointValues.toArray(new PointValue[pointValues.size()]), true)) {
                    throw new ServiceNotAvailableException((Exception)this._sender.get().getException().get());
                }
            } else if (this._storeClient.isPresent()) {
                StoreSessionProxy store = this._storeClient.get().getStore();
                if (!store.updateAndCheck(pointValues, _LOGGER)) {
                    throw new ServiceNotAvailableException((Exception)store.getException().get());
                }
            } else {
                IdentityHashSet stores = new IdentityHashSet();
                for (PointValue pointValue3 : pointValues) {
                    Point point = (Point)pointValue3.getPoint().get();
                    Optional store = point.getStore();
                    if (!store.isPresent()) continue;
                    ((Store)store.get()).addUpdate(pointValue3);
                    stores.add(store.get());
                }
                for (Store store : stores) {
                    if (store.sendUpdates()) continue;
                    throw new ServiceNotAvailableException();
                }
            }
            pointValues.clear();
            CountDownLatch scanLatch = this._latch.get();
            if (scanLatch == null || !this._updates.isEmpty()) continue;
            scanLatch.countDown();
            this._latch.compareAndSet(scanLatch, null);
        } while (!stopping);
    }

    @Nonnull
    @CheckReturnValue
    static Builder newBuilder() {
        return new Builder();
    }

    void limitUpdates() throws InterruptedException {
        CountDownLatch scanLatch;
        if (this._latch.get() == null && this._updates.size() > this._updatesLimit && this._latch.compareAndSet(null, new CountDownLatch(1))) {
            _LOGGER.warn((Messages.Entry)PAPMessages.LOST_EVENTS, new Object[0]);
        }
        if ((scanLatch = this._latch.get()) != null) {
            scanLatch.await();
        }
    }

    void sendUpdates(@Nonnull Collection<PointValue> pointValues) {
        for (PointValue pointValue : pointValues) {
            this._updates.add(pointValue);
        }
    }

    final void start() {
        this._thread = new ServiceThread((ServiceThread.Target)this, "Datalogger output");
        _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{this._thread.getName()});
        this._thread.start();
    }

    final void stop(long joinTimeout) {
        if (this._thread != null) {
            this._updates.add(PointValue.NULL);
            Require.ignored((boolean)this._thread.join(_LOGGER, joinTimeout));
            if (this._sender.isPresent()) {
                this._sender.get().close();
            }
            if (this._storeClient.isPresent()) {
                this._storeClient.get().tearDown();
            }
            this._traces.tearDown();
            this._thread = null;
        }
    }

    @CheckReturnValue
    boolean storageMonitorCheck() {
        return this._storageMonitor.check();
    }

    static final class Builder {
        public static final String LIMIT_PROPERTY = "limit";
        public static final String QUEUE_PROPERTIES = "queue";
        public static final String STORAGE_PROPERTIES = "storage";
        public static final String STORE_PROPERTIES = "store";
        public static final String TRACES_PROPERTY = "traces";
        private DataloggerAppImpl _dataloggerApp;
        private Optional<SOMSender> _sender;
        private StorageMonitor _storageMonitor;
        private Optional<ProxyStoreClient> _storeClient;
        private Traces _traces;
        private int _updatesLimit;

        @Nullable
        @CheckReturnValue
        Builder applyProperties(@Nonnull KeyedGroups outputProperties) {
            KeyedGroups queueProperties = outputProperties.getGroup(QUEUE_PROPERTIES);
            if (queueProperties.isMissing()) {
                ProxyStoreClient storeClient;
                if (outputProperties.containsGroupKey(STORE_PROPERTIES)) {
                    storeClient = new ProxyStoreClient();
                    if (!storeClient.setUp(this._dataloggerApp.getConfig(), outputProperties)) {
                        return null;
                    }
                    this._dataloggerApp.getLogger().debug((Messages.Entry)PAPMessages.DATALOGGER_DESTINATION_STORE, new Object[]{storeClient.getStore().getServerName()});
                } else {
                    storeClient = null;
                }
                this._storeClient = Optional.ofNullable(storeClient);
                this._sender = Optional.empty();
            } else {
                SOMFactory factory = new SOMFactory(this._dataloggerApp.getConfig());
                SOMFactory.Queue factoryQueue = factory.createQueue(queueProperties);
                this._sender = Optional.of(factoryQueue.createSender(true));
                if (!this._sender.isPresent()) {
                    return null;
                }
                this._dataloggerApp.getLogger().debug((Messages.Entry)PAPMessages.DATALOGGER_DESTINATION_QUEUE, new Object[]{this._sender.get()});
                if (this._sender.get().isRemote()) {
                    this._dataloggerApp.getLogger().warn((Messages.Entry)ServiceMessages.REMOTE_SERVICE_WARNING, new Object[]{this._sender.get()});
                }
                this._storeClient = Optional.empty();
            }
            this._traces = new Traces();
            if (!this._traces.setUp(this._dataloggerApp.getDataDir(), this._dataloggerApp.getConfigProperties().getGroup(TRACES_PROPERTY), this._dataloggerApp.getSourceUUID(), outputProperties.getString(TRACES_PROPERTY))) {
                return null;
            }
            this._storageMonitor = new StorageMonitor(Logger.getInstance(Output.class));
            if (!this._storageMonitor.setUp((KeyedValues)outputProperties.getGroup(STORAGE_PROPERTIES), this._dataloggerApp.getDataDir())) {
                return null;
            }
            this._updatesLimit = outputProperties.getInt(LIMIT_PROPERTY, 0);
            if (this._updatesLimit <= 0) {
                this._updatesLimit = Integer.MAX_VALUE;
            }
            return this;
        }

        @Nonnull
        @CheckReturnValue
        Output build() {
            return new Output(this._sender, this._storeClient, this._storageMonitor, this._updatesLimit, this._traces);
        }

        @Nonnull
        Builder setDataloggerApp(@Nonnull DataloggerAppImpl dataloggerApp) {
            this._dataloggerApp = dataloggerApp;
            return this;
        }
    }
}

