/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.pap.datalogger;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Content;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.store.Store;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.sync.CrontabSync;
import org.rvpf.base.sync.ElapsedSync;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.BooleanContent;
import org.rvpf.content.FloatingPointContent;
import org.rvpf.content.NumberContent;
import org.rvpf.content.StringContent;
import org.rvpf.pap.PAPMessages;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.pap.datalogger.ScanSchedule;

final class ScanControls {
    private static final BooleanContent _BOOLEAN_CONTENT = new BooleanContent();
    static final Logger _LOGGER = Logger.getInstance(ScanControls.class);
    private volatile boolean _barrierOpen;
    private final Map<UUID, BiConsumer<ScanControls, PointValue>> _pointValueActions;
    private final Map<UUID, DateTime> _pointValueStamps = new HashMap<UUID, DateTime>();
    private final String _scannerName;
    private final Collection<ScanSchedule> _schedules;
    private boolean _started;
    private final Map<UUID, _StoreListener> _storeListeners = new HashMap<UUID, _StoreListener>();
    private PointValue _syncPointValue;

    ScanControls(@Nonnull String scannerName, @Nonnull Collection<ScanSchedule> schedules, @Nonnull Map<UUID, _StoreListener.Builder> storeListenerBuilders, @Nonnull Map<UUID, BiConsumer<ScanControls, PointValue>> pointValueActions, boolean barrierOpen) {
        this._scannerName = scannerName;
        this._schedules = schedules;
        for (Map.Entry<UUID, _StoreListener.Builder> storeListenerBuilder : storeListenerBuilders.entrySet()) {
            this._storeListeners.put(storeListenerBuilder.getKey(), storeListenerBuilder.getValue().setOwner(this).build());
        }
        this._pointValueActions = pointValueActions;
        this._barrierOpen = barrierOpen;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @CheckReturnValue
    public boolean isBarrierOpen() {
        return this._barrierOpen;
    }

    @CheckReturnValue
    public boolean start() {
        boolean success = true;
        for (_StoreListener storeListener : this._storeListeners.values()) {
            success &= storeListener.setUp();
        }
        if (!success) {
            return false;
        }
        this._started = true;
        if (this._syncPointValue != null) {
            this._onPointValue(this._syncPointValue);
            this._syncPointValue = null;
        }
        for (_StoreListener storeListener : this._storeListeners.values()) {
            storeListener.start();
        }
        return true;
    }

    public void stop(long joinTimeout) {
        for (_StoreListener storeListener : this._storeListeners.values()) {
            storeListener.stop(joinTimeout);
        }
    }

    @Nonnull
    @CheckReturnValue
    String _getScannerName() {
        return this._scannerName;
    }

    void _onBarrierPointValue(PointValue pointValue) {
        Boolean barrier = _BOOLEAN_CONTENT.decode(pointValue);
        if (barrier != null) {
            this._barrierOpen = barrier;
        }
    }

    void _onCrontabPointValue(PointValue pointValue) {
        if (this._started) {
            CrontabSync crontabSync;
            Optional content = ((Point)pointValue.getPoint().get()).getContent();
            String value = (String)((Object)((Content)content.get()).decode(pointValue));
            if (value != null && (crontabSync = new CrontabSync()).setUp(value)) {
                this._resync((Sync)crontabSync);
            }
        } else {
            this._setSyncPointValue(pointValue);
        }
    }

    void _onEachPointValue(PointValue pointValue) {
        if (this._started) {
            for (ScanSchedule schedule : this._schedules) {
                schedule.triggerNow();
            }
        }
    }

    void _onElapsedPointValue(PointValue pointValue) {
        if (this._started) {
            Content content = ((Point)pointValue.getPoint().get()).getContent().orElse(null);
            Number value = (Number)content.decode(pointValue);
            if (value != null) {
                ElapsedTime elapsedTime = content instanceof FloatingPointContent ? ElapsedTime.fromSeconds((double)value.doubleValue()) : ElapsedTime.fromMillis((long)value.longValue());
                this._resync((Sync)new ElapsedSync(elapsedTime, Optional.empty()));
            }
        } else {
            this._setSyncPointValue(pointValue);
        }
    }

    void _onPointValues(@Nonnull Collection<PointValue> pointValues) {
        for (PointValue pointValue : pointValues) {
            UUID pointUUID = pointValue.getPointUUID();
            DateTime pointValueStamp = pointValue.getStamp();
            DateTime previousStamp = this._pointValueStamps.get(pointUUID);
            if (previousStamp != null && !pointValueStamp.isNotBefore(previousStamp)) continue;
            this._onPointValue(pointValue);
            this._pointValueStamps.put(pointUUID, pointValueStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _onPointValue(PointValue pointValue) {
        Map<UUID, BiConsumer<ScanControls, PointValue>> map = this._pointValueActions;
        synchronized (map) {
            BiConsumer<ScanControls, PointValue> pointValueAction = this._pointValueActions.get(pointValue.getPointUUID());
            if (pointValueAction != null) {
                pointValueAction.accept(this, pointValue);
            }
        }
    }

    private void _resync(Sync sync) {
        for (ScanSchedule schedule : this._schedules) {
            schedule.resync(sync);
        }
    }

    private void _setSyncPointValue(PointValue syncPointValue) {
        if (this._syncPointValue == null || syncPointValue.getStamp().isAfter(this._syncPointValue.getStamp())) {
            this._syncPointValue = syncPointValue;
        }
    }

    private static final class _StoreListener
    implements ServiceThread.Target {
        private final ScanControls _owner;
        private final Collection<UUID> _points;
        private final Store _store;
        private final ServiceThread _thread;

        public _StoreListener(@Nonnull ScanControls owner, @Nonnull Store store, @Nonnull Collection<UUID> points) {
            this._owner = owner;
            this._store = store;
            this._points = points;
            this._thread = new ServiceThread((ServiceThread.Target)this, "Datalogger scanner '" + owner._getScannerName() + "' store '" + this._store.getName() + "' listener");
        }

        public void run() throws Exception {
            while (true) {
                StoreValues storeValues;
                if ((storeValues = this._store.deliver(0, -1L)) == null) {
                    throw new ServiceNotAvailableException();
                }
                if (!storeValues.isSuccess()) {
                    throw new ServiceNotAvailableException((Exception)storeValues.getException().get());
                }
                this._owner._onPointValues((Collection<PointValue>)storeValues);
            }
        }

        @Nonnull
        @CheckReturnValue
        static Builder newBuilder() {
            return new Builder();
        }

        @CheckReturnValue
        boolean setUp() {
            try {
                if (!this._store.subscribe(this._points)) {
                    return false;
                }
            }
            catch (StoreAccessException exception) {
                _LOGGER.warn((Messages.Entry)ServiceMessages.STORE_ACCESS_FAILED, new Object[]{this._store, exception.getMessage()});
                return false;
            }
            Optional subscribedValues = this._store.getSubscribedValues();
            if (subscribedValues.isPresent()) {
                for (StoreValues storeValues : (StoreValues[])subscribedValues.get()) {
                    this._owner._onPointValues((Collection<PointValue>)storeValues);
                }
            }
            return true;
        }

        void start() {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{this._thread.getName()});
            this._thread.start();
        }

        void stop(long joinTimeout) {
            Require.ignored((boolean)this._thread.interruptAndJoin(_LOGGER, joinTimeout));
            this._store.close();
        }

        static final class Builder {
            private ScanControls _owner;
            private final Collection<UUID> _points = new LinkedList<UUID>();
            private Store _store;

            Builder() {
            }

            @Nonnull
            Builder addPoint(@Nonnull Point point) {
                this._points.add((UUID)point.getUUID().get());
                return this;
            }

            @Nonnull
            _StoreListener build() {
                return new _StoreListener(this._owner, this._store, this._points);
            }

            @Nonnull
            Builder setOwner(@Nonnull ScanControls owner) {
                this._owner = owner;
                return this;
            }

            @Nonnull
            Builder setStore(@Nonnull Store store) {
                this._store = store;
                return this;
            }
        }
    }

    static final class Builder {
        private boolean _barrierOpen = true;
        private boolean _mayTrigger;
        private final Map<UUID, BiConsumer<ScanControls, PointValue>> _pointValueActions = new HashMap<UUID, BiConsumer<ScanControls, PointValue>>();
        private String _scannerName;
        private final Collection<ScanSchedule> _schedules = new HashSet<ScanSchedule>();
        private final Map<UUID, _StoreListener.Builder> _storeListenerBuilders = new HashMap<UUID, _StoreListener.Builder>();

        Builder() {
        }

        @Nonnull
        Builder addSchedule(@Nonnull ScanSchedule schedule) {
            this._schedules.add(schedule);
            return this;
        }

        @Nonnull
        @CheckReturnValue
        ScanControls build() {
            return new ScanControls(this._scannerName, this._schedules, this._storeListenerBuilders, this._pointValueActions, this._barrierOpen);
        }

        @CheckReturnValue
        boolean isBarrierOpen() {
            return this._barrierOpen;
        }

        @CheckReturnValue
        boolean mayTrigger() {
            return this._mayTrigger;
        }

        @Nonnull
        Builder setBarrierPoint(@Nonnull Point barrierPoint) {
            this._barrierOpen = false;
            this._setPointValueAction(barrierPoint, ScanControls::_onBarrierPointValue);
            return this;
        }

        @Nonnull
        Builder setCrontabPoint(@Nonnull Point crontabPoint) {
            Content content = crontabPoint.getContent().orElse(null);
            if (content != null && content instanceof StringContent) {
                this._mayTrigger = true;
                this._setPointValueAction(crontabPoint, ScanControls::_onCrontabPointValue);
            } else {
                _LOGGER.warn((Messages.Entry)PAPMessages.CRONTAB_REQUIRES_STRING, new Object[]{crontabPoint});
            }
            return this;
        }

        @Nonnull
        Builder setEachPoint(@Nonnull Point eachPoint) {
            this._mayTrigger = true;
            this._setPointValueAction(eachPoint, ScanControls::_onEachPointValue);
            return this;
        }

        @Nonnull
        Builder setElapsedPoint(@Nonnull Point elapsedPoint) {
            Content content = elapsedPoint.getContent().orElse(null);
            if (content != null && content instanceof NumberContent) {
                this._mayTrigger = true;
                this._setPointValueAction(elapsedPoint, ScanControls::_onElapsedPointValue);
            } else {
                _LOGGER.warn((Messages.Entry)PAPMessages.ELAPSED_REQUIRES_NUMBER, new Object[]{elapsedPoint});
            }
            return this;
        }

        @Nonnull
        Builder setScannerName(String scannerName) {
            this._scannerName = scannerName;
            return this;
        }

        private void _setPointValueAction(Point point, BiConsumer<ScanControls, PointValue> action) {
            Store store = (Store)point.getStore().get();
            _StoreListener.Builder storeListenerBuilder = this._storeListenerBuilders.get(store.getUUID());
            if (storeListenerBuilder == null) {
                storeListenerBuilder = _StoreListener.newBuilder().setStore(store);
                this._storeListenerBuilders.put(store.getUUID(), storeListenerBuilder);
            }
            storeListenerBuilder.addPoint(point);
            this._pointValueActions.put((UUID)point.getUUID().get(), action);
        }
    }
}

