/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.service.pap.datalogger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.sync.NullSync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.Schedule;
import org.rvpf.base.util.SnoozeAlarm;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.util.container.PointValueFilters;
import org.rvpf.base.value.PointValue;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.metadata.entity.SyncEntity;
import org.rvpf.pap.PAPClient;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.PAPSupport;
import org.rvpf.processor.engine.pap.PAPSplitter;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.pap.datalogger.DataloggerAppImpl;
import org.rvpf.service.pap.datalogger.ScanControls;
import org.rvpf.service.pap.datalogger.ScanSchedule;

public final class Scanner
implements PAPConnectionListener {
    private final ScanControls _controls;
    private final DataloggerAppImpl _dataloggerApp;
    private final String _name;
    private final Map<PAPProxy, _ProxyThread> _proxyThreads = new IdentityHashMap<PAPProxy, _ProxyThread>();
    private final Optional<ElapsedTime> _retryInterval;
    private final int _retryLimit;
    private final Set<Point> _statePoints;
    private final Traces _traces;
    private final PointValueFilters _valueFilters = new PointValueFilters();

    Scanner(@Nonnull DataloggerAppImpl dataloggerApp, @Nonnull String name, @Nonnull Origin origin, int retryLimit, @Nonnull Optional<ElapsedTime> retryInterval, @Nonnull ScanControls.Builder controlsBuilder, @Nonnull Map<PAPProxy, _ProxyThread.Builder> proxyThreadBuilders, @Nonnull Set<Point> statePoints, @Nonnull Traces traces) {
        this._dataloggerApp = dataloggerApp;
        this._name = name;
        this._retryLimit = retryLimit;
        this._retryInterval = retryInterval;
        this._controls = controlsBuilder.build();
        for (Map.Entry<PAPProxy, _ProxyThread.Builder> proxyThreadBuilder : proxyThreadBuilders.entrySet()) {
            this._proxyThreads.put(proxyThreadBuilder.getKey(), proxyThreadBuilder.getValue().setScanner(this).build());
        }
        this._statePoints = statePoints;
        this._traces = traces;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
        this._updateState(remoteProxy, Boolean.FALSE, cause.map(Throwable::getMessage));
        return true;
    }

    @Override
    public boolean onNewConnection(PAPProxy remoteProxy) {
        this._updateState(remoteProxy, Boolean.TRUE, Optional.empty());
        return true;
    }

    @Nonnull
    @CheckReturnValue
    ElapsedTime _getRetryInterval() {
        return this._retryInterval.get();
    }

    @CheckReturnValue
    int _getRetryLimit() {
        return this._retryLimit;
    }

    @Nonnull
    @CheckReturnValue
    Traces _getTraces() {
        return this._traces;
    }

    @Nonnull
    @CheckReturnValue
    PointValueFilters _getValueFilters() {
        return this._valueFilters;
    }

    @CheckReturnValue
    boolean _isBarrierOpen() {
        return this._controls.isBarrierOpen();
    }

    void _limitUpdates() throws InterruptedException {
        this._dataloggerApp.limitUpdates();
    }

    void _sendUpdates(@Nonnull Collection<PointValue> pointValues) {
        this._dataloggerApp.sendUpdates(pointValues);
    }

    @CheckReturnValue
    boolean _storageMonitorCheck() {
        return this._dataloggerApp.storageMonitorCheck();
    }

    @Nonnull
    @CheckReturnValue
    final String getName() {
        return this._name;
    }

    final void start() {
        DateTime startStamp = DateTime.now();
        ArrayList<PointValue> connectionStates = new ArrayList<PointValue>(this._statePoints.size());
        for (Point statePoint : this._statePoints) {
            connectionStates.add(new PointValue(statePoint, Optional.of(startStamp), null, null));
        }
        this._dataloggerApp.sendUpdates(connectionStates);
        if (!this._proxyThreads.isEmpty()) {
            if (!this._controls.start()) {
                this._dataloggerApp.fail();
            }
            for (_ProxyThread thread : this._proxyThreads.values()) {
                thread.start();
            }
        }
    }

    final void stop(long joinTimeout) {
        this._controls.stop(joinTimeout);
        for (_ProxyThread thread : this._proxyThreads.values()) {
            thread.stop(joinTimeout);
        }
        this._traces.tearDown();
    }

    private void _updateState(PAPProxy remoteProxy, Boolean connected, Optional<String> cause) {
        Optional<Point> proxyStatePoint = remoteProxy.getConnectionStatePoint();
        if (!proxyStatePoint.isPresent()) {
            return;
        }
        DateTime now = DateTime.now();
        ArrayList<PointValue> connectionStates = new ArrayList<PointValue>(this._statePoints.size());
        for (PointRelation resultRelation : proxyStatePoint.get().getResults()) {
            Point resultPoint = resultRelation.getResultPoint();
            if (!this._statePoints.contains(resultPoint)) continue;
            connectionStates.add(new PointValue(resultPoint, Optional.of(now), (Serializable)cause.orElse(null), (Serializable)connected));
        }
        this._dataloggerApp.sendUpdates(connectionStates);
    }

    private static final class _ProxyThread
    implements ServiceThread.Target {
        private static final Logger _LOGGER = Logger.getInstance(Scanner.class);
        private final PAPClient _client;
        private int _retries;
        private final ServiceThread _scanThread;
        private final Scanner _scanner;
        private final ScanSchedule _schedule;
        private final PAPSplitter _splitter;

        _ProxyThread(@Nonnull Scanner scanner, @Nonnull PAPContext protocolContext, @Nonnull ScanSchedule schedule, @Nonnull Optional<? extends Origin> origin, @Nonnull PAPSplitter splitter) {
            this._scanner = scanner;
            PAPSupport protocolSupport = protocolContext.getSupport();
            this._client = protocolSupport.newClient(protocolContext);
            this._splitter = splitter;
            this._schedule = schedule;
            this._scanThread = new ServiceThread((ServiceThread.Target)this, "Datalogger scanner '" + this._scanner.getName() + "' from '" + origin.orElse(null) + "'");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            this._client.open();
            try {
                int retryLimit = this._scanner._getRetryLimit();
                SnoozeAlarm snoozeAlarm = retryLimit != 0 ? new SnoozeAlarm() : null;
                while (true) {
                    PointValue[] requestedValues;
                    this._scanner._limitUpdates();
                    Schedule.PointEvent[] eventsDue = this._schedule.allDue(true, true).toArray(new Schedule.PointEvent[0]);
                    if (eventsDue.length == 0) {
                        _LOGGER.warn((Messages.Entry)PAPMessages.NO_POINTS_TO_SCAN, new Object[]{this._scanner.getName()});
                        break;
                    }
                    if (!this._scanner._isBarrierOpen() || !this._scanner._storageMonitorCheck()) continue;
                    _LOGGER.trace((Messages.Entry)PAPMessages.SCANNING_NOW, new Object[]{String.valueOf(eventsDue.length)});
                    Point[] pointsDue = new Point[eventsDue.length];
                    for (int i = 0; i < pointsDue.length; ++i) {
                        pointsDue[i] = (Point)eventsDue[i].getPoint().get();
                    }
                    try {
                        requestedValues = this._client.fetchPointValues(pointsDue);
                    }
                    catch (ServiceNotAvailableException exception) {
                        if (retryLimit >= 0 && this._retries >= retryLimit) {
                            throw exception;
                        }
                        if (this._retries++ == 0) {
                            _LOGGER.trace((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
                            _LOGGER.info((Messages.Entry)PAPMessages.BEGINNING_SCANNER_RETRIES, new Object[0]);
                        }
                        Require.ignored((boolean)snoozeAlarm.snooze(this._scanner._getRetryInterval()));
                        _LOGGER.trace((Messages.Entry)PAPMessages.SCANNER_RETRY, new Object[]{this._retries});
                        continue;
                    }
                    if (this._retries > 0) {
                        _LOGGER.info((Messages.Entry)PAPMessages.SCANNER_RETRY_SUCCEEDED, new Object[0]);
                        this._retries = 0;
                    }
                    ArrayList<PointValue> inputValues = new ArrayList<PointValue>(requestedValues.length);
                    for (int i = 0; i < requestedValues.length; ++i) {
                        if (requestedValues[i] != null) {
                            inputValues.add(requestedValues[i]);
                            continue;
                        }
                        Schedule.PointEvent pointEvent = eventsDue[i];
                        this._schedule.cancel((Schedule.Event)pointEvent);
                        _LOGGER.warn((Messages.Entry)PAPMessages.CANCELLED_, new Object[]{pointEvent});
                    }
                    this._process(inputValues);
                }
            }
            finally {
                this._client.close();
            }
        }

        public final void start() {
            this._client.addConnectionListener(this._scanner);
            _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{this._scanThread.getName()});
            this._scanThread.start();
        }

        public final void stop(long joinTimeout) {
            this._client.close();
            Require.ignored((boolean)this._scanThread.interruptAndJoin(_LOGGER, joinTimeout));
            this._client.removeConnectionListener(this._scanner);
        }

        @Nonnull
        @CheckReturnValue
        static Builder newBuilder() {
            return new Builder();
        }

        @Nonnull
        @CheckReturnValue
        ScanSchedule getSchedule() {
            return this._schedule;
        }

        @Nonnull
        @CheckReturnValue
        PAPSplitter getSplitter() {
            return this._splitter;
        }

        private Collection<PointValue> _filter(Collection<PointValue> inputPointValues) {
            ArrayList<PointValue> outputPointValues = new ArrayList<PointValue>(inputPointValues.size());
            PointValueFilters valueFilters = this._scanner._getValueFilters();
            for (PointValue inputPointValue : inputPointValues) {
                for (PointValue filteredPointValue : valueFilters.filter(inputPointValue)) {
                    outputPointValues.add(filteredPointValue);
                }
            }
            return outputPointValues;
        }

        private void _process(Collection<PointValue> inputValues) {
            Traces traces = this._scanner._getTraces();
            if (traces.isEnabled()) {
                for (PointValue pointValue : inputValues) {
                    traces.add((Object)pointValue);
                }
                traces.commit();
            }
            Collection<PointValue> filteredValues = this._filter(inputValues);
            ArrayList<PointValue> outputValues = new ArrayList<PointValue>(filteredValues.size());
            for (PointValue pointValue : filteredValues) {
                Collection<PointValue> splittedValues = this._split(pointValue);
                if (splittedValues != null) {
                    outputValues.addAll(this._filter(splittedValues));
                    continue;
                }
                outputValues.add(pointValue);
            }
            ArrayList<PointValue> updates = new ArrayList<PointValue>(outputValues.size());
            for (PointValue pointValue : outputValues) {
                if (!this._client.isPointActive((Point)pointValue.getPoint().get())) continue;
                updates.add(pointValue.encoded());
            }
            this._scanner._sendUpdates(updates);
        }

        private Collection<PointValue> _split(PointValue inputPointValue) {
            LinkedList<PointValue> outputPointValues = new LinkedList<PointValue>();
            Optional<PAPSplitter.Splitted> splitted = this._splitter.split(inputPointValue);
            if (!splitted.isPresent()) {
                return null;
            }
            Point splittedPoint = (Point)inputPointValue.getPoint().get();
            for (PointRelation result : splittedPoint.getResults()) {
                Point resultPoint = result.getResultPoint();
                outputPointValues.add(new PointValue(resultPoint, Optional.of(inputPointValue.getStamp()), null, (Serializable)splitted.get().get(resultPoint).orElse(null)));
            }
            return outputPointValues;
        }

        static final class Builder {
            private Optional<? extends Origin> _origin = Optional.empty();
            private PAPContext _protocolContext;
            private Scanner _scanner;
            private final ScanSchedule _schedule = new ScanSchedule();
            private PAPSplitter _splitter;

            Builder() {
            }

            @Nonnull
            _ProxyThread build() {
                _ProxyThread proxyThread = new _ProxyThread(this._scanner, this._protocolContext, this.getSchedule(), this._origin, this.getSplitter());
                return proxyThread;
            }

            @Nonnull
            @CheckReturnValue
            ScanSchedule getSchedule() {
                return this._schedule;
            }

            @Nonnull
            @CheckReturnValue
            PAPSplitter getSplitter() {
                return (PAPSplitter)Require.notNull((Object)this._splitter);
            }

            @Nonnull
            Builder setOrigin(@Nonnull Optional<? extends Origin> origin) {
                this._origin = origin;
                return this;
            }

            @Nonnull
            Builder setProtocolContext(@Nonnull PAPContext protocolContext) {
                this._protocolContext = protocolContext;
                PAPSupport protocolSupport = this._protocolContext.getSupport();
                this._splitter = protocolSupport.newSplitter();
                return this;
            }

            @Nonnull
            Builder setScanner(@Nonnull Scanner scanner) {
                this._scanner = scanner;
                return this;
            }
        }
    }

    static final class Builder {
        public static final String BARRIER_PROPERTY = "barrier";
        public static final String CONTROLS_PROPERTIES = "controls";
        public static final String CRONTAB_PROPERTY = "crontab";
        public static final ElapsedTime DEFAULT_RETRY_INTERVAL = ElapsedTime.MINUTE;
        public static final int DEFAULT_RETRY_LIMIT = -1;
        public static final String EACH_PROPERTY = "each";
        public static final String ELAPSED_PROPERTY = "elapsed";
        public static final String NAME_PROPERTY = "name";
        public static final String RETRY_INTERVAL_PROPERTY = "retry.interval";
        public static final String RETRY_LIMIT_PROPERTY = "retry.limit";
        public static final String SYNC_PROPERTY = "sync";
        public static final String TRACES_PROPERTY = "traces";
        private static final Logger _LOGGER = Logger.getInstance(Builder.class);
        private DataloggerAppImpl _dataloggerApp;
        private String _name;
        private Origin _origin;
        private final Map<PAPProxy, _ProxyThread.Builder> _proxyThreadBuilders = new IdentityHashMap<PAPProxy, _ProxyThread.Builder>();
        private Optional<ElapsedTime> _retryInterval = Optional.empty();
        private int _retryLimit;
        private ScanControls.Builder _scanControlsBuilder;
        private final Set<Point> _statePoints = new LinkedHashSet<Point>();
        private final Traces _traces = new Traces();

        Builder() {
        }

        @Nullable
        @CheckReturnValue
        Builder applyProperties(@Nonnull KeyedGroups scannerProperties) {
            SyncEntity scannerSyncEntity;
            this._name = scannerProperties.getString(NAME_PROPERTY).orElse(null);
            if (this._name == null) {
                _LOGGER.error((Messages.Entry)BaseMessages.MISSING_PROPERTY_IN, new Object[]{NAME_PROPERTY, scannerProperties.getName().orElse(null)});
                return null;
            }
            _LOGGER.debug((Messages.Entry)PAPMessages.DATALOGGER_SCANNER_NAME, new Object[]{this._name});
            Metadata metadata = this._dataloggerApp.getMetadata();
            Optional origin = metadata.getOriginEntity(Optional.of(this._name));
            if (!origin.isPresent()) {
                _LOGGER.error((Messages.Entry)ServiceMessages.PROCESSOR_NOT_FOUND, new Object[]{this._name});
                return null;
            }
            this._origin = (Origin)origin.get();
            this._retryLimit = scannerProperties.getInt(RETRY_LIMIT_PROPERTY, -1);
            if (this._retryLimit == 0) {
                _LOGGER.debug((Messages.Entry)PAPMessages.SCANNER_NO_RETRIES, new Object[]{this._name});
            } else {
                this._retryInterval = scannerProperties.getElapsed(RETRY_INTERVAL_PROPERTY, Optional.of(DEFAULT_RETRY_INTERVAL), Optional.of(DEFAULT_RETRY_INTERVAL));
                _LOGGER.debug((Messages.Entry)PAPMessages.SCANNER_RETRY_INTERVAL, new Object[]{this._name, this._retryInterval.get()});
                if (!SnoozeAlarm.validate((ElapsedTime)this._retryInterval.get(), (Object)this, (Messages.Entry)PAPMessages.SCANNER_RETRY_INTERVAL_TEXT)) {
                    return null;
                }
                if (this._retryLimit > 0) {
                    _LOGGER.debug((Messages.Entry)PAPMessages.SCANNER_RETRY_LIMIT, new Object[]{this._retryLimit});
                }
            }
            Optional scannerSyncName = scannerProperties.getString(SYNC_PROPERTY);
            if (scannerSyncName.isPresent()) {
                Optional optionalScannerSyncEntity = metadata.getSyncEntity(Optional.of(scannerSyncName.get()));
                if (!optionalScannerSyncEntity.isPresent()) {
                    _LOGGER.error((Messages.Entry)ServiceMessages.ENTITY_UNKNOWN, new Object[]{"Sync", scannerSyncName.get()});
                    return null;
                }
                scannerSyncEntity = (SyncEntity)optionalScannerSyncEntity.get();
                if (!scannerSyncEntity.setUp()) {
                    return null;
                }
                _LOGGER.debug((Messages.Entry)PAPMessages.DATALOGGER_SCANNER_SYNC, new Object[]{this._name, scannerSyncEntity.getSync()});
            } else {
                scannerSyncEntity = null;
            }
            if (!this._setUpControlPoints((KeyedValues)scannerProperties.getGroup(CONTROLS_PROPERTIES))) {
                return null;
            }
            LinkedHashSet<Point> inputPoints = new LinkedHashSet<Point>();
            HashSet<Point> resultPoints = new HashSet<Point>();
            if (!this._setUpSchedules(scannerSyncEntity, inputPoints, resultPoints)) {
                return null;
            }
            if (this._proxyThreadBuilders.isEmpty()) {
                _LOGGER.warn((Messages.Entry)PAPMessages.NO_POINTS_TO_SCAN, new Object[]{this._name});
            } else {
                int originated = resultPoints.size();
                ArrayList<DateTime> firstStamps = new ArrayList<DateTime>(this._proxyThreadBuilders.size());
                int scheduled = 0;
                for (_ProxyThread.Builder proxyThreadBuilder : this._proxyThreadBuilders.values()) {
                    ScanSchedule schedule = proxyThreadBuilder.getSchedule();
                    firstStamps.add(((Schedule.PointEvent)schedule.peek().get()).getStamp());
                    scheduled += schedule.size();
                }
                _LOGGER.debug((Messages.Entry)PAPMessages.SCANNER_ORIGINATES, new Object[]{this._name, String.valueOf(originated), originated});
                _LOGGER.debug((Messages.Entry)PAPMessages.POINTS_TO_SCAN, new Object[]{this._name, String.valueOf(scheduled), scheduled});
                if (this._scanControlsBuilder.isBarrierOpen()) {
                    _LOGGER.debug((Messages.Entry)PAPMessages.SCAN_STARTS_AT, new Object[]{this._name, DateTime.min(firstStamps)});
                }
            }
            for (PAPProxy proxy : this._proxyThreadBuilders.keySet()) {
                Optional<Point> proxyStatePoint = proxy.getConnectionStatePoint();
                if (!proxyStatePoint.isPresent()) continue;
                for (PointRelation resultRelation : proxyStatePoint.get().getResults()) {
                    Point resultPoint = resultRelation.getResultPoint();
                    if (!resultPoints.contains(resultPoint)) continue;
                    this._statePoints.add(resultPoint);
                }
            }
            if (!this._traces.setUp(this._dataloggerApp.getDataDir(), (KeyedGroups)metadata.getProperties().getGroup(TRACES_PROPERTY), metadata.getService().getSourceUUID(), scannerProperties.getString(TRACES_PROPERTY))) {
                return null;
            }
            return this;
        }

        @Nonnull
        @CheckReturnValue
        Scanner build() {
            return new Scanner(this._dataloggerApp, this._name, this._origin, this._retryLimit, this._retryInterval, this._scanControlsBuilder, this._proxyThreadBuilders, this._statePoints, this._traces);
        }

        @Nonnull
        Builder setDataloggerApp(@Nonnull DataloggerAppImpl dataloggerApp) {
            this._dataloggerApp = dataloggerApp;
            return this;
        }

        private boolean _setUpControlPoint(Optional<String> controlPointName, Consumer<Point> setControlPoint) {
            if (controlPointName.isPresent()) {
                Optional optionalControlPoint = this._dataloggerApp.getMetadata().getPoint(controlPointName.get());
                if (!optionalControlPoint.isPresent()) {
                    _LOGGER.warn((Messages.Entry)PAPMessages.CONTROL_POINT_UNKNOWN, new Object[]{controlPointName.get()});
                    return false;
                }
                setControlPoint.accept((Point)optionalControlPoint.get());
            }
            return true;
        }

        private boolean _setUpControlPoints(KeyedValues controlsProperties) {
            this._scanControlsBuilder = ScanControls.newBuilder().setScannerName(this._name);
            if (!this._setUpControlPoint(controlsProperties.getString(BARRIER_PROPERTY), this._scanControlsBuilder::setBarrierPoint)) {
                return false;
            }
            if (!this._setUpControlPoint(controlsProperties.getString(EACH_PROPERTY), this._scanControlsBuilder::setEachPoint)) {
                return false;
            }
            if (!this._setUpControlPoint(controlsProperties.getString(CRONTAB_PROPERTY), this._scanControlsBuilder::setCrontabPoint)) {
                return false;
            }
            return this._setUpControlPoint(controlsProperties.getString(ELAPSED_PROPERTY), this._scanControlsBuilder::setElapsedPoint);
        }

        private boolean _setUpSchedules(SyncEntity scannerSyncEntity, Set<Point> inputPoints, Set<Point> resultPoints) {
            Metadata metadata = this._dataloggerApp.getMetadata();
            DateTime startStamp = DateTime.now();
            for (Point resultPoint : metadata.getPointsCollection()) {
                _ProxyThread.Builder proxyThreadBuilder;
                if (resultPoint.getOrigin().orElse(null) != this._origin) continue;
                List pointRelations = resultPoint.getInputs();
                if (pointRelations.size() != 1) {
                    _LOGGER.warn((Messages.Entry)PAPMessages.POINT_EQ_1_INPUT, new Object[]{resultPoint});
                    continue;
                }
                Point inputPoint = ((PointRelation)pointRelations.get(0)).getInputPoint();
                PAPContext protocolContext = this._dataloggerApp.getProtocolContext(inputPoint, Optional.of(this._traces));
                if (protocolContext == null) {
                    return false;
                }
                if (!protocolContext.isPointActive(resultPoint) || !protocolContext.isPointActive(inputPoint) || !inputPoints.add(inputPoint)) continue;
                resultPoints.add(resultPoint);
                PAPProxy remoteProxy = protocolContext.getRemoteProxy(inputPoint).get();
                if (inputPoint == remoteProxy.getConnectionStatePoint().orElse(null)) continue;
                SyncEntity syncEntity = scannerSyncEntity;
                if (syncEntity == null) {
                    syncEntity = ((PointEntity)inputPoint).getSyncEntity().orElse(null);
                }
                if (syncEntity == null) {
                    if (this._scanControlsBuilder.mayTrigger()) {
                        syncEntity = SyncEntity.newBuilder().setClassDef(ClassDefEntity.newBuilder().setImpl(new ClassDefImpl(NullSync.class)).build()).build();
                        if (!syncEntity.setUp()) {
                            throw new InternalError();
                        }
                    } else {
                        _LOGGER.warn((Messages.Entry)PAPMessages.NO_SCHEDULE_FOR_POINT, new Object[]{inputPoint});
                        continue;
                    }
                }
                if ((proxyThreadBuilder = this._proxyThreadBuilders.get(remoteProxy)) == null) {
                    proxyThreadBuilder = _ProxyThread.newBuilder().setProtocolContext(protocolContext).setOrigin(inputPoint.getOrigin());
                    this._proxyThreadBuilders.put(remoteProxy, proxyThreadBuilder);
                    this._scanControlsBuilder.addSchedule(proxyThreadBuilder.getSchedule());
                }
                if (!proxyThreadBuilder.getSplitter().setUp(inputPoint)) {
                    return false;
                }
                proxyThreadBuilder.getSchedule().add((Schedule.Event)new Schedule.PointEvent(Optional.of(inputPoint), startStamp, syncEntity.getSync()));
            }
            return true;
        }
    }
}

