/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Traces;
import org.rvpf.metadata.Metadata;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.modbus.ModbusContext;
import org.rvpf.pap.modbus.ModbusServerProxy;

public final class ModbusClientContext
extends ModbusContext {
    private final Set<String> _origins = new HashSet<String>();

    ModbusClientContext(@Nonnull Optional<Metadata> metadata, @Nonnull Optional<Traces> traces) {
        super(metadata, traces);
    }

    @Override
    public boolean addRemotePoint(Point remotePoint, Attributes pointAttributes) {
        if (pointAttributes.getBoolean("CONNECTION_STATE")) {
            Optional<? extends PAPProxy> remoteProxy = this.getRemoteProxy(remotePoint);
            if (!remoteProxy.isPresent()) {
                return false;
            }
            if (!remoteProxy.get().setConnectionStatePoint(remotePoint)) {
                return false;
            }
            this.registerRemotePoint(remotePoint);
            return true;
        }
        return super.addRemotePoint(remotePoint, pointAttributes);
    }

    @Override
    public boolean isClientContext() {
        return true;
    }

    @Override
    protected int getDefaultPortForRemoteOrigin() {
        return 502;
    }

    @Override
    protected boolean isRemoteOriginNeeded(Origin origin, Attributes originAttributes) {
        String[] socketAddressStrings = originAttributes.getStrings("SOCKET_ADDRESS");
        if (socketAddressStrings.length != 1 || !"*".equals(socketAddressStrings[0].trim())) {
            return this._origins.add((String)origin.getNameInUpperCase().get());
        }
        return false;
    }

    @Override
    protected boolean isRemotePointNeeded(Point point, Attributes pointAttributes) {
        Optional origin = point.getOrigin();
        return origin.isPresent() && this._origins.contains(((Origin)origin.get()).getNameInUpperCase().get());
    }

    @Override
    protected ModbusServerProxy newRemoteProxy(Origin origin) {
        return new ModbusServerProxy(this, origin, this.getTraces());
    }
}

