/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.filter.ValueFilter;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.modbus.ModbusContext;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.ModbusServer;
import org.rvpf.pap.modbus.ModbusServerContext;
import org.rvpf.pap.modbus.message.MaskWriteRegister;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.message.WriteReadMultipleRegisters;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.ArrayRegister;
import org.rvpf.pap.modbus.register.BitsRegister;
import org.rvpf.pap.modbus.register.DiscreteArrayRegister;
import org.rvpf.pap.modbus.register.DiscreteRegister;
import org.rvpf.pap.modbus.register.DoubleRegister;
import org.rvpf.pap.modbus.register.FloatRegister;
import org.rvpf.pap.modbus.register.IntegerRegister;
import org.rvpf.pap.modbus.register.LongRegister;
import org.rvpf.pap.modbus.register.Register;
import org.rvpf.pap.modbus.register.SequenceRegister;
import org.rvpf.pap.modbus.register.ShortRegister;
import org.rvpf.pap.modbus.register.StampRegister;
import org.rvpf.pap.modbus.register.TimeRegister;
import org.rvpf.pap.modbus.register.WordArrayRegister;
import org.rvpf.pap.modbus.register.WordRegister;
import org.rvpf.pap.modbus.transport.Connection;
import org.rvpf.pap.modbus.transport.ServerConnection;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class ModbusClientProxy
extends ModbusProxy
implements ServiceThread.Target {
    private final NavigableMap<Integer, Register> _coilsByAddress = new TreeMap<Integer, Register>();
    private final NavigableMap<Integer, Register> _discretesByAddress = new TreeMap<Integer, Register>();
    private final NavigableMap<Integer, Register> _inputsByAddress = new TreeMap<Integer, Register>();
    private final NavigableMap<Integer, Register> _registersByAddress = new TreeMap<Integer, Register>();
    private final BlockingQueue<Transaction.Request> _requests = new LinkedBlockingQueue<Transaction.Request>();
    private ModbusServer _server;
    private Optional<ElapsedTime> _stampTick = Optional.empty();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private final AtomicInteger _writeRequestCount = new AtomicInteger();

    ModbusClientProxy(@Nonnull ModbusContext context, @Nonnull Origin origin) {
        super(context, origin);
    }

    private ModbusClientProxy(ModbusClientProxy other) {
        super(other);
        this._coilsByAddress.putAll(other._coilsByAddress);
        this._discretesByAddress.putAll(other._discretesByAddress);
        this._inputsByAddress.putAll(other._inputsByAddress);
        this._registersByAddress.putAll(other._registersByAddress);
        this._stampTick = other._stampTick;
    }

    public void addRequest(@Nonnull Transaction.Request request) {
        this.getThisLogger().trace(() -> new Message((Messages.Entry)ModbusMessages.RECEIVED_REQUEST, new Object[]{request.getName()}));
        if (request instanceof WriteTransaction.Request) {
            this._writeRequestCount.incrementAndGet();
        }
        this._requests.add(request);
    }

    @Override
    public PAPProxy copy() {
        return new ModbusClientProxy(this);
    }

    @Nonnull
    @CheckReturnValue
    public Collection<Register> getCoils() {
        return this._coilsByAddress.values();
    }

    @Nonnull
    @CheckReturnValue
    public Collection<Register> getDiscretes() {
        return this._discretesByAddress.values();
    }

    @Nonnull
    @CheckReturnValue
    public Collection<Register> getInputs() {
        return this._inputsByAddress.values();
    }

    @Nonnull
    @CheckReturnValue
    public Collection<Register> getRegisters() {
        return this._registersByAddress.values();
    }

    @Override
    public DateTime getStamp() {
        ElapsedTime stampTick;
        DateTime now;
        ElapsedTime elapsed;
        DateTime stamp = super.getStamp();
        if (stamp != null && (elapsed = (now = DateTime.now()).sub(stamp)).compareTo(stampTick = this._stampTick.get()) >= 0) {
            if (!ElapsedTime.EMPTY.equals((Object)stampTick)) {
                this.getThisLogger().warn((Messages.Entry)ModbusMessages.TICK_EXPIRED, new Object[]{stamp});
            }
            super.setStamp(Optional.empty());
            stamp = null;
        }
        return stamp;
    }

    @CheckReturnValue
    public boolean hasPendingUpdates() {
        return this._writeRequestCount.get() > 0;
    }

    public void run() throws ServiceNotAvailableException {
        DateTime startTime = DateTime.now();
        this.getThisLogger().debug((Messages.Entry)PAPMessages.STARTED_SERVICES, new Object[]{this.getOrigin().getName().get()});
        try {
            while (true) {
                Transaction.Request request;
                DateTime stamp = this.getStamp();
                if (this._stampTick.isPresent()) {
                    request = this._requests.poll(this._stampTick.get().toMillis(), TimeUnit.MILLISECONDS);
                    if (request == null) {
                        this.getThisLogger().warn((Messages.Entry)ModbusMessages.TICK_EXPIRED, new Object[]{stamp != null ? stamp : startTime});
                        this.setStamp(Optional.empty());
                        continue;
                    }
                } else {
                    request = this._requests.take();
                }
                this.getThisLogger().trace(() -> new Message((Messages.Entry)ModbusMessages.PROCESSING_REQUEST, new Object[]{request.getName()}));
                switch (request.getFunctionCode()) {
                    case 1: {
                        this._sendResponse(request, this._readRegisters(request, this._coilsByAddress, ModbusMessages.UNCONFIGURED_COIL, false));
                        break;
                    }
                    case 2: {
                        this._sendResponse(request, this._readRegisters(request, this._discretesByAddress, ModbusMessages.UNCONFIGURED_DISCRETE, true));
                        break;
                    }
                    case 3: {
                        this._sendResponse(request, this._readRegisters(request, this._registersByAddress, ModbusMessages.UNCONFIGURED_REGISTER, false));
                        break;
                    }
                    case 4: {
                        this._sendResponse(request, this._readRegisters(request, this._inputsByAddress, ModbusMessages.UNCONFIGURED_INPUT, true));
                        break;
                    }
                    case 23: {
                        this._sendResponse(request, this._writeReadRegisters(request, this._registersByAddress, ModbusMessages.UNCONFIGURED_REGISTER));
                        break;
                    }
                    case 5: 
                    case 15: {
                        this._writeRegisters(request, this._coilsByAddress, ModbusMessages.UNCONFIGURED_COIL);
                        break;
                    }
                    case 6: 
                    case 16: {
                        this._writeRegisters(request, this._registersByAddress, ModbusMessages.UNCONFIGURED_REGISTER);
                        break;
                    }
                    case 22: {
                        this._maskWriteRegister(request, this._registersByAddress, ModbusMessages.UNCONFIGURED_REGISTER);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                if (!(request instanceof WriteTransaction.Request)) continue;
                this._writeRequestCount.decrementAndGet();
            }
        }
        catch (InterruptedException exception) {
            this.getThisLogger().debug((Messages.Entry)PAPMessages.STOPPED_SERVICES, new Object[]{this.getOrigin().getName().get()});
            return;
        }
    }

    @Override
    public void setConnection(Connection newConnection) {
        Optional<? extends Connection> oldConnection = this.getConnection();
        if (oldConnection.isPresent()) {
            oldConnection.get().stop();
        }
        super.setConnection(newConnection);
    }

    @Override
    public void setSequence(int sequence) {
        int expected = this.getSequence() + 1 & 0xFFFF;
        if (sequence != expected) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.OUT_OF_SEQUENCE, new Object[]{String.valueOf(expected), String.valueOf(sequence)});
        }
        super.setSequence(sequence);
    }

    @Override
    public void setStamp(Optional<DateTime> stamp) {
        if (this._stampTick.isPresent()) {
            super.setStamp(stamp);
        }
    }

    public void start(@Nonnull ModbusServer server) {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Modbus server (proxy " + this.getOrigin() + ")");
        if (this._thread.compareAndSet(null, thread)) {
            this._server = server;
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    public void stop() {
        ServiceThread thread;
        Optional<? extends Connection> connection = this.getConnection();
        if (connection.isPresent()) {
            connection.get().stop();
            this.forgetConnection();
        }
        if ((thread = (ServiceThread)this._thread.getAndSet(null)) != null) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            Require.ignored((boolean)thread.interruptAndJoin(this.getThisLogger(), 0L));
        }
    }

    @Override
    public boolean supportsWildcardAddress() {
        return true;
    }

    @Override
    protected boolean setUp(Attributes originAttributes) {
        if (!super.setUp(originAttributes)) {
            return false;
        }
        this.setStampTick(originAttributes.getElapsed("STAMP_TICK", Optional.empty(), Optional.empty()));
        if (!this.setUpStampRegister(this.getRegisterAttribute(originAttributes, "STAMP_ADDRESS", (Entity)this.getOrigin()), false)) {
            return false;
        }
        if (!this.setUpSequenceRegister(this.getRegisterAttribute(originAttributes, "SEQUENCE_ADDRESS", (Entity)this.getOrigin()), false)) {
            return false;
        }
        return this.setUpTimeRegister(this.getRegisterAttribute(originAttributes, "TIME_ADDRESS", (Entity)this.getOrigin()), false);
    }

    void setStampTick(@Nonnull Optional<ElapsedTime> stampTick) {
        this._stampTick = stampTick;
    }

    @Override
    boolean setUpBitsRegister(Optional<Integer> address, Integer bit, Point point, boolean ignored, boolean readOnly) {
        BitsRegister bitsRegister;
        if (!address.isPresent()) {
            return true;
        }
        NavigableMap<Integer, Register> registers = readOnly ? this._inputsByAddress : this._registersByAddress;
        Register register = (Register)registers.get(address.get());
        if (register == null) {
            bitsRegister = new BitsRegister(address, readOnly);
            registers.put(address.get(), bitsRegister);
        } else {
            if (!(register instanceof BitsRegister)) {
                this.getThisLogger().warn((Messages.Entry)ModbusMessages.OVERLOADED_ADDRESS, new Object[]{address, point});
                return false;
            }
            bitsRegister = (BitsRegister)register;
        }
        return bitsRegister.setPoint(ignored ? Optional.empty() : Optional.of(point), bit);
    }

    @Override
    boolean setUpDiscreteArrayRegister(Optional<Integer> address, int size, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        DiscreteArrayRegister arrayRegister = new DiscreteArrayRegister(address, size, ignored ? Optional.empty() : Optional.of(point), readOnly);
        return this._setUpArrayRegister(arrayRegister, readOnly ? this._discretesByAddress : this._coilsByAddress);
    }

    @Override
    boolean setUpDiscreteRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new DiscreteRegister(address, ignored ? Optional.empty() : Optional.of(point), readOnly), readOnly ? this._discretesByAddress : this._coilsByAddress);
    }

    @Override
    boolean setUpDoubleRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        NavigableMap<Integer, Register> registersByAddress = readOnly ? this._inputsByAddress : this._registersByAddress;
        DoubleRegister doubleRegister = new DoubleRegister(address, ignored ? Optional.empty() : Optional.of(point), readOnly, this.isMiddleEndian());
        for (int i = 0; i < doubleRegister.size(); ++i) {
            if (this._addRegister(doubleRegister.getWordRegister(i), registersByAddress)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean setUpFloatRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        NavigableMap<Integer, Register> registersByAddress = readOnly ? this._inputsByAddress : this._registersByAddress;
        FloatRegister floatRegister = new FloatRegister(address, ignored ? Optional.empty() : Optional.of(point), readOnly, this.isMiddleEndian());
        if (!this._addRegister(floatRegister, registersByAddress)) {
            return false;
        }
        return this._addRegister(floatRegister.getNextRegister(), registersByAddress);
    }

    @Override
    boolean setUpIntegerRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly, boolean signed) {
        if (!address.isPresent()) {
            return true;
        }
        NavigableMap<Integer, Register> registersByAddress = readOnly ? this._inputsByAddress : this._registersByAddress;
        IntegerRegister integerRegister = new IntegerRegister(address, ignored ? Optional.empty() : Optional.of(point), signed, readOnly, this.isMiddleEndian());
        if (!this._addRegister(integerRegister, registersByAddress)) {
            return false;
        }
        return this._addRegister(integerRegister.getNextRegister(), registersByAddress);
    }

    @Override
    boolean setUpLongRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        NavigableMap<Integer, Register> registersByAddress = readOnly ? this._inputsByAddress : this._registersByAddress;
        LongRegister longRegister = new LongRegister(address, ignored ? Optional.empty() : Optional.of(point), readOnly, this.isMiddleEndian());
        for (int i = 0; i < longRegister.size(); ++i) {
            if (this._addRegister(longRegister.getWordRegister(i), registersByAddress)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean setUpMaskedRegister(Optional<Integer> address, Point point, boolean ignored, int mask) {
        return true;
    }

    @Override
    boolean setUpSequenceRegister(Optional<Integer> address, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new SequenceRegister(address, Optional.of(this), readOnly), readOnly ? this._inputsByAddress : this._registersByAddress);
    }

    @Override
    boolean setUpShortRegister(Optional<Integer> address, Point point, boolean ignored, boolean readOnly, boolean signed) {
        if (!address.isPresent()) {
            return true;
        }
        return this._addRegister(new ShortRegister(address, ignored ? Optional.empty() : Optional.of(point), signed, readOnly), readOnly ? this._inputsByAddress : this._registersByAddress);
    }

    @Override
    boolean setUpStampRegister(Optional<Integer> address, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        if (!this._stampTick.isPresent()) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.MISSING_ATTRIBUTE, new Object[]{"STAMP_TICK", "MODBUS", this.getOrigin()});
            this._stampTick = Optional.of(ElapsedTime.EMPTY);
        }
        NavigableMap<Integer, Register> registersByAddress = readOnly ? this._inputsByAddress : this._registersByAddress;
        StampRegister stampRegister = new StampRegister(address, Optional.of(this), readOnly, this.isMiddleEndian());
        if (!this._addRegister(stampRegister, registersByAddress)) {
            return false;
        }
        return this._addRegister(stampRegister.getNextRegister(), registersByAddress);
    }

    @Override
    boolean setUpTimeRegister(Optional<Integer> address, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        NavigableMap<Integer, Register> registersByAddress = readOnly ? this._inputsByAddress : this._registersByAddress;
        TimeRegister timeRegister = new TimeRegister(address, Optional.of(this), readOnly, this.isMiddleEndian());
        StampRegister stampRegister = timeRegister.getStampRegister();
        if (!this._addRegister(timeRegister, registersByAddress)) {
            return false;
        }
        if (!this._addRegister(timeRegister.getNextRegister(), registersByAddress)) {
            return false;
        }
        if (!this._addRegister(stampRegister, registersByAddress)) {
            return false;
        }
        return this._addRegister(stampRegister.getNextRegister(), registersByAddress);
    }

    @Override
    boolean setUpWordArrayRegister(Optional<Integer> address, int size, Point point, boolean ignored, boolean readOnly) {
        if (!address.isPresent()) {
            return true;
        }
        WordArrayRegister arrayRegister = new WordArrayRegister(address, size, ignored ? Optional.empty() : Optional.of(point), readOnly);
        return this._setUpArrayRegister(arrayRegister, readOnly ? this._inputsByAddress : this._registersByAddress);
    }

    private boolean _addRegister(Register register, NavigableMap<Integer, Register> registersByAddress) {
        Integer address = register.getAddress().get();
        if (address < 1 || 65536 < address) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.INVALID_ADDRESS, new Object[]{address, Arrays.toString(register.getPoints())});
            return false;
        }
        if (registersByAddress.get(address) != null) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.OVERLOADED_ADDRESS, new Object[]{address, Arrays.toString(register.getPoints())});
            return false;
        }
        registersByAddress.put(address, register);
        return true;
    }

    private void _maskWriteRegister(Transaction.Request request, NavigableMap<Integer, Register> registers, Messages.Entry unconfiguredAddress) throws InterruptedException, ServiceNotAvailableException {
        short[] values = this._readRegisters(request, registers, unconfiguredAddress, false);
        short value = values.length == 1 ? values[0] : (short)0;
        ((MaskWriteRegister.Request)request).applyMasks(value);
        this._writeRegisters(request, registers, unconfiguredAddress);
    }

    private short[] _readRegisters(Transaction.Request request, NavigableMap<Integer, Register> registers, Messages.Entry unconfiguredAddress, boolean readOnly) throws InterruptedException, ServiceNotAvailableException {
        int startingAddress = request.getReadAddress();
        int quantity = request.getReadQuantity();
        int stoppingAddress = startingAddress + quantity;
        LinkedList<Point> points = new LinkedList<Point>();
        IdentityHashMap<Point, Register> registersByPoint = new IdentityHashMap<Point, Register>();
        Map.Entry<Integer, Register> ceilingEntry = registers.ceilingEntry(startingAddress);
        for (int address = startingAddress; address < stoppingAddress; ++address) {
            Register register;
            if (ceilingEntry == null || address < ceilingEntry.getKey()) {
                register = new WordRegister(Optional.of(address), Optional.empty(), readOnly);
                this.getThisLogger().warn(unconfiguredAddress, new Object[]{String.valueOf(address)});
                registers.put(address, register);
                continue;
            }
            register = ceilingEntry.getValue();
            ceilingEntry = registers.higherEntry(ceilingEntry.getKey());
            for (Point point : register.getPoints()) {
                if (point == null) continue;
                points.add(point);
                registersByPoint.put(point, register);
            }
        }
        if (!points.isEmpty()) {
            if (request instanceof ReadTransaction && !(request instanceof WriteReadMultipleRegisters)) {
                this._server.waitWhileUpdating();
            }
            ModbusServerContext serverContext = (ModbusServerContext)this._server.getContext();
            PointValue[] pointValues = this._server.getResponder().get().select(points.toArray(new Point[points.size()]));
            for (Point point : pointValues) {
                Point proxyPoint;
                if (point == null || (proxyPoint = (Point)serverContext.getRemotePoint(point.getPointUUID()).orElse(null)) == null) continue;
                Register register = (Register)registersByPoint.get(proxyPoint);
                register.putPointValue(point.morph(Optional.of(proxyPoint), Optional.empty()).encoded());
            }
        }
        short[] values = new short[quantity];
        int index = 0;
        for (Register register : registers.subMap(startingAddress, stoppingAddress).values()) {
            values[index++] = register.getContent();
        }
        return values;
    }

    private void _sendResponse(Transaction.Request request, short[] values) throws InterruptedException {
        Optional<? extends Connection> connection = this.getConnection();
        if (!connection.isPresent()) {
            throw new InterruptedException();
        }
        ((ServerConnection)connection.get()).sendResponse(((ReadTransaction.Request)request).createResponse(values));
    }

    private boolean _setUpArrayRegister(ArrayRegister arrayRegister, NavigableMap<Integer, Register> registersByAddress) {
        if (!this._addRegister(arrayRegister, registersByAddress)) {
            return false;
        }
        for (int i = 1; i < arrayRegister.size(); ++i) {
            if (this._addRegister(arrayRegister.newMinion(i), registersByAddress)) continue;
            return false;
        }
        return true;
    }

    private short[] _writeReadRegisters(Transaction.Request request, NavigableMap<Integer, Register> registers, Messages.Entry unconfiguredAddress) throws InterruptedException, ServiceNotAvailableException {
        this._writeRegisters(request, registers, unconfiguredAddress);
        return this._readRegisters(request, registers, unconfiguredAddress, false);
    }

    private void _writeRegisters(Transaction.Request request, NavigableMap<Integer, Register> registers, Messages.Entry unconfiguredAddress) {
        int startingAddress = request.getWriteAddress();
        short[] registerValues = request.getWriteValues();
        int stoppingAddress = startingAddress + registerValues.length;
        DateTime requestStamp = request.getStamp();
        Map.Entry<Integer, Register> ceilingEntry = registers.ceilingEntry(startingAddress);
        for (int address = startingAddress; address < stoppingAddress; ++address) {
            Register register;
            if (ceilingEntry == null || address < ceilingEntry.getKey()) {
                register = new WordRegister(Optional.of(address), Optional.empty(), false);
                this.getThisLogger().warn(unconfiguredAddress, new Object[]{String.valueOf(address)});
                registers.put(address, register);
            } else {
                register = ceilingEntry.getValue();
                ceilingEntry = registers.higherEntry(ceilingEntry.getKey());
            }
            register.setContent(registerValues[address - startingAddress]);
        }
        for (Register register : registers.subMap(startingAddress, stoppingAddress).values()) {
            for (PointValue pointValue : register.getPointValues()) {
                if (pointValue == null) continue;
                ModbusServerContext serverContext = (ModbusServerContext)this._server.getContext();
                Map<Point, ValueFilter> valueFilters = serverContext.getValueFilters();
                ValueFilter filter = valueFilters.get(pointValue.getPoint().get());
                DateTime stamp = this.getStamp();
                pointValue.setStamp(stamp != null ? stamp : requestStamp);
                if (filter != null) {
                    for (PointValue filteredValue : filter.filter(Optional.of(pointValue))) {
                        this._server.addPointValue(filteredValue);
                    }
                    continue;
                }
                this._server.addPointValue(pointValue);
            }
        }
    }
}

