/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.PAPServer;
import org.rvpf.pap.SerialPortWrapper;
import org.rvpf.pap.modbus.ModbusClientProxy;
import org.rvpf.pap.modbus.ModbusContext;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.ModbusServerContext;
import org.rvpf.pap.modbus.transport.Connection;
import org.rvpf.pap.modbus.transport.ServerConnection;
import org.rvpf.pap.modbus.transport.Transport;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class ModbusServer
extends PAPServer.Abstract {
    private final ModbusServerContext _context;
    private final List<_Listener> _listeners = new LinkedList<_Listener>();
    private final Object _mutex = new Object();
    private final AtomicBoolean _stopped = new AtomicBoolean();
    private final BlockingQueue<PointValue> _updates = new LinkedBlockingQueue<PointValue>();
    private boolean _updating;

    ModbusServer(@Nonnull ModbusServerContext serverContext) {
        this._context = serverContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPointValue(@Nonnull PointValue pointValue) {
        Object object = this._mutex;
        synchronized (object) {
            this._updating = true;
            this._updates.add(pointValue);
        }
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ModbusClientProxy> getClientProxy(@Nonnull Origin origin) {
        return this.getContext().getRemoteProxyByOrigin(origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdating() {
        Object object = this._mutex;
        synchronized (object) {
            for (PAPProxy pAPProxy : this.getContext().getRemoteProxies()) {
                if (!((ModbusClientProxy)pAPProxy).hasPendingUpdates()) continue;
                return true;
            }
            return this._updating;
        }
    }

    @Override
    public Optional<PointValue> nextUpdate(long timeout) throws InterruptedException {
        return timeout < 0L ? Optional.of(this._updates.take()) : Optional.ofNullable(this._updates.poll(timeout, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdatesCommit() {
        Object object = this._mutex;
        synchronized (object) {
            if (this._updates.isEmpty()) {
                this._updating = false;
                this._mutex.notifyAll();
            }
        }
    }

    @Override
    public boolean setUpListener(@Nonnull KeyedGroups listenerProperties) {
        String portName;
        Origin defaultOrigin;
        Optional originName = listenerProperties.getString("origin");
        boolean success = true;
        int listeners = 0;
        if (originName.isPresent()) {
            Optional<Origin> origin = this.getContext().getRemoteOrigin(originName);
            if (origin.isPresent()) {
                defaultOrigin = origin.get();
            } else {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN, new Object[]{originName.get()});
                defaultOrigin = null;
            }
        } else {
            defaultOrigin = null;
        }
        int unitIdentifier = listenerProperties.getInt("unit.identifier", 1);
        if (unitIdentifier < 1 || 247 < unitIdentifier) {
            this.getThisLogger().warn((Messages.Entry)ModbusMessages.BAD_UNIT_IDENTIFIER, new Object[]{String.valueOf(unitIdentifier)});
            unitIdentifier = 1;
        }
        Optional listenAddress = listenerProperties.getString("socket.address");
        Optional listenPort = listenerProperties.getInteger("socket.port", Optional.empty());
        if (listenAddress.isPresent() || listenPort.isPresent()) {
            success = this._setUpSocketListener(defaultOrigin, listenAddress, listenPort, (byte)unitIdentifier);
            ++listeners;
        }
        if ((portName = (String)listenerProperties.getString("serial.port").orElse(null)) != null) {
            int portSpeed = listenerProperties.getInt("serial.speed", 9600);
            int portMode = Transport.serialMode(listenerProperties.getString("serial.mode").orElse(null));
            int portDataBits = Transport.serialModeDataBits(portMode);
            String portParity = (String)listenerProperties.getString("serial.parity", Optional.of("EVEN")).get();
            boolean portModem = listenerProperties.getBoolean("serial.modem", false);
            boolean portControl = listenerProperties.getBoolean("serial.control", false);
            success &= this._setupSerialListener(defaultOrigin, portName, portSpeed, portDataBits, portParity, portModem, portControl, portMode, (byte)unitIdentifier);
            ++listeners;
        }
        if (listeners == 0) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.NO_LISTENERS, new Object[0]);
            success = false;
        }
        return success;
    }

    @Override
    public void start() {
        this._stopped.set(false);
        Collection<? extends PAPProxy> remoteProxies = this.getContext().getRemoteProxies();
        if (this.getThisLogger().isDebugEnabled()) {
            Collection<Point> points = this.getContext().getRemotePoints();
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.STARTING_SERVER, new Object[0]);
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.CONFIGURED_PROXIES, new Object[]{String.valueOf(remoteProxies.size())});
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.CONFIGURED_POINTS, new Object[]{String.valueOf(points.size())});
        }
        remoteProxies.forEach(proxy -> ((ModbusClientProxy)proxy).start(this));
        this._listeners.forEach(listener -> listener.start());
        this.getThisLogger().debug((Messages.Entry)ModbusMessages.STARTED_SERVER, new Object[0]);
    }

    @Override
    public void stop() {
        if (this._stopped.compareAndSet(false, true)) {
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.STOPPING_SERVER, new Object[0]);
            this._listeners.forEach(listener -> listener.stop());
            this.getContext().getRemoteProxies().forEach(proxy -> ((ModbusClientProxy)proxy).stop());
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.STOPPED_SERVER, new Object[0]);
        }
    }

    @Override
    public void tearDown() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWhileUpdating() throws InterruptedException {
        Object object = this._mutex;
        synchronized (object) {
            while (this.isUpdating()) {
                this._mutex.wait();
            }
        }
    }

    @Override
    protected PAPContext getContext() {
        return this._context;
    }

    private boolean _setUpSocketListener(Origin defaultOrigin, Optional<String> listenAddress, Optional<Integer> listenPort, byte unitIdentifier) {
        _Listener._OnSocket listener;
        Optional<Object> defaultProxy;
        if (defaultOrigin != null) {
            defaultProxy = this.getClientProxy(defaultOrigin);
            if (!defaultProxy.isPresent()) {
                this.getThisLogger().error((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN, new Object[]{defaultOrigin});
                return false;
            }
        } else {
            defaultProxy = Optional.empty();
        }
        if (!(listener = new _Listener._OnSocket(this, defaultProxy)).setUp(listenAddress, listenPort, unitIdentifier)) {
            return false;
        }
        this._listeners.add(listener);
        return true;
    }

    private boolean _setupSerialListener(Origin defaultOrigin, String portName, int portSpeed, int portDataBits, String portParity, boolean portModem, boolean portControl, int portMode, byte unitIdentifier) {
        _Listener._OnSerial listener;
        Optional<ModbusProxy> clientProxy = ((ModbusContext)this.getContext()).getRemoteProxyBySerialPortName(portName);
        if (!clientProxy.isPresent()) {
            if (defaultOrigin != null) {
                clientProxy = this.getClientProxy(defaultOrigin);
                if (!clientProxy.isPresent()) {
                    this.getThisLogger().error((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN, new Object[]{defaultOrigin});
                    return false;
                }
            } else {
                this.getThisLogger().error((Messages.Entry)ModbusMessages.NO_ORIGIN, new Object[]{portName});
                return false;
            }
        }
        if (!(listener = new _Listener._OnSerial(this, clientProxy)).setUp(portName, portSpeed, portDataBits, portParity, portModem, portControl, portMode, unitIdentifier)) {
            return false;
        }
        this._listeners.add(listener);
        return true;
    }

    private static abstract class _Listener {
        private final Optional<? extends ModbusProxy> _defaultProxy;
        private final Logger _logger = Logger.getInstance(this.getClass());
        private final ModbusServer _server;
        private byte _unitIdentifier;

        _Listener(@Nonnull ModbusServer server, @Nonnull Optional<? extends ModbusProxy> defaultProxy) {
            this._server = server;
            this._defaultProxy = defaultProxy;
        }

        @Nonnull
        @CheckReturnValue
        Optional<? extends ModbusProxy> getDefaultProxy() {
            return this._defaultProxy;
        }

        @Nonnull
        @CheckReturnValue
        ModbusServerContext getServerContext() {
            return (ModbusServerContext)this._server.getContext();
        }

        @Nonnull
        @CheckReturnValue
        Logger getThisLogger() {
            return this._logger;
        }

        @CheckReturnValue
        byte getUnitIdentifier() {
            return this._unitIdentifier;
        }

        void setUnitIdentifier(byte unitIdentifier) {
            this._unitIdentifier = unitIdentifier;
        }

        abstract void start();

        final ServerConnection startServerConnection(@Nonnull Transport transport, @Nonnull ModbusClientProxy clientProxy) {
            ServerConnection serverConnection = new ServerConnection(transport, clientProxy, Optional.empty(), !this._server.getResponder().isPresent());
            serverConnection.start();
            return serverConnection;
        }

        abstract void stop();

        private static final class _OnSocket
        extends _Listener
        implements ServiceThread.Target {
            private String _listenAddress;
            private int _listenPort;
            private ServerSocket _serverSocket;
            private final AtomicReference<ServiceThread> _thread = new AtomicReference();

            _OnSocket(@Nonnull ModbusServer server, @Nonnull Optional<? extends ModbusProxy> defaultProxy) {
                super(server, defaultProxy);
            }

            public void run() {
                ServerSocket serverSocket = this._serverSocket;
                this.getThisLogger().info((Messages.Entry)ModbusMessages.STARTED_LISTENING, new Object[]{serverSocket.getLocalSocketAddress(), String.valueOf(this.getUnitIdentifier() & 0xFF)});
                while (true) {
                    Socket socket;
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (SocketException exception) {
                        break;
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                    InetAddress proxyAddress = socket.getInetAddress();
                    ModbusServerContext context = this.getServerContext();
                    Optional<ModbusProxy> remoteProxy = context.getRemoteProxyByInetAddress(proxyAddress);
                    if (!remoteProxy.isPresent() && !(remoteProxy = this.getDefaultProxy()).isPresent()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.getThisLogger().warn((Messages.Entry)ModbusMessages.CLIENT_CONNECTION_REJECTED, new Object[]{proxyAddress});
                        continue;
                    }
                    remoteProxy.get().disconnect();
                    this.startServerConnection(Transport.newSocketTransport(socket, this.getUnitIdentifier(), context.getTraces()), (ModbusClientProxy)remoteProxy.get());
                }
                this.getThisLogger().info((Messages.Entry)ModbusMessages.STOPPED_LISTENING, new Object[]{serverSocket.getLocalSocketAddress()});
            }

            @CheckReturnValue
            boolean setUp(@Nonnull Optional<String> optionalListenAddress, @Nonnull Optional<Integer> listenPort, byte unitIdentifier) {
                if (optionalListenAddress.isPresent()) {
                    String listenAddress = optionalListenAddress.get().trim();
                    if (listenAddress.isEmpty()) {
                        listenAddress = "*";
                    }
                    this._listenAddress = listenAddress;
                    this.getThisLogger().info((Messages.Entry)ModbusMessages.LISTEN_ADDRESS, new Object[]{listenAddress});
                }
                if (listenPort.isPresent()) {
                    this._listenPort = listenPort.get();
                    this.getThisLogger().info((Messages.Entry)ModbusMessages.LISTEN_PORT, new Object[]{String.valueOf(listenPort.get())});
                }
                this.setUnitIdentifier(unitIdentifier);
                return true;
            }

            @Override
            void start() {
                int listenPort = this._listenPort > 0 ? this._listenPort : 502;
                InetAddress listenAddress = null;
                try {
                    listenAddress = "*".equals(this._listenAddress) ? null : InetAddress.getByName(this._listenAddress);
                    this._serverSocket = new ServerSocket(listenPort, 0, listenAddress);
                }
                catch (IOException exception) {
                    throw new RuntimeException("Listen port " + listenPort + " , listen address '" + listenAddress + "'", exception);
                }
                ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Modbus server (listener on " + this._serverSocket.getLocalSocketAddress() + ")");
                if (this._thread.compareAndSet(null, thread)) {
                    this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
                    thread.start();
                }
            }

            @Override
            void stop() {
                ServiceThread thread;
                ServerSocket serverSocket = this._serverSocket;
                if (serverSocket != null) {
                    this._serverSocket = null;
                    try {
                        serverSocket.close();
                    }
                    catch (IOException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                if ((thread = (ServiceThread)this._thread.getAndSet(null)) != null) {
                    this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                    Require.ignored((boolean)thread.join(this.getThisLogger(), 0L));
                }
            }
        }

        private static final class _OnSerial
        extends _Listener
        implements ServiceThread.Target,
        SerialPortWrapper.StatusChangeListener {
            private SerialPortWrapper _serialPort;
            private int _serialPortMode;
            private final Object _statusChangeSemaphore = new Object();
            private final AtomicReference<ServiceThread> _thread = new AtomicReference();

            _OnSerial(@Nonnull ModbusServer server, @Nonnull Optional<? extends ModbusProxy> defaultProxy) {
                super(server, defaultProxy);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusChange(SerialPortWrapper serialPort, SerialPortWrapper.Event event) {
                Require.equal((Object)this._serialPort, (Object)serialPort);
                Object object = this._statusChangeSemaphore;
                synchronized (object) {
                    this._statusChangeSemaphore.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.getThisLogger().info((Messages.Entry)ModbusMessages.STARTED_LISTENING, new Object[]{this._serialPort.getPortName(), String.valueOf(this.getUnitIdentifier() & 0xFF)});
                this.getThisLogger().debug((Messages.Entry)ModbusMessages.SERIAL_MODE, new Object[]{this._serialPort.getPortName(), Transport.serialModeName(this._serialPortMode)});
                try {
                    Thread currentThread = Thread.currentThread();
                    while (this._thread.get() == currentThread) {
                        try {
                            this._serialPort.open();
                            this._serialPort.purge();
                            this._serialPort.addStatusChangeListener(this);
                        }
                        catch (IOException exception) {
                            throw new RuntimeException(exception);
                        }
                        if (this._serialPort.isPortModem()) {
                            Object exception = this._statusChangeSemaphore;
                            synchronized (exception) {
                                while (this._thread.get() == currentThread && this._serialPort.isOpen() && !this._serialPort.getDSR()) {
                                    this._statusChangeSemaphore.wait();
                                }
                            }
                        }
                        if (this._thread.get() == currentThread) {
                            if (this._serialPort.isClosed()) continue;
                            ServerConnection connection = this.startServerConnection(Transport.newSerialPortTransport(this._serialPort, this._serialPortMode, this.getUnitIdentifier(), this.getServerContext().getTraces()), (ModbusClientProxy)this.getDefaultProxy().get());
                            try {
                                Object object = this._statusChangeSemaphore;
                                synchronized (object) {
                                    while (this._serialPort.isOpen()) {
                                        this._statusChangeSemaphore.wait();
                                        if (this._thread.get() == currentThread) continue;
                                    }
                                    continue;
                                }
                            }
                            finally {
                                ((Connection)connection).stop();
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.getThisLogger().info((Messages.Entry)ModbusMessages.STOPPED_LISTENING, new Object[]{this._serialPort.getPortName()});
            }

            @CheckReturnValue
            boolean setUp(@Nonnull String portName, int portSpeed, int portDataBits, @Nonnull String portParity, boolean portModem, boolean portControl, int portMode, byte unitIdentifier) {
                this._serialPort = SerialPortWrapper.newBuilder().setPortName(portName).setPortSpeed(portSpeed).setPortDataBits(portDataBits).setPortParity(portParity).setPortModem(portModem).setPortControl(portControl).build();
                this._serialPortMode = portMode;
                this.setUnitIdentifier(unitIdentifier);
                return true;
            }

            @Override
            void start() {
                ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Modbus server (listener on " + this._serialPort.getPortName() + ")");
                if (this._thread.compareAndSet(null, thread)) {
                    this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
                    thread.start();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void stop() {
                ServiceThread thread;
                Object object = this._statusChangeSemaphore;
                synchronized (object) {
                    thread = this._thread.getAndSet(null);
                    if (thread != null) {
                        this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                    }
                    this._statusChangeSemaphore.notifyAll();
                }
                if (thread != null) {
                    try {
                        this._serialPort.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (thread != Thread.currentThread()) {
                        Require.ignored((boolean)thread.join(this.getThisLogger(), 0L));
                    }
                }
            }
        }
    }
}

