/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPReadTransaction;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.register.Register;

public interface ReadTransaction {

    public static abstract class Response
    extends Transaction.Response
    implements PAPReadTransaction.Response {
        private final DateTime _stamp = DateTime.now();
        private short[] _values;

        protected Response(@Nonnull Request request) {
            super(request);
        }

        protected Response(@Nonnull Prefix prefix, @Nonnull Request request) {
            super(prefix, request);
        }

        @Override
        public Optional<PointValue> getPointValue() {
            if (!this.isSuccess()) {
                return Optional.empty();
            }
            Optional<Register> register = this.getRequest().getServerProxy().getRegister(this.getRequest().getPoint());
            if (!register.isPresent()) {
                return Optional.empty();
            }
            register.get().setContents(this.getValues());
            PointValue[] pointValues = register.get().getPointValues();
            if (pointValues.length != 1) {
                return Optional.empty();
            }
            PointValue pointValue = pointValues[0];
            pointValue.setStamp(this.getStamp());
            return Optional.of(pointValue);
        }

        @Override
        public Request getRequest() {
            return (Request)Require.notNull((Object)super.getRequest());
        }

        @Nonnull
        @CheckReturnValue
        public DateTime getStamp() {
            return this._stamp;
        }

        public final short[] getValues() {
            return this._values;
        }

        protected void setValues(short[] values) {
            this._values = values;
        }
    }

    public static abstract class Request
    extends Transaction.Request
    implements PAPReadTransaction.Request {
        private int _address;
        private Point _point;
        private int _quantity;

        protected Request() {
        }

        protected Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public final int getAddress() {
            return this._address;
        }

        @Override
        public Point getPoint() {
            return (Point)Require.notNull((Object)this._point);
        }

        @CheckReturnValue
        public int getQuantity() {
            return this._quantity;
        }

        @Override
        public int getReadAddress() {
            return this.getAddress();
        }

        @Override
        public int getReadQuantity() {
            return this.getQuantity();
        }

        public void setPoint(@Nonnull Point point) {
            this._point = point;
        }

        public void setQuantity(int quantity) {
            this._quantity = quantity & 0xFFFF;
        }

        protected Response initResponse(@Nonnull Response response, @Nonnull short[] values) {
            if (values.length != this.getQuantity()) {
                throw new IllegalArgumentException();
            }
            response.setValues(values);
            return response;
        }

        protected void setAddress(int address) {
            this._address = address & 0xFFFF;
        }
    }
}

