/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.transport.Transport;

public interface WriteMultipleCoils {
    public static final short FUNCTION_CODE = 15;
    public static final short MAXIMUM_QUANTITY = 1968;

    public static final class Response
    extends WriteTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (WriteTransaction.Request)request);
        }

        Response(@Nonnull Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int address = (transport.receiveShort() & 0xFFFF) + 1;
            short quantity = transport.receiveShort();
            if (address != this.getRequest().getAddress()) {
                throw new Transaction.FormatException(ModbusMessages.STARTING_ADDRESS_MATCH, new Object[0]);
            }
            if (quantity != this.getRequest().getValues().length) {
                throw new Transaction.FormatException(ModbusMessages.QUANTITY_OUTPUTS_MATCH, new Object[0]);
            }
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getRequest().getAddress() - 1);
            transport.sendShort(this.getRequest().getValues().length);
            Response.writeSuffix(transport);
        }
    }

    public static final class Request
    extends WriteTransaction.Request {
        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int startingAddress, @Nonnull short[] outputValues) {
            int quantity = outputValues.length;
            if (quantity < 1 || 1968 < quantity) {
                throw new IllegalArgumentException();
            }
            this.setAddress(startingAddress);
            this.setValues(outputValues);
        }

        @Override
        public Transaction.Response createResponse(short[] values) {
            Require.equal((long)0L, (long)values.length);
            return this.isValid() ? new Response(this) : this.errorResponse();
        }

        @Override
        public byte getFunctionCode() {
            return 15;
        }

        @Override
        public int getLength() {
            return 5 + Request._byteCount(this.getValues().length);
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this.setAddress(transport.receiveShort() + 1);
            int quantity = transport.receiveShort() & 0xFFFF;
            int byteCount = transport.receiveByte() & 0xFF;
            if (byteCount != Request._byteCount(quantity)) {
                throw new Transaction.FormatException(ModbusMessages.BYTE_COUNT_OUTPUTS, String.valueOf(byteCount), (short)quantity);
            }
            if (!this.getPrefix().checkDataLength(5 + byteCount)) {
                throw new Transaction.FormatException(ModbusMessages.MESSAGE_LENGTH_MBAP, new Object[0]);
            }
            short[] values = new short[quantity];
            int index = 0;
            block0: for (int i = 0; i < byteCount; ++i) {
                byte value = transport.receiveByte();
                int shift = Math.min(8, quantity - index);
                --shift;
                while (shift >= 0) {
                    values[index] = (short)(value >> shift & 1);
                    if (++index >= quantity) continue block0;
                    --shift;
                }
            }
            this.setValues(values);
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            short[] values = this.getValues();
            int quantity = values.length;
            int byteCount = Request._byteCount(quantity);
            this.write(5 + byteCount, transport);
            transport.sendShort(this.getAddress() - 1);
            transport.sendShort(quantity);
            transport.sendByte(byteCount);
            int index = 0;
            for (int i = 0; i < byteCount; ++i) {
                int shift = Math.min(8, quantity - index);
                int valueByte = 0;
                --shift;
                while (shift >= 0) {
                    int value = values[index] != 0 ? 1 : 0;
                    valueByte = (byte)(valueByte | value << shift);
                    if (++index >= quantity) break;
                    --shift;
                }
                transport.sendByte(valueByte);
            }
            Request.writeSuffix(transport);
        }

        private static int _byteCount(int quantity) {
            int byteCount = quantity / 8;
            if (quantity % 8 != 0) {
                ++byteCount;
            }
            return byteCount;
        }
    }
}

