/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.message;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.Prefix;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.transport.ExceptionCode;
import org.rvpf.pap.modbus.transport.Transport;

public interface WriteSingleCoil {
    public static final short FUNCTION_CODE = 5;

    public static final class Response
    extends WriteTransaction.Response {
        public Response(@Nonnull Prefix prefix, @Nonnull Transaction.Request request) {
            super(prefix, (WriteTransaction.Request)request);
        }

        Response(@Nonnull Request request) {
            super(request);
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public void read(Transport transport) throws IOException, Transaction.FormatException {
            int address = (transport.receiveShort() & 0xFFFF) + 1;
            short value = transport.receiveShort();
            if (address != this.getRequest().getAddress()) {
                throw new Transaction.FormatException(ModbusMessages.OUTPUT_ADDRESS_MATCH, new Object[0]);
            }
            if (value != this.getRequest().getValue()) {
                throw new Transaction.FormatException(ModbusMessages.OUTPUT_VALUE_MATCH, new Object[0]);
            }
            Response.readSuffix(transport);
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getRequest().getAddress() - 1);
            transport.sendShort(this.getRequest().getValue());
            Response.writeSuffix(transport);
        }
    }

    public static final class Request
    extends WriteTransaction.Request {
        public Request(@Nonnull Prefix prefix) {
            super(prefix);
        }

        public Request(int outputAddress, int outputValue) {
            this.setAddress(outputAddress);
            this.setValue(outputValue != 0 ? 65280 : 0);
        }

        @Override
        public Transaction.Response createResponse(short[] values) {
            Require.equal((long)0L, (long)values.length);
            return this.isValid() ? new Response(this) : this.errorResponse();
        }

        @Override
        public byte getFunctionCode() {
            return 5;
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public Request read(Transport transport) throws IOException, Transaction.FormatException {
            this.setAddress(transport.receiveShort() + 1);
            short value = transport.receiveShort();
            if (value != 0 && value != -256) {
                this.setExceptionCode(ExceptionCode.ILLEGAL_DATA_VALUE);
            }
            this.setValue(value);
            Request.readSuffix(transport);
            return this;
        }

        @Override
        public void write(Transport transport) throws IOException {
            this.write(this.getLength(), transport);
            transport.sendShort(this.getAddress() - 1);
            transport.sendShort(this.getValue() != 0 ? 65280 : 0);
            Request.writeSuffix(transport);
        }
    }
}

