/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.Register;

public abstract class ArrayRegister
extends Register {
    private final short[] _contents;
    private final Point[] _points;
    private final int _size;

    protected ArrayRegister(@Nonnull Optional<Integer> address, int size, @Nonnull Optional<Point> point, boolean readOnly) {
        super(address, readOnly);
        Point[] pointArray;
        this._size = size;
        this._contents = new short[size];
        if (point.isPresent()) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = point.get();
        } else {
            pointArray = NO_POINTS;
        }
        this._points = pointArray;
    }

    @Override
    public final short getContent() {
        return this._contents[0];
    }

    @Override
    public final Point[] getPoints() {
        return this._points;
    }

    @Nonnull
    @CheckReturnValue
    public final Register newMinion(int offset) {
        return new Minion(this.getAddress().get() + offset, this.isReadOnly());
    }

    @Override
    public final void setContent(short content) {
        this._contents[0] = content;
    }

    @Override
    public final void setContents(short[] contents) {
        Require.equal((long)this.size(), (long)contents.length);
        System.arraycopy(contents, 0, this._contents, 0, this.size());
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Nonnull
    @CheckReturnValue
    protected final short[] getContents() {
        return this._contents;
    }

    @CheckReturnValue
    final short getContent(int contentIndex) {
        return this._contents[contentIndex];
    }

    final void setContent(int contentIndex, short content) {
        this._contents[contentIndex] = content;
    }

    private final class Minion
    extends Register {
        protected Minion(Integer address, boolean readOnly) {
            super(Optional.of(address), readOnly);
        }

        @Override
        public ReadTransaction.Request createReadRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WriteTransaction.Request createWriteRequest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public short getContent() {
            return ArrayRegister.this.getContent(this._getContentIndex());
        }

        @Override
        public PointValue[] getPointValues() {
            return NO_POINT_VALUES;
        }

        @Override
        public Point[] getPoints() {
            return NO_POINTS;
        }

        @Override
        public void putPointValue(PointValue pointValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setContent(short content) {
            ArrayRegister.this.setContent(this._getContentIndex(), content);
        }

        @Override
        public int size() {
            return 1;
        }

        private int _getContentIndex() {
            return this.getAddress().get() - ArrayRegister.this.getAddress().get();
        }
    }
}

