/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.register.LongRegister;

public final class DoubleRegister
extends LongRegister {
    public DoubleRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly, boolean middleEndian) {
        super(address, point, readOnly, middleEndian);
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues = this.getPoints() != NO_POINTS ? new PointValue[]{new PointValue(this.getPoints()[0], Optional.empty(), null, (Serializable)Double.valueOf(Double.longBitsToDouble(this.getLong())))} : NO_POINT_VALUES;
        return pointValues;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        this.setLong(Double.doubleToLongBits(pointValue.getValue() instanceof Number ? ((Number)pointValue.getValue()).doubleValue() : Double.NaN));
    }
}

