/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.register.IntegerRegister;

public final class FloatRegister
extends IntegerRegister {
    public FloatRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly, boolean middleEndian) {
        super(address, point, true, readOnly, middleEndian);
    }

    @Override
    public PointValue[] getPointValues() {
        Point[] points = this.getPoints();
        PointValue[] pointValues = points != NO_POINTS ? new PointValue[]{new PointValue(points[0], Optional.empty(), null, (Serializable)Float.valueOf(Float.intBitsToFloat(this.getInt())))} : NO_POINT_VALUES;
        return pointValues;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        this.setInt(Float.floatToIntBits(pointValue.getValue() instanceof Number ? ((Number)pointValue.getValue()).floatValue() : Float.NaN));
    }
}

