/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.message.MaskWriteRegister;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.WordRegister;

public class MaskedRegister
extends WordRegister {
    private final int _mask;

    public MaskedRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, int mask) {
        super(address, point, false);
        this._mask = mask;
    }

    @Override
    public WriteTransaction.Request createWriteRequest() {
        return new MaskWriteRegister.Request(this.getAddress().get(), ~this._mask, this.getContent());
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues = super.getPointValues();
        if (pointValues.length == 1) {
            PointValue pointValue = pointValues[0];
            Short value = (Short)pointValue.getValue();
            pointValue.setValue((Serializable)Short.valueOf((short)(value.intValue() & this._mask)));
        }
        return pointValues;
    }
}

