/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.pap.modbus.ModbusProxy;
import org.rvpf.pap.modbus.register.DoubleWordRegister;
import org.rvpf.pap.modbus.register.StampRegister;

public final class TimeRegister
extends DoubleWordRegister {
    private final StampRegister _stampRegister;

    public TimeRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<ModbusProxy> remoteProxy, boolean readOnly, boolean middleEndian) {
        super(address, Optional.empty(), readOnly, middleEndian);
        this._stampRegister = new StampRegister(Optional.of(address.get() + 2), remoteProxy, readOnly, middleEndian);
    }

    @Override
    public short getContent() {
        DateTime now = DateTime.now();
        DateTime.Fields nowFields = now.toFields();
        int year = nowFields.year % 100;
        int month = nowFields.month;
        int dayOfMonth = nowFields.day;
        int hourOfDay = nowFields.hour;
        this.setContent((short)((year << 8) + month));
        this.getNextRegister().setContent((short)((dayOfMonth << 8) + hourOfDay));
        this._stampRegister.setContent((short)(now.scaled(ElapsedTime.SECOND) % 3600.0));
        this._stampRegister.getNextRegister().setContent((short)(now.scaled(ElapsedTime.MILLI.toRaw() / 10L) % 10000.0));
        return super.getContent();
    }

    @Nonnull
    @CheckReturnValue
    public StampRegister getStampRegister() {
        return this._stampRegister;
    }
}

