/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.register;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.modbus.message.ReadHoldingRegisters;
import org.rvpf.pap.modbus.message.ReadInputRegisters;
import org.rvpf.pap.modbus.message.ReadTransaction;
import org.rvpf.pap.modbus.message.WriteSingleRegister;
import org.rvpf.pap.modbus.message.WriteTransaction;
import org.rvpf.pap.modbus.register.Register;

public class WordRegister
extends Register {
    private short _content;
    private final Point[] _points;

    public WordRegister(@Nonnull Optional<Integer> address, @Nonnull Optional<Point> point, boolean readOnly) {
        super(address, readOnly);
        Point[] pointArray;
        if (point.isPresent()) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = point.get();
        } else {
            pointArray = NO_POINTS;
        }
        this._points = pointArray;
    }

    @Override
    public ReadTransaction.Request createReadRequest() {
        int startingAddress = this.getAddress().get();
        return this.isReadOnly() ? new ReadInputRegisters.Request(startingAddress, this.size()) : new ReadHoldingRegisters.Request(startingAddress, this.size());
    }

    @Override
    public WriteTransaction.Request createWriteRequest() {
        return new WriteSingleRegister.Request(this.getAddress().get(), this.getContent());
    }

    @Override
    public short getContent() {
        return this._content;
    }

    @Override
    public PointValue[] getPointValues() {
        PointValue[] pointValues = this._points != NO_POINTS ? new PointValue[]{new PointValue(this.getPoints()[0], Optional.empty(), null, (Serializable)Short.valueOf(this.getContent()))} : NO_POINT_VALUES;
        return pointValues;
    }

    @Override
    public final Point[] getPoints() {
        return this._points;
    }

    @Override
    public void putPointValue(PointValue pointValue) {
        this.setContent(pointValue.getValue() instanceof Number ? ((Number)pointValue.getValue()).shortValue() : (short)0);
    }

    @Override
    public void setContent(short content) {
        this._content = content;
    }

    @Override
    public int size() {
        return 1;
    }
}

