/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.transport;

import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public enum ExceptionCode {
    ILLEGAL_FUNCTION(1),
    ILLEGAL_DATA_ADDRESS(2),
    ILLEGAL_DATA_VALUE(3),
    SLAVE_DEVICE_FAILURE(4),
    ACKNOWLEDGE(5),
    SLAVE_DEVICE_BUSY(6),
    NEGATIVE_ACKNOWLEDGE(7),
    MEMORY_PARITY_ERROR(8),
    GATEWAY_PATH_UNAVAILABLE(10),
    GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND(11),
    UNKNOWN_EXCEPTION_CODE(0);

    private final byte _codeByte;

    private ExceptionCode(int exceptionCodeByte) {
        this._codeByte = (byte)exceptionCodeByte;
    }

    @Nonnull
    @CheckReturnValue
    public static ExceptionCode getInstance(byte exceptionCodeByte) {
        for (ExceptionCode exceptionCode : ExceptionCode.values()) {
            if (exceptionCode.getCodeByte() != exceptionCodeByte) continue;
            return exceptionCode;
        }
        return UNKNOWN_EXCEPTION_CODE;
    }

    @CheckReturnValue
    public byte getCodeByte() {
        return this._codeByte;
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        String name = this.toString();
        if (this == UNKNOWN_EXCEPTION_CODE) {
            name = name + String.format((Locale)null, "(0x%02X)", this._codeByte & 0xFF);
        }
        return name;
    }
}

