/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.modbus.transport;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.pap.modbus.message.ErrorResponse;
import org.rvpf.pap.modbus.message.Transaction;
import org.rvpf.pap.modbus.transport.Connection;
import org.rvpf.pap.modbus.transport.Transport;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class Responder
implements ServiceThread.Target {
    private static final Logger _LOGGER = Logger.getInstance(Responder.class);
    private final Connection _connection;
    private final BlockingQueue<Transaction.Response> _responses = new LinkedBlockingQueue<Transaction.Response>();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    Responder(@Nonnull Connection connection) {
        this._connection = connection;
    }

    public void addResponse(@Nonnull Transaction.Response response) {
        this._responses.add(response);
    }

    public void run() {
        Transport transport = this._connection.getTransport();
        while (true) {
            Transaction.Response response;
            try {
                response = this._responses.take();
            }
            catch (InterruptedException exception) {
                break;
            }
            if (response instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)response;
                Transaction.Request request = errorResponse.getRequest();
                String requestCodeString = request != Transaction.Request.NULL ? request.getName() : String.format((Locale)null, "0x%02X" + Integer.valueOf(errorResponse.getErrorCode() & 0xFF), new Object[0]);
                _LOGGER.trace((Messages.Entry)ModbusMessages.SENDING_ERROR_RESPONSE, new Object[]{errorResponse.getExceptionCodeName(), requestCodeString});
            } else {
                _LOGGER.trace((Messages.Entry)ModbusMessages.SENDING_RESPONSE, new Object[]{response.getName()});
            }
            try {
                response.write(transport);
                transport.flush();
            }
            catch (IOException exception) {
                _LOGGER.debug((Messages.Entry)ModbusMessages.FAILED_SEND_RESPONSE, new Object[]{transport.getRemoteAddress(), exception});
                break;
            }
        }
        try {
            transport.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "Modbus server (responder to " + this._connection.getRemoteAddress() + ")");
        if (this._thread.compareAndSet(null, thread)) {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    public void stop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            _LOGGER.debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            this._connection.stop();
            Require.ignored((boolean)thread.interruptAndJoin(_LOGGER, 0L));
        }
    }
}

