/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.processor.engine.pap.modbus;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.Content;
import org.rvpf.base.Origin;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.PointRelation;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.content.BooleanContent;
import org.rvpf.content.TupleContent;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.modbus.ModbusMessages;
import org.rvpf.processor.engine.pap.PAPSplitter;

public final class ModbusSplitter
extends PAPSplitter {
    private final Map<Point, _Plan> _plans = new IdentityHashMap<Point, _Plan>();

    @Override
    public boolean setUp(Point point) {
        if (this._plans.containsKey(point)) {
            return true;
        }
        Optional origin = point.getOrigin();
        Content pointContent = point.getContent().orElse(null);
        boolean multipleValues = pointContent instanceof TupleContent;
        boolean isBits = multipleValues ? ((TupleContent)pointContent).getContent() instanceof BooleanContent : false;
        boolean middleEndian = false;
        if (origin.isPresent()) {
            Attributes attributes = ((Origin)origin.get()).getAttributes("MODBUS").orElse(null);
            if (attributes != null) {
                if (multipleValues && !isBits) {
                    boolean littleEndian = attributes.getBoolean("LITTLE_ENDIAN");
                    middleEndian = attributes.getBoolean("MIDDLE_ENDIAN");
                    if (littleEndian) {
                        middleEndian = !middleEndian;
                    }
                }
            } else {
                this.getThisLogger().debug((Messages.Entry)PAPMessages.MISSING_ATTRIBUTES, new Object[]{"MODBUS", origin});
            }
        } else {
            this.getThisLogger().debug((Messages.Entry)PAPMessages.MISSING_ORIGIN, new Object[]{point});
        }
        if (multipleValues && !isBits) {
            this.getThisLogger().debug((Messages.Entry)ModbusMessages.POINT_SPLITS_MIDDLE_ENDIAN, new Object[]{point, String.valueOf(middleEndian)});
        }
        List resultRelations = point.getResults();
        _Detail[] details = new _Detail[resultRelations.size()];
        int detail = 0;
        boolean success = true;
        for (PointRelation resultRelation : resultRelations) {
            Point resultPoint = resultRelation.getResultPoint();
            if (resultPoint.getInputs().size() > 1) {
                this.getThisLogger().warn((Messages.Entry)PAPMessages.POINT_EQ_1_INPUT, new Object[]{resultPoint});
                success = false;
                continue;
            }
            if (multipleValues) {
                boolean isSigned;
                int size;
                boolean isFloat;
                int bit;
                int offset = this.getResultPosition(resultRelation);
                if (offset < 0) {
                    success = false;
                    continue;
                }
                Params resultRelationParams = resultRelation.getParams();
                if (isBits) {
                    bit = -1;
                    isFloat = false;
                    size = 0;
                    isSigned = false;
                } else {
                    bit = resultRelationParams.getInt("Bit", -1);
                    isFloat = resultRelationParams.getBoolean("Float", false);
                    size = resultRelationParams.getInt("Size", isFloat ? 2 : 1);
                    isSigned = resultRelationParams.getBoolean("Signed", false);
                    if (1 > size || size > 4 || isFloat && size != 2 && size != 4) {
                        this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_PARAMETER_VALUE, new Object[]{"Size", String.valueOf(size)});
                        success = false;
                        continue;
                    }
                }
                details[detail++] = new _Detail(resultPoint, offset, size, bit, isSigned, isFloat);
                continue;
            }
            details[detail++] = new _Detail(resultPoint, 0, 0, 0, false, false);
        }
        if (details.length > 0) {
            this._plans.put(point, new _Plan(details, middleEndian, multipleValues));
        }
        return success;
    }

    @Override
    public Optional<PAPSplitter.Splitted> split(PointValue pointValue) {
        Tuple tuple;
        Serializable value = pointValue.getValue();
        if (value instanceof PAPSplitter.Splitted) {
            return Optional.of((PAPSplitter.Splitted)value);
        }
        if (value instanceof Tuple) {
            tuple = (Tuple)value;
        } else {
            tuple = new Tuple(1);
            tuple.add(value);
        }
        _Plan plan = this._plans.get(pointValue.getPoint().get());
        if (plan == null) {
            return Optional.empty();
        }
        PAPSplitter.Splitted splitted = new PAPSplitter.Splitted();
        for (_Detail detail : plan.getDetails()) {
            splitted.put(detail.getPoint(), ModbusSplitter._getValue(plan, tuple, detail));
        }
        return Optional.of(splitted);
    }

    private static Optional<Serializable> _getValue(_Plan plan, Tuple tuple, _Detail detail) {
        if (!plan.isMultipleValues()) {
            return Optional.ofNullable(tuple.get(0));
        }
        int size = detail.getSize();
        int offset = detail.getPosition();
        if (size == 0) {
            if (tuple.size() < offset + 1) {
                return Optional.empty();
            }
            return Optional.ofNullable(tuple.get(offset));
        }
        int bit = detail.getBit();
        if (bit >= size * 16) {
            offset += bit / (size * 16);
            bit %= 16;
        }
        if (tuple.size() < offset + size) {
            return Optional.empty();
        }
        long holder = 0L;
        for (int i = 0; i < size; ++i) {
            Serializable item = tuple.get(offset + (plan.isMiddleEndian() ? size - i - 1 : i));
            if (item instanceof Number) {
                holder <<= 16;
                holder |= (long)(((Number)item).shortValue() & 0xFFFF);
                continue;
            }
            return Optional.empty();
        }
        if (bit >= 0) {
            holder &= (long)(1 << bit);
        } else if (detail.isSigned()) {
            int shift = (4 - size) * 16;
            holder <<= shift;
            holder >>= shift;
        }
        Serializable value = bit >= 0 ? (Serializable)Boolean.valueOf(holder != 0L) : (Serializable)(detail.isFloat() ? (Number)(size == 2 ? (Number)Float.valueOf(Float.intBitsToFloat((int)holder)) : (Number)Double.longBitsToDouble(holder)) : (Number)holder);
        return Optional.ofNullable(value);
    }

    private static final class _Plan
    extends PAPSplitter.Plan {
        private final boolean _middleEndian;
        private final boolean _multipleValues;

        _Plan(@Nonnull _Detail[] details, boolean middleEndian, boolean multipleValues) {
            super(details);
            this._middleEndian = middleEndian;
            this._multipleValues = multipleValues;
        }

        protected _Detail[] getDetails() {
            return (_Detail[])super.getDetails();
        }

        @CheckReturnValue
        boolean isMiddleEndian() {
            return this._middleEndian;
        }

        @CheckReturnValue
        boolean isMultipleValues() {
            return this._multipleValues;
        }
    }

    private static final class _Detail
    extends PAPSplitter.Detail {
        private final boolean _float;
        private final boolean _signed;
        private final int _size;

        _Detail(@Nonnull Point point, int position, int size, int bit, boolean signed, boolean isFloat) {
            super(point, position, bit);
            this._size = size;
            this._signed = bit < 0 && !isFloat ? signed : false;
            this._float = isFloat;
        }

        @CheckReturnValue
        int getSize() {
            return this._size;
        }

        @CheckReturnValue
        boolean isFloat() {
            return this._float;
        }

        @CheckReturnValue
        boolean isSigned() {
            return this._signed;
        }
    }
}

