/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.IdentityHashSet;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.pap.ListenerManager;
import org.rvpf.pap.PAPClient;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3MasterContext;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.DNP3Proxy;
import org.rvpf.pap.dnp3.DNP3StationPoint;
import org.rvpf.pap.dnp3.object.ObjectEventListener;
import org.rvpf.pap.dnp3.object.ObjectHeader;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.InternalIndication;
import org.rvpf.pap.dnp3.object.groupCategory.classes.ClassObjectsVariation;
import org.rvpf.pap.dnp3.object.groupCategory.devices.InternalIndicationsVariation;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimeDateVariation;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.FunctionCode;
import org.rvpf.pap.dnp3.transport.MasterOutstationAssociation;
import org.rvpf.pap.dnp3.transport.ReadTransaction;
import org.rvpf.pap.dnp3.transport.ReceivedFragmentListener;
import org.rvpf.pap.dnp3.transport.RemoteEndPoint;
import org.rvpf.pap.dnp3.transport.WriteTransaction;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class DNP3Master
extends PAPClient.Abstract
implements ReceivedFragmentListener {
    private final ConnectionManager _connectionManager;
    private final Set<MasterOutstationAssociation> _inputAssociations = new IdentityHashSet();
    private final short _localDeviceAddress;
    private final ObjectEventListener.Manager _objectEventListenerManager = new ObjectEventListener.Manager();
    private final Set<MasterOutstationAssociation> _outputAssociations = new IdentityHashSet();
    private final AtomicReference<ServiceThread> _requestsSenderThread = new AtomicReference<ServiceThread>(new ServiceThread("DNP3 Master requests sender"));
    private final BlockingQueue<Fragment> _responses = new LinkedBlockingQueue<Fragment>();
    private final AtomicBoolean _sendingTime = new AtomicBoolean();
    private final UnsolicitedItemListener.Manager _unsolicitedItemListenerManager = new UnsolicitedItemListener.Manager();

    public DNP3Master(@Nonnull DNP3MasterContext masterContext, short localDeviceAddress) {
        super(masterContext);
        this._localDeviceAddress = localDeviceAddress;
        this._connectionManager = new ConnectionManager(masterContext);
    }

    @CheckReturnValue
    public boolean addObjectEventListener(@Nonnull ObjectEventListener objectEventListener) {
        return this._objectEventListenerManager.addListener(objectEventListener);
    }

    @CheckReturnValue
    public boolean addReceivedResponseListener(@Nonnull ReceivedFragmentListener receivedResponseListener) {
        return this._connectionManager.addReceivedFragmentListener(receivedResponseListener);
    }

    @CheckReturnValue
    public boolean addUnsolicitedItemListener(@Nonnull UnsolicitedItemListener unsolicitedItemListener) {
        return this._unsolicitedItemListenerManager.addListener(unsolicitedItemListener);
    }

    @Override
    public void close() {
        ServiceThread thread = this._requestsSenderThread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            Require.ignored((boolean)thread.interruptAndJoin(this.getThisLogger(), 0L));
            this.disconnect();
            try {
                this._connectionManager.stopListening();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this._objectEventListenerManager.clear();
            this._unsolicitedItemListenerManager.clear();
        }
    }

    @Nonnull
    @CheckReturnValue
    public Collection<WriteTransaction.Response> commitPointUpdateRequests() throws ServiceNotAvailableException {
        LinkedList<WriteTransaction.Response> responses = new LinkedList<WriteTransaction.Response>();
        for (MasterOutstationAssociation association : this._outputAssociations) {
            try {
                for (WriteTransaction.Response response : association.commitWriteRequests()) {
                    responses.add(response);
                }
            }
            catch (ServiceNotAvailableException exception) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.WRITE_COMMIT_FAILED, new Object[]{association.getRemoteEndPoint().getRemoteProxyName().orElse(null)});
                throw exception;
            }
        }
        this._outputAssociations.clear();
        return responses;
    }

    @Nonnull
    @CheckReturnValue
    public Collection<ReadTransaction.Response> commitPointValueRequests() throws ServiceNotAvailableException {
        LinkedList<ReadTransaction.Response> responses = new LinkedList<ReadTransaction.Response>();
        for (MasterOutstationAssociation association : this._inputAssociations) {
            try {
                for (ReadTransaction.Response response : association.commitReadRequests()) {
                    responses.add(response);
                }
            }
            catch (ServiceNotAvailableException exception) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.READ_COMMIT_FAILED, new Object[]{association.getRemoteEndPoint().getRemoteProxyName().orElse(null)});
                throw exception;
            }
        }
        this._inputAssociations.clear();
        return responses;
    }

    @Override
    public boolean connect(Origin origin) throws InterruptedException {
        return this.connect(origin, (short)0);
    }

    @CheckReturnValue
    public boolean connect(@Nonnull Origin outstationOrigin, short remoteAddress) throws InterruptedException {
        Fragment response;
        Optional<? extends PAPProxy> outstationProxy = this._getOutstationProxy(outstationOrigin);
        if (!outstationProxy.isPresent()) {
            return false;
        }
        Association association = this._connectionManager.connect((DNP3Proxy)outstationProxy.get(), this._localDeviceAddress, remoteAddress);
        if (association == null) {
            return false;
        }
        Fragment request = DNP3Master._newRequest(association, FunctionCode.DISABLE_UNSOLICITED);
        Require.ignored((boolean)request.add(new Fragment.Item(ObjectHeader.newInstance(ClassObjectsVariation.CLASS_1_DATA, ObjectRange.NONE))));
        Require.ignored((boolean)request.add(new Fragment.Item(ObjectHeader.newInstance(ClassObjectsVariation.CLASS_2_DATA, ObjectRange.NONE))));
        Require.ignored((boolean)request.add(new Fragment.Item(ObjectHeader.newInstance(ClassObjectsVariation.CLASS_3_DATA, ObjectRange.NONE))));
        this._executeRequest(request);
        try {
            response = this._receiveNullResponse(request);
        }
        catch (DNP3ProtocolException exception) {
            this.getThisLogger().trace((Throwable)exception, (Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
            return false;
        }
        ((MasterOutstationAssociation)response.getAssociation()).setUnsolicitedSupported(!response.getInternalIndications().hasNoFuncCodeSupport());
        return true;
    }

    @Override
    public void disconnect(Origin origin) {
        Optional<PAPProxy> outstationProxy = this.forgetServerProxy(origin);
        if (outstationProxy.isPresent()) {
            this._connectionManager.disconnect((DNP3Proxy)outstationProxy.get());
        }
    }

    @Override
    public PointValue[] fetchPointValues(Point[] points) throws InterruptedException, ServiceNotAvailableException {
        PointValue[] pointValues = new PointValue[points.length];
        try {
            for (int i = 0; i < pointValues.length; ++i) {
                pointValues[i] = this.read(points[i]);
            }
        }
        catch (IOException exception) {
            throw new ServiceNotAvailableException((Exception)exception);
        }
        return pointValues;
    }

    @CheckReturnValue
    public short getLocalDeviceAddress() {
        return this._localDeviceAddress;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<RemoteEndPoint> getRemoteEndPoint(@Nonnull DNP3Proxy proxy) {
        return this._connectionManager.getRemoteEndPoint(proxy);
    }

    @Nonnull
    @CheckReturnValue
    public DNP3StationPoint getStationPoint(@Nonnull Point point) {
        return ((DNP3MasterContext)this.getContext()).getRemoteStationPoint(point);
    }

    @Override
    public boolean onReceivedFragment(Fragment response) throws IOException {
        if (response.isUnsolicited()) {
            if (response.isConfirmRequested()) {
                this._executeTarget(() -> DNP3Master._sendConfirmUnsolicited(response));
            }
            response.getItems().forEach(item -> this._unsolicitedItemListenerManager.onUnsolicitedItem((Fragment.Item)item));
        } else {
            if (response.getInternalIndications().hasDeviceRestart()) {
                this._executeTarget(() -> this._sendClearDeviceRestart(response.getAssociation()));
            }
            if (response.getInternalIndications().hasNeedTime() && this._sendingTime.compareAndSet(false, true)) {
                this._executeTarget(() -> this._sendTime(response.getAssociation()));
            }
            this._responses.add(response);
        }
        return true;
    }

    @Override
    public void open() {
        Thread thread = (Thread)this._requestsSenderThread.get();
        if (thread != null) {
            Require.ignored((boolean)this.addReceivedResponseListener(this));
            try {
                this._connectionManager.startListening(this);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            thread.start();
        }
    }

    @Nonnull
    @CheckReturnValue
    public PointValue read(@Nonnull Point point) throws IOException, InterruptedException {
        Serializable responseValue;
        DNP3StationPoint stationPoint = this.getStationPoint(point);
        Fragment request = DNP3Master._newRequest((Association)this._getAssociation(stationPoint), FunctionCode.READ, stationPoint.getInputVariation(), stationPoint.getObjectRange());
        this._executeRequest(request);
        Fragment response = this._responses.take();
        LinkedList<Fragment.Item> responseItems = response.getItems();
        if (!responseItems.isEmpty()) {
            Fragment.Item responseItem = (Fragment.Item)responseItems.getFirst();
            ObjectInstance[] objectinstances = responseItem.getObjectInstances().orElse(new ObjectInstance[0]);
            if (objectinstances.length == 1) {
                ObjectInstance objectInstance = objectinstances[0];
                responseValue = ((ObjectInstance.WithValue)objectInstance).getValue();
            } else if (objectinstances.length > 0) {
                Tuple tuple = new Tuple(objectinstances.length);
                for (ObjectInstance objectInstance : objectinstances) {
                    tuple.add(((ObjectInstance.WithValue)objectInstance).getValue());
                }
                responseValue = tuple;
            } else {
                responseValue = null;
            }
        } else {
            responseValue = null;
        }
        PointValue pointValue = new PointValue(point, Optional.of(DateTime.now()), null, responseValue);
        this.getThisLogger().trace((Messages.Entry)DNP3Messages.RECEIVED_POINT_VALUE, new Object[]{pointValue});
        return pointValue;
    }

    @CheckReturnValue
    public boolean removeObjectEventListener(@Nonnull ObjectEventListener objectEventListener) {
        return this._objectEventListenerManager.removeListener(objectEventListener);
    }

    @CheckReturnValue
    public boolean removeUnsolicitedItemListener(@Nonnull UnsolicitedItemListener unsolicitedItemListener) {
        return this._unsolicitedItemListenerManager.removeListener(unsolicitedItemListener);
    }

    @Nonnull
    @CheckReturnValue
    public WriteTransaction.Request requestPointUpdate(@Nonnull PointValue pointValue) throws ConnectException, InterruptedException {
        Point point = (Point)pointValue.getPoint().get();
        MasterOutstationAssociation association = this._getAssociation(this.getStationPoint(point));
        this._outputAssociations.add(association);
        return association.addWriteRequest(pointValue);
    }

    @Nonnull
    @CheckReturnValue
    public ReadTransaction.Request requestPointValue(@Nonnull Point point) throws ConnectException, InterruptedException {
        MasterOutstationAssociation association = this._getAssociation(this.getStationPoint(point));
        this._inputAssociations.add(association);
        return association.addReadRequest(point);
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull KeyedValues listenProperties) {
        return this._connectionManager.setUp(listenProperties);
    }

    public void tearDown() {
        this.close();
        this._connectionManager.tearDown();
    }

    @Override
    public Exception[] updatePointValues(PointValue[] pointValues) throws ServiceNotAvailableException, InterruptedException {
        Exception[] exceptions = new Exception[pointValues.length];
        for (int i = 0; i < exceptions.length; ++i) {
            try {
                this.write(pointValues[i]);
                continue;
            }
            catch (IOException exception) {
                exceptions[i] = exception;
            }
        }
        return exceptions;
    }

    public void write(@Nonnull PointValue pointValue) throws IOException, InterruptedException {
        Optional point = pointValue.getPoint();
        if (!point.isPresent()) {
            throw new IllegalArgumentException("Point entity reference missing: " + pointValue);
        }
        DNP3StationPoint stationPoint = this.getStationPoint((Point)point.get());
        PointType.Support pointSupport = stationPoint.getSupport();
        if (pointSupport.isReadOnly()) {
            throw new IllegalArgumentException("Point cannot be written: " + point.get());
        }
        Optional<ObjectVariation> objectVariation = stationPoint.getOutputVariation(stationPoint.getDataType());
        ObjectRange objectRange = stationPoint.getObjectRange();
        Serializable value = pointValue.getValue();
        if (value == null) {
            throw new IllegalArgumentException("Null in point value: " + pointValue);
        }
        ObjectInstance.WithValue valueObject = (ObjectInstance.WithValue)objectVariation.get().newObjectInstance();
        valueObject.setValue(value);
        Fragment request = DNP3Master._newRequest((Association)this._getAssociation(stationPoint), FunctionCode.DIRECT_OPERATE, valueObject, objectRange);
        this._executeRequest(request);
        this._receiveNullResponse(request);
        this.getThisLogger().trace((Messages.Entry)DNP3Messages.SENT_POINT_VALUE, new Object[]{pointValue});
    }

    private static Fragment _newRequest(Association association, FunctionCode functionCode) {
        Fragment request = new Fragment(association, Fragment.Header.newInstance(Optional.of(functionCode), true));
        return request;
    }

    private static Fragment _newRequest(Association association, FunctionCode functionCode, ObjectInstance objectInstance, ObjectRange objectRange) {
        ObjectVariation objectVariation = objectInstance.getObjectVariation();
        Fragment request = DNP3Master._newRequest(association, functionCode);
        ObjectHeader objectHeader = ObjectHeader.newInstance(objectVariation, objectRange);
        Require.ignored((boolean)request.add(new Fragment.Item(objectHeader, Optional.of(new ObjectInstance[]{objectInstance}))));
        return request;
    }

    private static Fragment _newRequest(Association association, FunctionCode functionCode, ObjectVariation objectVariation, ObjectRange objectRange) {
        Fragment request = new Fragment(association, Fragment.Header.newInstance(Optional.of(functionCode), true));
        Require.ignored((boolean)request.add(new Fragment.Item(ObjectHeader.newInstance(objectVariation, objectRange))));
        return request;
    }

    private static void _sendConfirmUnsolicited(Fragment response) throws IOException {
        Fragment request = DNP3Master._newRequest(response.getAssociation(), FunctionCode.CONFIRM);
        request.setUnsolicited();
        request.setSequence(response.getSequence());
        request.send();
    }

    private static void _sendRequest(Fragment request, CountDownLatch latch) throws IOException {
        request.setSequence(request.getAssociation().getApplicationLayer().nextSolicitedSequence());
        request.send();
        latch.countDown();
    }

    private void _executeRequest(Fragment request) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this._executeTarget(() -> DNP3Master._sendRequest(request, latch));
        latch.await();
    }

    private void _executeTarget(ServiceThread.Target target) {
        this._requestsSenderThread.get().execute(target);
    }

    private MasterOutstationAssociation _getAssociation(DNP3StationPoint stationPoint) throws ConnectException, InterruptedException {
        DNP3Proxy proxy = (DNP3Proxy)this.getPointProxy(stationPoint.getPoint()).get();
        short remoteAddress = stationPoint.getLogicalDevice().getAddress();
        Optional<RemoteEndPoint> remoteEndPoint = this.getRemoteEndPoint(proxy);
        if (!remoteEndPoint.isPresent()) {
            if (!this.connect(proxy.getOrigin(), remoteAddress)) {
                throw new ConnectException();
            }
            remoteEndPoint = this.getRemoteEndPoint(proxy);
        }
        return (MasterOutstationAssociation)remoteEndPoint.get().getAssociation(this._localDeviceAddress, remoteAddress);
    }

    private Optional<? extends PAPProxy> _getOutstationProxy(Origin origin) {
        Optional<? extends PAPProxy> outstationProxy = this.getContext().getRemoteProxyByOrigin(origin);
        if (!outstationProxy.isPresent()) {
            Logger.getInstance(this.getClass()).warn((Messages.Entry)PAPMessages.UNKNOWN_ORIGIN, new Object[]{origin});
        }
        return outstationProxy;
    }

    private Fragment _receiveNullResponse(Fragment request) throws DNP3ProtocolException, InterruptedException {
        Fragment response = this._responses.take();
        if (!response.getItems().isEmpty()) {
            throw new DNP3ProtocolException(DNP3Messages.UNEXPECTED_RESPONSE_ITEMS, new Object[0]);
        }
        return response;
    }

    private void _sendClearDeviceRestart(Association association) throws IOException, InterruptedException {
        ObjectInstance.Packed objectInstance = (ObjectInstance.Packed)InternalIndicationsVariation.PACKED_FORMAT.newObjectInstance();
        Fragment request = DNP3Master._newRequest(association, FunctionCode.WRITE, objectInstance, ObjectRange.newIndexInstance(InternalIndication.DEVICE_RESTART.getCode()));
        objectInstance.put(0, 0);
        request.setSequence(association.getApplicationLayer().nextSolicitedSequence());
        request.send();
        this._receiveNullResponse(request);
    }

    private void _sendTime(Association association) throws IOException, InterruptedException {
        Fragment request = DNP3Master._newRequest(association, FunctionCode.RECORD_CURRENT_TIME);
        request.setSequence(association.getApplicationLayer().nextSolicitedSequence());
        request.send();
        DateTime recordedTime = DateTime.now();
        this._receiveNullResponse(request);
        ObjectInstance timeObject = TimeDateVariation.ABSOLUTE_TIME_LAST_RECORDED.newObjectInstance();
        request = DNP3Master._newRequest(association, FunctionCode.WRITE, timeObject, ObjectRange.newCountInstance(1));
        request.setSequence(association.getApplicationLayer().nextSolicitedSequence());
        ((ObjectInstance.WithTime)timeObject).setTime(recordedTime);
        request.send();
        this._receiveNullResponse(request);
        this._sendingTime.set(false);
    }

    public static interface UnsolicitedItemListener {
        @CheckReturnValue
        public boolean onUnsolicitedItem(@Nonnull Fragment.Item var1);

        public static class Manager
        extends ListenerManager<UnsolicitedItemListener>
        implements UnsolicitedItemListener {
            @Override
            public boolean onUnsolicitedItem(Fragment.Item responseItem) {
                for (UnsolicitedItemListener listener : this.getListeners()) {
                    if (!listener.onUnsolicitedItem(responseItem)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

