/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Origin;
import org.rvpf.base.Point;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3Outstation;
import org.rvpf.pap.dnp3.DNP3Proxy;
import org.rvpf.pap.dnp3.DNP3StationPoint;
import org.rvpf.pap.dnp3.object.ObjectHeader;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.InternalIndication;
import org.rvpf.pap.dnp3.object.groupCategory.devices.InternalIndicationsVariation;
import org.rvpf.pap.dnp3.transport.ApplicationMessage;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.FunctionCode;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class DNP3MasterProxy
extends DNP3Proxy
implements ServiceThread.Target {
    private DNP3Outstation _outstation;
    private Consumer<ApplicationMessage> _responder;
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    public DNP3MasterProxy(@Nonnull DNP3Context context, @Nonnull Origin origin) {
        super(context, origin);
    }

    public DNP3MasterProxy(@Nonnull DNP3Context context, @Nonnull String name) {
        super(context, name);
    }

    private DNP3MasterProxy(@Nonnull DNP3MasterProxy other) {
        super(other);
    }

    @Override
    public PAPProxy copy() {
        return new DNP3MasterProxy(this);
    }

    @Override
    public boolean isMaster() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws Exception {
        this.getThisLogger().debug((Messages.Entry)PAPMessages.STARTED_SERVICES, new Object[]{this.getOrigin().getName().get()});
        try {
            block10: while (true) {
                Fragment request = this._outstation.nextRequest();
                switch (request.getFunctionCode()) {
                    case READ: {
                        this._read(request);
                        continue block10;
                    }
                    case WRITE: {
                        this._write(request);
                        continue block10;
                    }
                    case DIRECT_OPERATE: {
                        this._directOperate(request);
                        continue block10;
                    }
                    case CONFIRM: {
                        DNP3MasterProxy._confirm(request);
                        continue block10;
                    }
                    case DISABLE_UNSOLICITED: {
                        this._sendNullResponse(request);
                        continue block10;
                    }
                    case RECORD_CURRENT_TIME: {
                        this._outstation.recordTime();
                        this._sendNullResponse(request);
                        continue block10;
                    }
                }
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.UNSUPPORTED_REQUEST, new Object[]{request.getFunctionCode()});
            }
        }
        catch (InterruptedException exception) {
            this.getThisLogger().debug((Messages.Entry)PAPMessages.STOPPED_SERVICES, new Object[]{this.getOrigin().getName().get()});
            return;
        }
    }

    public void start(@Nonnull DNP3Outstation outstation, @Nonnull Consumer<ApplicationMessage> responseSender) {
        ServiceThread thread = new ServiceThread((ServiceThread.Target)this, "DNP3 outstation (proxy " + this.getOrigin() + ")");
        if (this._thread.compareAndSet(null, thread)) {
            this._responder = responseSender;
            this._outstation = outstation;
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            thread.start();
        }
    }

    public void stop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            Require.ignored((boolean)thread.interruptAndJoin(this.getThisLogger(), 0L));
            this._outstation = null;
            this._responder = null;
        }
    }

    private static void _confirm(@Nonnull Fragment request) {
        request.getAssociation().onConfirm();
    }

    private void _directOperate(@Nonnull Fragment receivedRequest) {
        this._write(receivedRequest);
    }

    private void _read(@Nonnull Fragment request) {
        ApplicationMessage response = new ApplicationMessage(request.getAssociation(), Optional.of(FunctionCode.RESPONSE), false);
        response.setSequence(request.getSequence());
        for (Fragment.Item item : request.getItems()) {
            Serializable value;
            ObjectVariation objectVariation;
            Optional<ObjectVariation> optionalObjectVariation;
            Optional<PointValue> pointValue;
            Fragment.Item.Indexes indexes;
            Optional<PointType> pointType = item.getPointType();
            if (!pointType.isPresent() || !(indexes = item.getIndexes()).isStartStop()) continue;
            ObjectRange objectRange = ObjectRange.newIndexInstance(indexes.getStart(), indexes.getStop());
            Optional<Point> point = this._outstation.getPoint(pointType.get(), objectRange);
            if (!point.isPresent() || !(pointValue = this._outstation.getPointValue(point.get())).isPresent()) continue;
            ObjectVariation requestObjectVariation = item.getObjectVariation();
            if (requestObjectVariation.isAny()) {
                DNP3StationPoint stationPoint = this._outstation.getStationPoint(point.get());
                optionalObjectVariation = stationPoint.getInputVariation(stationPoint.getDataType());
            } else {
                optionalObjectVariation = Optional.of(requestObjectVariation);
            }
            if (!optionalObjectVariation.isPresent() || !ObjectInstance.WithValue.class.isAssignableFrom((objectVariation = optionalObjectVariation.get()).getObjectClass()) || (value = pointValue.get().getValue()) == null) continue;
            ObjectInstance[] objectInstances = new ObjectInstance[indexes.getLength()];
            if (value instanceof Tuple) {
                Tuple tuple = (Tuple)value;
                if (tuple.size() != objectInstances.length) continue;
                for (int i = 0; i < objectInstances.length; ++i) {
                    ObjectInstance.WithValue objectInstanceWithValue = (ObjectInstance.WithValue)objectVariation.newObjectInstance();
                    int index = indexes.next();
                    objectInstanceWithValue.setUp(index, index);
                    objectInstanceWithValue.setValue(tuple.get(i));
                    objectInstances[i] = objectInstanceWithValue;
                }
            } else {
                if (objectInstances.length != 1) continue;
                ObjectInstance.WithValue objectInstanceWithValue = (ObjectInstance.WithValue)objectVariation.newObjectInstance();
                int index = indexes.getStart();
                objectInstanceWithValue.setUp(index, index);
                objectInstanceWithValue.setValue(value);
                objectInstances[0] = objectInstanceWithValue;
            }
            ObjectHeader objectHeader = ObjectHeader.newInstance(objectVariation, objectRange);
            response.add(new Fragment.Item(objectHeader, Optional.of(objectInstances)));
            this.getThisLogger().trace((Messages.Entry)DNP3Messages.SENT_POINT_VALUE, new Object[]{pointValue.get()});
        }
        this._responder.accept(response);
    }

    private void _sendNullResponse(@Nonnull Fragment request) {
        ApplicationMessage response = new ApplicationMessage(request.getAssociation(), Optional.of(FunctionCode.RESPONSE), false);
        response.setSequence(request.getSequence());
        this._responder.accept(response);
    }

    private void _write(@Nonnull Fragment request) {
        for (Fragment.Item item : request.getItems()) {
            Serializable value;
            ObjectInstance[] objectInstances;
            Fragment.Item.Indexes indexes;
            Class<? extends ObjectInstance> objectVariationClass = item.getObjectVariation().getObjectClass();
            if (item.getObjectVariation() == InternalIndicationsVariation.PACKED_FORMAT) {
                ObjectInstance.Packed iinObject = (ObjectInstance.Packed)item.getObjectInstances().get()[0];
                indexes = item.getIndexes();
                for (int i = 0; i < indexes.getLength(); ++i) {
                    int index = indexes.next();
                    boolean set = (iinObject.get(i) & 1 << i) != 0;
                    this._outstation.setInternalIndication(InternalIndication.instance(index), set);
                }
                continue;
            }
            if (!ObjectInstance.WithValue.class.isAssignableFrom(objectVariationClass)) {
                ObjectInstance[] objectInstances2;
                if (!ObjectInstance.WithTime.class.isAssignableFrom(objectVariationClass) || (objectInstances2 = item.getObjectInstances().get()).length != 1) continue;
                this._outstation.setTime(((ObjectInstance.WithTime)objectInstances2[0]).getTime());
                continue;
            }
            Optional<PointType> pointType = item.getPointType();
            if (!pointType.isPresent() || !(indexes = item.getIndexes()).isStartStop()) continue;
            ObjectRange objectRange = ObjectRange.newIndexInstance(indexes.getStart(), indexes.getStop());
            Optional<Point> point = this._outstation.getPoint(pointType.get(), objectRange);
            if (!point.isPresent() || (objectInstances = item.getObjectInstances().get()).length != indexes.getLength()) continue;
            if (objectRange.isMultiple()) {
                Tuple tuple = new Tuple(objectInstances.length);
                for (int i = 0; i < objectInstances.length; ++i) {
                    tuple.add(((ObjectInstance.WithValue)objectInstances[i]).getValue());
                }
                value = tuple;
            } else {
                value = ((ObjectInstance.WithValue)objectInstances[0]).getValue();
            }
            PointValue pointValue = new PointValue(point.get(), Optional.of(DateTime.now()), null, value);
            this.getThisLogger().trace((Messages.Entry)DNP3Messages.RECEIVED_POINT_VALUE, new Object[]{pointValue});
            this._outstation.putPointValue(pointValue);
        }
        this._sendNullResponse(request);
    }
}

