/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.value.PointValue;
import org.rvpf.pap.PAPConnectionListener;
import org.rvpf.pap.PAPContext;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.PAPServer;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3MasterProxy;
import org.rvpf.pap.dnp3.DNP3OutstationContext;
import org.rvpf.pap.dnp3.DNP3StationPoint;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.InternalIndication;
import org.rvpf.pap.dnp3.transport.ApplicationMessage;
import org.rvpf.pap.dnp3.transport.Association;
import org.rvpf.pap.dnp3.transport.AssociationListener;
import org.rvpf.pap.dnp3.transport.ConnectionManager;
import org.rvpf.pap.dnp3.transport.Fragment;
import org.rvpf.pap.dnp3.transport.FunctionCode;
import org.rvpf.pap.dnp3.transport.InternalIndications;
import org.rvpf.pap.dnp3.transport.LogicalDevice;
import org.rvpf.pap.dnp3.transport.ReceivedFragmentListener;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class DNP3Outstation
extends PAPServer.Abstract
implements PAPConnectionListener,
AssociationListener,
ReceivedFragmentListener {
    private final ConnectionManager _connectionManager;
    private final DNP3OutstationContext _context;
    private InternalIndications _internalIndications = new InternalIndications(InternalIndication.DEVICE_RESTART);
    private final Object _mutex = new Object();
    private final Map<UUID, PointValue> _pointValues = new ConcurrentHashMap<UUID, PointValue>();
    private final BlockingQueue<Fragment> _requests = new LinkedBlockingQueue<Fragment>();
    private volatile boolean _respond;
    private final BlockingQueue<ApplicationMessage> _responses = new LinkedBlockingQueue<ApplicationMessage>();
    private final AtomicReference<ServiceThread> _responsesSenderThread = new AtomicReference();
    private final BlockingQueue<PointValue> _updates = new LinkedBlockingQueue<PointValue>();
    private boolean _updating;

    DNP3Outstation(@Nonnull DNP3OutstationContext outstationContext) {
        this._context = outstationContext;
        this._connectionManager = new ConnectionManager(outstationContext);
        this._responsesSenderThread.set(new ServiceThread(this::_sendResponses, "DNP3 Outstation responses sender"));
    }

    @CheckReturnValue
    public boolean addAssociationListener(@Nonnull AssociationListener associationListener) {
        return this._connectionManager.addAssociationListener(associationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPointValue(@Nonnull PointValue pointValue) {
        Object object = this._mutex;
        synchronized (object) {
            this._updating = true;
            this._updates.add(pointValue);
        }
    }

    @CheckReturnValue
    public boolean addReceivedRequestListener(@Nonnull ReceivedFragmentListener receivedRequestListener) {
        return this._connectionManager.addReceivedFragmentListener(receivedRequestListener);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Point> getPoint(@Nonnull PointType pointType, @Nonnull ObjectRange objectRange) {
        return ((DNP3Context)this.getContext()).getPoint(pointType, objectRange);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PointValue> getPointValue(@Nonnull Point point) {
        Optional<PAPProxy.Responder> responder;
        PointValue pointValue = this._pointValues.get(point.getUUID().get());
        if (pointValue == null && (responder = this.getResponder()).isPresent()) {
            PointValue[] pointValues;
            try {
                pointValues = responder.get().select(new Point[]{point});
            }
            catch (InterruptedException | ServiceNotAvailableException exception) {
                throw new RuntimeException(exception);
            }
            if (pointValues.length > 0) {
                pointValue = pointValues[0];
            }
        }
        return Optional.ofNullable(pointValue);
    }

    @Nonnull
    @CheckReturnValue
    public DNP3StationPoint getStationPoint(@Nonnull Point point) {
        return ((DNP3Context)this.getContext()).getRemoteStationPoint(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdating() {
        Object object = this._mutex;
        synchronized (object) {
            return this._updating;
        }
    }

    @Nonnull
    @CheckReturnValue
    public Fragment nextRequest() throws InterruptedException {
        return this._requests.take();
    }

    @Override
    public Optional<PointValue> nextUpdate(long timeout) throws InterruptedException {
        return timeout < 0L ? Optional.of(this._updates.take()) : Optional.ofNullable(this._updates.poll(timeout, TimeUnit.MILLISECONDS));
    }

    @Override
    public boolean onLostConnection(PAPProxy remoteProxy, Optional<Exception> cause) {
        ((DNP3MasterProxy)remoteProxy).stop();
        return true;
    }

    @Override
    public boolean onNewAssociation(Association association) throws IOException {
        if (this._internalIndications.hasDeviceRestart()) {
            ApplicationMessage nullUnsolicitedResponse = new ApplicationMessage(association, Optional.of(FunctionCode.UNSOLICITED_RESPONSE), false);
            nullUnsolicitedResponse.setUnsolicited();
            nullUnsolicitedResponse.setSequence(association.getApplicationLayer().nextUnsolicitedSequence());
            nullUnsolicitedResponse.setConfirmRequested();
            this._responses.add(nullUnsolicitedResponse);
        }
        return false;
    }

    @Override
    public boolean onNewConnection(PAPProxy remoteProxy) {
        if (this._respond) {
            ((DNP3MasterProxy)remoteProxy).start(this, response -> this._responses.add((ApplicationMessage)response));
        }
        return false;
    }

    @Override
    public boolean onReceivedFragment(Fragment request) throws IOException {
        this._requests.add(request);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdatesCommit() {
        Object object = this._mutex;
        synchronized (object) {
            if (this._updates.isEmpty()) {
                this._updating = false;
                this._mutex.notifyAll();
            }
        }
    }

    public void putPointValue(@Nonnull PointValue pointValue) {
        Optional point = pointValue.getPoint();
        if (point.isPresent()) {
            this._pointValues.put(pointValue.getPointUUID(), pointValue);
            this.addPointValue(pointValue);
        }
    }

    public void recordTime() {
    }

    @CheckReturnValue
    public boolean removeAssociationListener(@Nonnull AssociationListener associationListener) {
        return this._connectionManager.removeAssociationListener(associationListener);
    }

    public void setInternalIndication(@Nonnull InternalIndication internalIndication, boolean set) {
        this._internalIndications.set(internalIndication, set);
    }

    public void setNeedTime() {
        this._internalIndications.setNeedTime(true);
    }

    public void setTime(@Nonnull DateTime dateTime) {
        this._internalIndications.setNeedTime(false);
    }

    @Override
    public boolean setUpListener(@Nonnull KeyedGroups listenerProperties) {
        DNP3Context context = (DNP3Context)this.getContext();
        LogicalDevice[] logicalDevices = context.logicalDevices(listenerProperties.getStrings("logical.device"), "");
        if (logicalDevices == null) {
            return false;
        }
        HashMap<Short, LogicalDevice> logicalDeviceByAddress = new HashMap<Short, LogicalDevice>(KeyedValues.hashCapacity((int)logicalDevices.length), 0.75f);
        for (LogicalDevice logicalDevice : logicalDevices) {
            logicalDeviceByAddress.put(logicalDevice.getAddress(), logicalDevice);
        }
        if (logicalDeviceByAddress.isEmpty()) {
            Short address = 0;
            logicalDeviceByAddress.put(address, new LogicalDevice("", address));
        }
        this._connectionManager.registerLogicalDevices(logicalDeviceByAddress);
        return this._connectionManager.setUp((KeyedValues)listenerProperties);
    }

    @Override
    public void start() {
        this._respond = true;
        Thread thread = (Thread)this._responsesSenderThread.get();
        if (thread != null) {
            Require.ignored((boolean)this.addAssociationListener(this));
            Require.ignored((boolean)this.addReceivedRequestListener(this));
            try {
                this._connectionManager.startListening(this);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            thread.start();
        }
    }

    @Override
    public void stop() {
        ServiceThread thread = this._responsesSenderThread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            Require.ignored((boolean)thread.interruptAndJoin(this.getThisLogger(), 0L));
            try {
                this._connectionManager.stopListening();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public void tearDown() {
        this.stop();
        this._connectionManager.tearDown();
    }

    @Override
    protected PAPContext getContext() {
        return this._context;
    }

    private void _sendResponses() throws InterruptedException, IOException {
        while (true) {
            ApplicationMessage response = this._responses.take();
            response.setInternalIndications(this._internalIndications);
            Require.ignored((boolean)response.send());
        }
    }
}

