/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Attributes;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Origin;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.pap.PAPMessages;
import org.rvpf.pap.PAPProxy;
import org.rvpf.pap.dnp3.DNP3Context;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.transport.LogicalDevice;

public abstract class DNP3Proxy
extends PAPProxy {
    public static final ElapsedTime DEFAULT_CONNECT_TIMEOUT = ElapsedTime.fromMillis((long)30000L);
    public static final ElapsedTime DEFAULT_KEEP_ALIVE_TIMEOUT = ElapsedTime.fromMillis((long)60000L);
    public static final ElapsedTime DEFAULT_REPLY_TIMEOUT = ElapsedTime.fromMillis((long)5000L);
    private int _connectTimeout;
    private long _keepAliveTimeout;
    private final Map<Short, LogicalDevice> _logicalDeviceByAddress = new HashMap<Short, LogicalDevice>();
    private final Map<String, LogicalDevice> _logicalDeviceByName = new HashMap<String, LogicalDevice>();
    private int _maxFragmentSize;
    private long _replyTimeout;
    private String _serialPortName;
    private int _serialPortSpeed;
    private final List<InetSocketAddress> _tcpSocketAddresses = new LinkedList<InetSocketAddress>();
    private final List<InetSocketAddress> _udpSocketAddresses = new LinkedList<InetSocketAddress>();

    protected DNP3Proxy(@Nonnull DNP3Proxy other) {
        super(other);
        this._connectTimeout = other._connectTimeout;
        this._keepAliveTimeout = other._keepAliveTimeout;
        this._logicalDeviceByAddress.putAll(other._logicalDeviceByAddress);
        this._logicalDeviceByName.putAll(other._logicalDeviceByName);
        this._maxFragmentSize = other._maxFragmentSize;
        this._replyTimeout = other._replyTimeout;
        this._serialPortName = other._serialPortName;
        this._serialPortSpeed = other._serialPortSpeed;
        this._tcpSocketAddresses.addAll(other._tcpSocketAddresses);
        this._udpSocketAddresses.addAll(other._udpSocketAddresses);
    }

    protected DNP3Proxy(@Nonnull DNP3Context context, @Nonnull Origin origin) {
        super(context, origin);
    }

    protected DNP3Proxy(@Nonnull DNP3Context context, @Nonnull String name) {
        this(context, DNP3Proxy._newOrigin(name));
    }

    public final void addTCPSocketAddress(@Nonnull InetSocketAddress socketAddress) {
        this._tcpSocketAddresses.add(socketAddress);
    }

    public final void addUDPSocketAddress(@Nonnull InetSocketAddress socketAddress) {
        this._udpSocketAddresses.add(socketAddress);
    }

    @CheckReturnValue
    public final int getConnectTimeout() {
        return this._connectTimeout;
    }

    @CheckReturnValue
    public final long getKeepAliveTimeout() {
        return this._keepAliveTimeout;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<LogicalDevice> getLogicalDevice() {
        LogicalDevice logicalDevice = this._logicalDeviceByAddress.size() == 1 ? this._logicalDeviceByAddress.values().iterator().next() : null;
        return Optional.ofNullable(logicalDevice);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<LogicalDevice> getLogicalDevice(@Nonnull Short address) {
        return Optional.ofNullable(this._logicalDeviceByAddress.get(address));
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<LogicalDevice> getLogicalDevice(@Nonnull String name) {
        return Optional.ofNullable(this._logicalDeviceByName.get(name.toUpperCase(Locale.ROOT)));
    }

    @CheckReturnValue
    public final int getMaxFragmentSize() {
        return this._maxFragmentSize;
    }

    @CheckReturnValue
    public final long getReplyTimeout() {
        return this._replyTimeout;
    }

    @Nonnull
    @CheckReturnValue
    public final String getSerialPortName() {
        return (String)Require.notNull((Object)this._serialPortName);
    }

    @CheckReturnValue
    public final int getSerialPortSpeed() {
        return this._serialPortSpeed;
    }

    @Nonnull
    @CheckReturnValue
    public final List<InetSocketAddress> getTCPSocketAddresses() {
        return Collections.unmodifiableList(this._tcpSocketAddresses);
    }

    @Nonnull
    @CheckReturnValue
    public final List<InetSocketAddress> getUDPSocketAddresses() {
        return Collections.unmodifiableList(this._udpSocketAddresses);
    }

    @CheckReturnValue
    public abstract boolean isMaster();

    public final void registerLogicalDevice(@Nonnull LogicalDevice logicalDevice) {
        Optional<LogicalDevice> knownLogicalDevice;
        String logicalDeviceName = logicalDevice.getName();
        Short logicalDeviceAddress = logicalDevice.getAddress();
        if (!logicalDeviceName.isEmpty()) {
            knownLogicalDevice = this.getLogicalDevice(logicalDeviceName);
            if (!knownLogicalDevice.isPresent()) {
                this._logicalDeviceByName.put(logicalDeviceName.toUpperCase(Locale.ROOT), logicalDevice);
            } else if (!logicalDeviceAddress.equals(knownLogicalDevice.get().getAddress())) {
                this.getThisLogger().warn((Messages.Entry)DNP3Messages.DUPLICATE_LOGICAL_DEVICE, new Object[]{logicalDeviceName, this.getName().orElse(null)});
            }
        }
        if (!(knownLogicalDevice = this.getLogicalDevice(logicalDeviceAddress)).isPresent()) {
            this._logicalDeviceByAddress.put(logicalDeviceAddress, logicalDevice);
        } else if (!logicalDeviceName.equalsIgnoreCase(knownLogicalDevice.get().getName())) {
            this.getThisLogger().warn((Messages.Entry)DNP3Messages.DUPLICATE_LOGICAL_DEVICE, new Object[]{logicalDeviceAddress, this.getName().orElse(null)});
        }
    }

    public final void setConnectTimeout(@Nonnull Optional<ElapsedTime> connectTimeout) {
        this._connectTimeout = (int)(connectTimeout.isPresent() ? connectTimeout.get().toMillis() : 0L);
    }

    public final void setKeepAliveTimeout(@Nonnull Optional<ElapsedTime> keepAliveTimeout) {
        this._keepAliveTimeout = keepAliveTimeout.isPresent() ? keepAliveTimeout.get().toMillis() : -1L;
    }

    public final void setMaxFragmentSize(int maxFragmentSize) {
        if (maxFragmentSize < 249) {
            throw new IllegalArgumentException();
        }
        this._maxFragmentSize = maxFragmentSize;
    }

    public final void setReplyTimeout(@Nonnull Optional<ElapsedTime> replyTimeout) {
        this._replyTimeout = replyTimeout.isPresent() ? replyTimeout.get().toMillis() : -1L;
    }

    @CheckReturnValue
    public final boolean setUp(@Nonnull Attributes originAttributes) {
        int maxFragmentSize = originAttributes.getInt("MAX_FRAGMENT_SIZE", this.isMaster() ? 2048 : 249);
        try {
            this.setMaxFragmentSize(maxFragmentSize);
        }
        catch (IllegalArgumentException exception) {
            this.getThisLogger().warn((Messages.Entry)PAPMessages.BAD_ATTRIBUTE_VALUE, new Object[]{"TYPE", this.getOrigin(), maxFragmentSize});
            return false;
        }
        this.setConnectTimeout(originAttributes.getElapsed("CONNECT_TIMEOUT", Optional.of(DEFAULT_CONNECT_TIMEOUT), Optional.empty()));
        this.setReplyTimeout(originAttributes.getElapsed("REPLY_TIMEOUT", Optional.of(DEFAULT_REPLY_TIMEOUT), Optional.empty()));
        this.setKeepAliveTimeout(originAttributes.getElapsed("KEEP_ALIVE_TIMEOUT", Optional.of(DEFAULT_KEEP_ALIVE_TIMEOUT), Optional.empty()));
        this._serialPortName = ((String)originAttributes.getString("SERIAL_PORT", Optional.of("")).get()).trim();
        this._serialPortSpeed = originAttributes.getInt("SERIAL_SPEED", 9600);
        return true;
    }

    @Override
    public final boolean supportsWildcardAddress() {
        return true;
    }

    private static Origin _newOrigin(String name) {
        OriginEntity.Builder originBuilder = OriginEntity.newBuilder();
        originBuilder.setName(name);
        return originBuilder.build();
    }
}

