/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.DataType;
import org.rvpf.pap.dnp3.transport.LogicalDevice;

public final class DNP3StationPoint {
    private final DataType _dataType;
    private final LogicalDevice _logicalDevice;
    private final ObjectRange _objectRange;
    private final Point _point;
    private final PointType _pointType;

    public DNP3StationPoint(@Nonnull Point point, @Nonnull LogicalDevice logicalDevice, @Nonnull PointType pointType, @Nonnull ObjectRange objectRange, @Nonnull DataType dataType) {
        this._point = point;
        this._logicalDevice = logicalDevice;
        this._pointType = pointType;
        this._objectRange = objectRange;
        this._dataType = dataType;
    }

    @Nonnull
    @CheckReturnValue
    public DataType getDataType() {
        return this._dataType;
    }

    @Nonnull
    @CheckReturnValue
    public LogicalDevice getLogicalDevice() {
        return this._logicalDevice;
    }

    @Nonnull
    @CheckReturnValue
    public ObjectRange getObjectRange() {
        return this._objectRange;
    }

    @Nonnull
    @CheckReturnValue
    public Point getPoint() {
        return this._point;
    }

    @Nonnull
    @CheckReturnValue
    public PointType getPointType() {
        return this._pointType;
    }

    @Nonnull
    @CheckReturnValue
    public PointType.Support getSupport() {
        return this.getPointType().getSupport();
    }

    @CheckReturnValue
    public boolean isReadOnly() {
        return this.getSupport().isReadOnly();
    }

    @Nonnull
    @CheckReturnValue
    ObjectVariation getInputVariation() {
        return this._pointType.getSupport().getInputVariation();
    }

    @Nonnull
    @CheckReturnValue
    Optional<ObjectVariation> getInputVariation(@Nonnull DataType dataType) {
        return this._pointType.getSupport().getInputVariation(dataType);
    }

    @Nonnull
    @CheckReturnValue
    Optional<ObjectVariation> getOutputVariation(@Nonnull DataType dataType) {
        return this._pointType.getSupport().getOutputVariation(dataType);
    }
}

