/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.groupCategory.analogInputs.AnalogInputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.analogOutputs.AnalogOutputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.binaryInputs.BinaryInputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.binaryOutputs.BinaryOutputsGroup;
import org.rvpf.pap.dnp3.object.groupCategory.classes.ClassesGroup;
import org.rvpf.pap.dnp3.object.groupCategory.counters.CountersGroup;
import org.rvpf.pap.dnp3.object.groupCategory.devices.DevicesGroup;
import org.rvpf.pap.dnp3.object.groupCategory.times.TimesGroup;

public enum GroupCategory {
    DEVICE_ATTRIBUTES(0, 0, "Device Attributes", Optional.empty(), Optional.empty()),
    BINARY_INPUTS(1, 9, "Binary Inputs", Optional.of(BinaryInputsGroup.class), Optional.of(BinaryInputsGroup.BINARY_INPUT)),
    BINARY_OUTPUTS(10, 19, "Binary Outputs", Optional.of(BinaryOutputsGroup.class), Optional.of(BinaryOutputsGroup.BINARY_OUTPUT)),
    COUNTERS(20, 29, "Counters", Optional.of(CountersGroup.class), Optional.of(CountersGroup.COUNTER)),
    ANALOG_INPUTS(30, 39, "Analog Inputs", Optional.of(AnalogInputsGroup.class), Optional.of(AnalogInputsGroup.ANALOG_INPUT)),
    ANALOG_OUTPUTS(40, 49, "Analog Outputs", Optional.of(AnalogOutputsGroup.class), Optional.of(AnalogOutputsGroup.ANALOG_OUTPUT_COMMAND)),
    TIMES(50, 59, "Times", Optional.of(TimesGroup.class), Optional.of(TimesGroup.TIME_DATE)),
    CLASSES(60, 69, "Classes", Optional.of(ClassesGroup.class), Optional.of(ClassesGroup.CLASS_OBJECTS)),
    FILES(70, 79, "Files", Optional.empty(), Optional.empty()),
    DEVICES(80, 82, "Devices", Optional.of(DevicesGroup.class), Optional.of(DevicesGroup.INTERNAL_INDICATIONS)),
    DATA_SETS(83, 89, "Data Sets", Optional.empty(), Optional.empty()),
    APPLICATIONS(90, 99, "Applications", Optional.empty(), Optional.empty()),
    ALTERNATE_NUMERICS(100, 109, "Alternate Numerics", Optional.empty(), Optional.empty()),
    OTHER(110, 119, "Other", Optional.empty(), Optional.empty()),
    SECURITY(120, 129, "Security", Optional.empty(), Optional.empty());

    private static final String _INSTANCE_METHOD_NAME = "instance";
    private static final Map<Integer, GroupCategory> _POINT_TYPE_MAP;
    private static final ObjectVariation[] _NO_VARIATIONS;
    private static final ObjectGroup[] _NO_GROUPS;
    private static final String _VALUES_METHOD_NAME = "values";
    private static final String _VALUE_OF_METHOD_NAME = "valueOf";
    private final Optional<ObjectGroup> _baseGroup;
    private final int _fromGroupCode;
    private final Optional<Class<? extends ObjectGroup>> _objectGroupClass;
    private final String _title;
    private final int _toGroupCode;

    private GroupCategory(@Nonnull int fromGroupCode, @Nonnull int toGroupCode, @Nonnull String title, Optional<Class<? extends ObjectGroup>> objectGroupClass, Optional<ObjectGroup> baseGroup) {
        this._fromGroupCode = fromGroupCode;
        this._toGroupCode = toGroupCode;
        this._title = title;
        this._objectGroupClass = objectGroupClass;
        this._baseGroup = baseGroup;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<GroupCategory> instance(int groupCode) {
        return Optional.ofNullable(_POINT_TYPE_MAP.get(groupCode));
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectInstance newObjectInstance(@Nonnull ObjectVariation objectVariation) {
        ObjectInstance objectInstance;
        try {
            objectInstance = objectVariation.getObjectClass().newInstance();
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
        return objectInstance;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<ObjectGroup> objectGroup(int groupCode) {
        ObjectGroup objectGroup;
        Optional<GroupCategory> groupCategory = GroupCategory.instance(groupCode);
        if (!groupCategory.isPresent()) {
            return Optional.empty();
        }
        Optional<Class<? extends ObjectGroup>> objectGroupClass = groupCategory.get().getObjectGroupClass();
        if (!objectGroupClass.isPresent()) {
            return Optional.empty();
        }
        try {
            Method instanceMethod = objectGroupClass.get().getMethod(_INSTANCE_METHOD_NAME, Integer.TYPE);
            objectGroup = (ObjectGroup)instanceMethod.invoke(null, groupCode);
        }
        catch (InvocationTargetException exception) {
            return Optional.empty();
        }
        catch (ReflectiveOperationException exception) {
            throw new InternalError(exception);
        }
        return Optional.of(objectGroup);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<ObjectVariation> objectVariation(@Nonnull ObjectGroup objectGroup, int variationCode) {
        ObjectVariation objectVariation;
        try {
            Method instanceMethod = objectGroup.getObjectVariationClass().getMethod(_INSTANCE_METHOD_NAME, Integer.TYPE);
            objectVariation = (ObjectVariation)instanceMethod.invoke(null, variationCode);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
        return Optional.ofNullable(objectVariation);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<ObjectVariation> objectVariation(@Nonnull ObjectGroup objectGroup, @Nonnull String variationKey) {
        ObjectVariation objectVariation;
        try {
            Method instanceMethod = objectGroup.getObjectVariationClass().getMethod(_VALUE_OF_METHOD_NAME, String.class);
            objectVariation = (ObjectVariation)instanceMethod.invoke(null, variationKey);
        }
        catch (InvocationTargetException exception) {
            return Optional.empty();
        }
        catch (ReflectiveOperationException exception) {
            throw new InternalError(exception);
        }
        return Optional.ofNullable(objectVariation);
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectVariation[] objectVariations(@Nonnull Optional<ObjectGroup> objectGroup) {
        ObjectVariation[] objectVariations;
        if (!objectGroup.isPresent()) {
            return _NO_VARIATIONS;
        }
        try {
            Method valuesMethod = objectGroup.get().getObjectVariationClass().getMethod(_VALUES_METHOD_NAME, new Class[0]);
            objectVariations = (ObjectVariation[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
        return objectVariations;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ObjectGroup> getBaseGroup() {
        return this._baseGroup;
    }

    @CheckReturnValue
    public int getFromGroupCode() {
        return this._fromGroupCode;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ObjectGroup> getObjectGroup(@Nonnull String groupKey) {
        ObjectGroup objectGroup;
        if (!this._objectGroupClass.isPresent()) {
            return Optional.empty();
        }
        Class<? extends ObjectGroup> objectGroupClass = this._objectGroupClass.get();
        try {
            Method valuesMethod = objectGroupClass.getMethod(_VALUE_OF_METHOD_NAME, String.class);
            objectGroup = (ObjectGroup)valuesMethod.invoke(null, groupKey);
        }
        catch (InvocationTargetException exception) {
            return Optional.empty();
        }
        catch (ReflectiveOperationException exception) {
            throw new InternalError(exception);
        }
        return Optional.of(objectGroup);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Class<? extends ObjectGroup>> getObjectGroupClass() {
        return this._objectGroupClass;
    }

    @Nonnull
    @CheckReturnValue
    public ObjectGroup[] getObjectGroups() {
        ObjectGroup[] objectGroups;
        if (!this._objectGroupClass.isPresent()) {
            return _NO_GROUPS;
        }
        Class<? extends ObjectGroup> objectGroupClass = this._objectGroupClass.get();
        try {
            Method valuesMethod = objectGroupClass.getMethod(_VALUES_METHOD_NAME, new Class[0]);
            objectGroups = (ObjectGroup[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
        return objectGroups;
    }

    @Nonnull
    @CheckReturnValue
    public String getTitle() {
        return this._title;
    }

    @CheckReturnValue
    public int getToGroupCode() {
        return this._toGroupCode;
    }

    static {
        _POINT_TYPE_MAP = new HashMap<Integer, GroupCategory>();
        _NO_VARIATIONS = new ObjectVariation[0];
        _NO_GROUPS = new ObjectGroup[0];
        for (GroupCategory value : GroupCategory.values()) {
            for (int i = value.getFromGroupCode(); i <= value.getToGroupCode(); ++i) {
                _POINT_TYPE_MAP.put(i, value);
            }
        }
    }
}

