/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.pap.dnp3.DNP3Messages;
import org.rvpf.pap.dnp3.DNP3ProtocolException;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectInstance;
import org.rvpf.pap.dnp3.object.ObjectRange;
import org.rvpf.pap.dnp3.object.ObjectVariation;

public final class ObjectHeader {
    private static final byte _PREFIX_CODE_MASK = 112;
    private static final int _PREFIX_CODE_SHIFT = 4;
    private static final byte _RANGE_CODE_MASK = 15;
    private static final int _RANGE_CODE_SHIFT = 0;
    private static final RangeCode[] _RANGE_CODES = (RangeCode[])RangeCode.class.getEnumConstants();
    private static final PrefixCode[] _PREFIX_CODES = (PrefixCode[])PrefixCode.class.getEnumConstants();
    private int _count;
    private byte _group;
    private byte _qualifier;
    private Object _range;
    private byte _variation;

    private ObjectHeader() {
    }

    private ObjectHeader(ObjectVariation objectVariation, PrefixCode prefixCode, RangeCode rangeCode, Optional<Object> range) {
        this._group = (byte)objectVariation.getObjectGroup().getCode();
        this._variation = (byte)objectVariation.getCode();
        this._qualifier = (byte)(prefixCode.ordinal() << 4 | rangeCode.ordinal() << 0);
        this._range = range.orElse(null);
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectHeader newInstance(@Nonnull ByteBuffer buffer) throws IOException {
        ObjectHeader objectHeader = new ObjectHeader();
        objectHeader._loadFromBuffer(buffer);
        return objectHeader;
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectHeader newInstance(@Nonnull ObjectHeader objectHeader) throws DNP3ProtocolException {
        return new ObjectHeader(objectHeader.getObjectVariation(), objectHeader.getPrefixCode(), objectHeader.getRangeCode(), objectHeader.getRange());
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectHeader newInstance(@Nonnull ObjectVariation objectVariation, @Nonnull ObjectRange objectRange) {
        return new ObjectHeader(objectVariation, PrefixCode.NONE, objectRange.getRangeCode(), Optional.of(objectRange.getRange()));
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectHeader newInstance(@Nonnull ObjectVariation objectVariation, @Nonnull PrefixCode prefixCode, @Nonnull RangeCode rangeCode, @Nonnull Optional<Object> range) {
        return new ObjectHeader(objectVariation, prefixCode, rangeCode, range);
    }

    public void dumpToBuffer(@Nonnull ByteBuffer buffer, @Nonnull Optional<ObjectInstance[]> objectInstances) throws DNP3ProtocolException {
        buffer.put(this._group);
        buffer.put(this._variation);
        buffer.put(this._qualifier);
        switch (this.getRangeCode()) {
            case START_STOP_INDEX_BYTE: 
            case START_STOP_ADDRESS_BYTE: 
            case COUNT_BYTE: 
            case VARIABLE_COUNT_BYTE: {
                for (byte octet : (byte[])this._range) {
                    buffer.put(octet);
                }
                break;
            }
            case START_STOP_INDEX_SHORT: 
            case START_STOP_ADDRESS_SHORT: 
            case COUNT_SHORT: {
                for (short word : (short[])this._range) {
                    buffer.putShort(word);
                }
                break;
            }
            case START_STOP_INDEX_INT: 
            case START_STOP_ADDRESS_INT: 
            case COUNT_INT: {
                for (int doubleWord : (int[])this._range) {
                    buffer.putInt(doubleWord);
                }
                break;
            }
        }
        if (objectInstances.isPresent()) {
            for (ObjectInstance objectInstance : objectInstances.get()) {
                switch (this.getPrefixCode()) {
                    case INDEX_BYTE: {
                        buffer.put((byte)objectInstance.getObjectIndex());
                        break;
                    }
                    case INDEX_SHORT: {
                        buffer.putShort((short)objectInstance.getObjectIndex());
                        break;
                    }
                    case INDEX_INT: {
                        buffer.putInt(objectInstance.getObjectIndex());
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                objectInstance.dumpToBuffer(buffer);
            }
        }
    }

    @CheckReturnValue
    public int getLength() throws DNP3ProtocolException {
        int rangeLength;
        switch (this.getRangeCode()) {
            case COUNT_BYTE: {
                rangeLength = 1;
                break;
            }
            case START_STOP_INDEX_BYTE: 
            case START_STOP_ADDRESS_BYTE: 
            case COUNT_SHORT: {
                rangeLength = 2;
                break;
            }
            case START_STOP_INDEX_SHORT: 
            case START_STOP_ADDRESS_SHORT: 
            case COUNT_INT: {
                rangeLength = 4;
                break;
            }
            case START_STOP_INDEX_INT: 
            case START_STOP_ADDRESS_INT: {
                rangeLength = 8;
                break;
            }
            default: {
                rangeLength = 0;
            }
        }
        return 3 + rangeLength;
    }

    @CheckReturnValue
    public int getLength(@Nonnull ObjectInstance[] instances) throws DNP3ProtocolException {
        int prefixLength;
        switch (this.getPrefixCode()) {
            case INDEX_BYTE: 
            case SIZE_BYTE: {
                prefixLength = 1;
                break;
            }
            case INDEX_SHORT: 
            case SIZE_SHORT: {
                prefixLength = 2;
                break;
            }
            case INDEX_INT: 
            case SIZE_INT: {
                prefixLength = 4;
                break;
            }
            default: {
                prefixLength = 0;
            }
        }
        int length = 0;
        for (ObjectInstance instance : instances) {
            length += prefixLength + instance.getObjectLength();
        }
        return length;
    }

    @CheckReturnValue
    public int getObjectCount() {
        return this._count;
    }

    @Nonnull
    @CheckReturnValue
    public ObjectGroup getObjectGroup() throws DNP3ProtocolException {
        Optional<ObjectGroup> objectGroup = GroupCategory.objectGroup(this._group);
        if (!objectGroup.isPresent()) {
            throw new DNP3ProtocolException(DNP3Messages.UNKNOWN_GROUP_CODE, String.valueOf(this._group & 0xFF));
        }
        return objectGroup.get();
    }

    @Nonnull
    @CheckReturnValue
    public ObjectVariation getObjectVariation() throws DNP3ProtocolException {
        ObjectGroup objectGroup = this.getObjectGroup();
        Optional<ObjectVariation> objectVariation = GroupCategory.objectVariation(objectGroup, this._variation);
        if (!objectVariation.isPresent()) {
            throw new DNP3ProtocolException(DNP3Messages.UNKNOWN_VARIATION, this._variation, objectGroup.getTitle());
        }
        return objectVariation.get();
    }

    @Nonnull
    @CheckReturnValue
    public PrefixCode getPrefixCode() throws DNP3ProtocolException {
        try {
            return _PREFIX_CODES[this._prefixCode()];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw new DNP3ProtocolException(DNP3Messages.UNKNOWN_PREFIX_CODE, this._prefixCode());
        }
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Object> getRange() {
        return Optional.ofNullable(this._range);
    }

    @Nonnull
    @CheckReturnValue
    public RangeCode getRangeCode() throws DNP3ProtocolException {
        try {
            return _RANGE_CODES[this._rangeCode()];
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw new DNP3ProtocolException(DNP3Messages.UNKNOWN_RANGE_CODE, this._rangeCode());
        }
    }

    public void loadInstancesFromBuffer(@Nonnull ByteBuffer buffer, @Nonnull Optional<Number[]> objectIndices, @Nonnull Optional<Number[]> objectSizes, @Nonnull Optional<ObjectInstance[]> objectInstances) throws DNP3ProtocolException {
        int stop;
        int start;
        switch (this.getRangeCode()) {
            case COUNT_BYTE: 
            case VARIABLE_COUNT_BYTE: {
                start = 0;
                stop = (((byte[])this._range)[0] & 0xFF) - 1;
                break;
            }
            case COUNT_SHORT: {
                start = 0;
                stop = (((short[])this._range)[0] & 0xFFFF) - 1;
                break;
            }
            case COUNT_INT: {
                start = 0;
                stop = ((int[])this._range)[0] - 1;
                break;
            }
            case START_STOP_INDEX_BYTE: 
            case START_STOP_ADDRESS_BYTE: {
                start = ((byte[])this._range)[0] & 0xFF;
                stop = ((byte[])this._range)[1] & 0xFF;
                break;
            }
            case START_STOP_INDEX_SHORT: 
            case START_STOP_ADDRESS_SHORT: {
                start = ((short[])this._range)[0] & 0xFFFF;
                stop = ((short[])this._range)[1] & 0xFFFF;
                break;
            }
            case START_STOP_INDEX_INT: 
            case START_STOP_ADDRESS_INT: {
                start = ((int[])this._range)[0];
                stop = ((int[])this._range)[1];
                break;
            }
            default: {
                start = 0;
                stop = 0;
            }
        }
        this._count = 1 + stop - start;
        if (objectIndices.isPresent()) {
            Require.equal((long)this._count, (long)objectIndices.get().length);
        }
        if (objectSizes.isPresent()) {
            Require.equal((long)this._count, (long)objectSizes.get().length);
        }
        if (objectInstances.isPresent()) {
            Require.equal((long)this._count, (long)objectInstances.get().length);
        }
        ObjectVariation objectVariation = this.getObjectVariation();
        int nextIndex = start;
        for (int i = 0; i < this._count; ++i) {
            int objectIndex;
            switch (this.getPrefixCode()) {
                case INDEX_BYTE: {
                    objectIndex = buffer.get() & 0xFF;
                    objectIndices.get()[i] = objectIndex;
                    int objectSize = 0;
                    break;
                }
                case SIZE_BYTE: {
                    objectIndex = nextIndex;
                    int objectSize = buffer.get() & 0xFF;
                    objectSizes.get()[i] = objectSize;
                    break;
                }
                case INDEX_SHORT: {
                    objectIndex = buffer.getShort() & 0xFFFF;
                    objectIndices.get()[i] = objectIndex;
                    int objectSize = 0;
                    break;
                }
                case SIZE_SHORT: {
                    objectIndex = nextIndex;
                    int objectSize = buffer.getShort() & 0xFFFF;
                    objectSizes.get()[i] = objectSize;
                    break;
                }
                case INDEX_INT: {
                    objectIndex = buffer.getInt();
                    objectIndices.get()[i] = objectIndex;
                    int objectSize = 0;
                    break;
                }
                case SIZE_INT: {
                    objectIndex = nextIndex;
                    int objectSize = buffer.getInt();
                    objectSizes.get()[i] = objectSize;
                    break;
                }
                default: {
                    objectIndex = nextIndex;
                    int objectSize = 0;
                }
            }
            if (objectInstances.isPresent()) {
                ObjectInstance objectInstance = GroupCategory.newObjectInstance(objectVariation);
                objectInstance.setUp(objectIndex, stop);
                objectInstance.loadFromBuffer(buffer);
                objectInstances.get()[i] = objectInstance;
            }
            if (objectVariation.isPacked()) break;
            ++nextIndex;
        }
    }

    public String toString() {
        ObjectVariation objectVariation;
        ObjectGroup objectGroup;
        StringBuilder builder = new StringBuilder();
        try {
            objectGroup = this.getObjectGroup();
            objectVariation = this.getObjectVariation();
        }
        catch (DNP3ProtocolException exception) {
            throw new RuntimeException(exception);
        }
        builder.append("Group ");
        builder.append(objectGroup.getCode());
        builder.append(" (");
        builder.append(objectGroup.getTitle());
        builder.append(") variation ");
        builder.append(objectVariation.getCode());
        builder.append(" (");
        builder.append(objectVariation.getTitle());
        builder.append(") [");
        int rangeCode = this._rangeCode();
        if (rangeCode == RangeCode.START_STOP_INDEX_BYTE.ordinal()) {
            builder.append(((byte[])this._range)[0] & 0xFF);
            builder.append(':');
            builder.append(((byte[])this._range)[1] & 0xFF);
        } else if (rangeCode == RangeCode.START_STOP_INDEX_SHORT.ordinal()) {
            builder.append(((short[])this._range)[0] & 0xFFFF);
            builder.append(':');
            builder.append(((short[])this._range)[1] & 0xFFFF);
        } else if (rangeCode == RangeCode.START_STOP_INDEX_INT.ordinal()) {
            builder.append(((int[])this._range)[0]);
            builder.append(':');
            builder.append(((int[])this._range)[1]);
        } else if (rangeCode == RangeCode.COUNT_BYTE.ordinal()) {
            builder.append(((byte[])this._range)[0] & 0xFF);
        } else if (rangeCode == RangeCode.COUNT_SHORT.ordinal()) {
            builder.append(((short[])this._range)[0] & 0xFFFF);
        } else if (rangeCode == RangeCode.COUNT_INT.ordinal()) {
            builder.append(((int[])this._range)[0]);
        }
        builder.append("]/");
        return builder.toString();
    }

    private void _loadFromBuffer(ByteBuffer buffer) throws IOException {
        this._group = buffer.get();
        this._variation = buffer.get();
        this._qualifier = buffer.get();
        switch (this.getRangeCode()) {
            case COUNT_BYTE: 
            case VARIABLE_COUNT_BYTE: {
                this._count = buffer.get();
                this._range = new byte[]{(byte)this._count};
                break;
            }
            case START_STOP_INDEX_BYTE: 
            case START_STOP_ADDRESS_BYTE: {
                int start = buffer.get() & 0xFF;
                int stop = buffer.get() & 0xFF;
                this._count = 1 + stop - start;
                this._range = new byte[]{(byte)start, (byte)stop};
                break;
            }
            case COUNT_SHORT: {
                this._count = buffer.getShort() & 0xFFFF;
                this._range = new short[]{(short)this._count};
                break;
            }
            case START_STOP_INDEX_SHORT: 
            case START_STOP_ADDRESS_SHORT: {
                int start = buffer.getShort() & 0xFFFF;
                int stop = buffer.getShort() & 0xFFFF;
                this._count = 1 + stop - start;
                this._range = new short[]{(short)start, (short)stop};
                break;
            }
            case COUNT_INT: {
                this._count = buffer.getInt();
                this._range = new int[]{this._count};
                break;
            }
            case START_STOP_INDEX_INT: 
            case START_STOP_ADDRESS_INT: {
                int start = buffer.getInt();
                int stop = buffer.getInt();
                this._count = 1 + stop - start;
                this._range = new int[]{start, stop};
                break;
            }
            default: {
                this._count = 0;
                this._range = null;
            }
        }
    }

    private int _prefixCode() {
        return (this._qualifier & 0x70) >> 4;
    }

    private int _rangeCode() {
        return (this._qualifier & 0xF) >> 0;
    }

    public static enum RangeCode {
        START_STOP_INDEX_BYTE,
        START_STOP_INDEX_SHORT,
        START_STOP_INDEX_INT,
        START_STOP_ADDRESS_BYTE,
        START_STOP_ADDRESS_SHORT,
        START_STOP_ADDRESS_INT,
        NONE,
        COUNT_BYTE,
        COUNT_SHORT,
        COUNT_INT,
        RESERVED_1,
        VARIABLE_COUNT_BYTE;

    }

    public static enum PrefixCode {
        NONE,
        INDEX_BYTE,
        INDEX_SHORT,
        INDEX_INT,
        SIZE_BYTE,
        SIZE_SHORT,
        SIZE_INT;

    }
}

