/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.pap.dnp3.object.GroupCategory;
import org.rvpf.pap.dnp3.object.ObjectGroup;
import org.rvpf.pap.dnp3.object.ObjectVariation;
import org.rvpf.pap.dnp3.object.PointType;
import org.rvpf.pap.dnp3.object.content.ControlStatusCode;
import org.rvpf.pap.dnp3.object.content.DoubleBitState;
import org.rvpf.pap.dnp3.object.content.ObjectFlags;

public interface ObjectInstance {
    public void dumpToBuffer(@Nonnull ByteBuffer var1);

    @Nonnull
    @CheckReturnValue
    public GroupCategory getGroupCategory();

    @CheckReturnValue
    public int getGroupCode();

    @Nonnull
    @CheckReturnValue
    public String getGroupName();

    @Nonnull
    @CheckReturnValue
    public String getGroupTitle();

    @Nonnull
    @CheckReturnValue
    public ObjectGroup getObjectGroup();

    @CheckReturnValue
    public int getObjectIndex();

    @CheckReturnValue
    public int getObjectLength();

    @Nonnull
    @CheckReturnValue
    public ObjectVariation getObjectVariation();

    @Nonnull
    @CheckReturnValue
    public Optional<PointType> getPointType();

    @CheckReturnValue
    public int getValueCount();

    @CheckReturnValue
    public int getVariationCode();

    @Nonnull
    @CheckReturnValue
    public String getVariationName();

    @Nonnull
    @CheckReturnValue
    public String getVariationTitle();

    public void loadFromBuffer(@Nonnull ByteBuffer var1);

    public void setObjectIndex(int var1);

    public void setUp(int var1, int var2);

    public void setValueCount(int var1);

    public static abstract class Abstract
    implements ObjectInstance {
        protected static final int TIME_BYTES = 6;
        private int _index;

        @Override
        public GroupCategory getGroupCategory() {
            return this.getObjectGroup().getCategory();
        }

        @Override
        public final int getGroupCode() {
            return this.getObjectGroup().getCode();
        }

        @Override
        public final String getGroupName() {
            return this.getObjectGroup().name();
        }

        @Override
        public final String getGroupTitle() {
            return this.getObjectGroup().getTitle();
        }

        @Override
        public final ObjectGroup getObjectGroup() {
            return this.getObjectVariation().getObjectGroup();
        }

        @Override
        public final int getObjectIndex() {
            return this._index;
        }

        @Override
        public final Optional<PointType> getPointType() {
            return this.getObjectGroup().getPointType();
        }

        @Override
        public int getValueCount() {
            return 1;
        }

        @Override
        public final int getVariationCode() {
            return this.getObjectVariation().getCode();
        }

        @Override
        public final String getVariationName() {
            return this.getObjectVariation().name();
        }

        @Override
        public final String getVariationTitle() {
            return this.getObjectVariation().getTitle();
        }

        @Override
        public final void setObjectIndex(int index) {
            this._index = index;
        }

        @Override
        public final void setUp(int objectIndex, int indexLimit) {
            this.setObjectIndex(objectIndex);
            if (this.getObjectVariation().isPacked()) {
                this.setValueCount(1 + indexLimit - objectIndex);
            }
        }

        @Override
        public void setValueCount(int count) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "#";
        }

        protected static int getBits(@Nonnull byte[] values, int position, int bitsPerValue, int valueMask) {
            int bitCount = (position + 1) * bitsPerValue;
            int byteIndex = bitCount % 8;
            int bitIndex = bitCount - byteIndex * 8;
            if (bitIndex > 0) {
                ++byteIndex;
            }
            return values[byteIndex] >> bitIndex & valueMask;
        }

        @CheckReturnValue
        protected static long getTimeFromBuffer(@Nonnull ByteBuffer buffer) {
            long time = (long)buffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
            return time |= (long)(buffer.getShort() & 0xFFFF);
        }

        protected static byte[] putBits(int value, @Nonnull byte[] values, int position, int bitsPerValue, int valueMask) {
            int bitCount = (position + 1) * bitsPerValue;
            int byteIndex = bitCount % 8;
            int bitIndex = bitCount - byteIndex * 8;
            if (bitIndex > 0) {
                ++byteIndex;
            }
            if (byteIndex >= values.length) {
                values = Arrays.copyOf(values, byteIndex + 1);
            }
            int mask = valueMask << bitIndex;
            int valueByte = values[byteIndex] & ~mask;
            values[byteIndex] = (byte)(valueByte | (value & valueMask) << bitIndex);
            return values;
        }

        protected static void putTimeToBuffer(long time, @Nonnull ByteBuffer buffer) {
            buffer.putInt((int)time);
            buffer.putShort((short)(time >> 32));
        }

        @CheckReturnValue
        protected final int byteCount(int bitsPerValue) {
            int byteCount;
            int bitCount = this.getValueCount() * bitsPerValue;
            if (bitCount - (byteCount = bitCount % 8) * 8 > 0) {
                ++byteCount;
            }
            return byteCount;
        }
    }

    public static interface WithValue
    extends ObjectInstance {
        @CheckReturnValue
        public static boolean booleanValue(@Nonnull Serializable value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)((Object)value));
            }
            return ((Number)value).longValue() != 0L;
        }

        @CheckReturnValue
        public static short byteValue(@Nonnull Serializable value) {
            if (value instanceof String) {
                return Byte.parseByte((String)((Object)value));
            }
            return ((Number)value).byteValue();
        }

        @Nonnull
        @CheckReturnValue
        public static DoubleBitState doubleBitStateValue(@Nonnull Serializable value) {
            if (value instanceof DoubleBitState) {
                return (DoubleBitState)((Object)value);
            }
            return DoubleBitState.instance(((Number)value).intValue());
        }

        @CheckReturnValue
        public static double doubleValue(@Nonnull Serializable value) {
            if (value instanceof String) {
                return Double.parseDouble((String)((Object)value));
            }
            return ((Number)value).doubleValue();
        }

        @CheckReturnValue
        public static float floatValue(@Nonnull Serializable value) {
            if (value instanceof String) {
                return Float.parseFloat((String)((Object)value));
            }
            return ((Number)value).floatValue();
        }

        @CheckReturnValue
        public static int intValue(@Nonnull Serializable value) {
            if (value instanceof String) {
                return Integer.parseInt((String)((Object)value));
            }
            return ((Number)value).intValue();
        }

        @CheckReturnValue
        public static short shortValue(@Nonnull Serializable value) {
            if (value instanceof String) {
                return Short.parseShort((String)((Object)value));
            }
            return ((Number)value).shortValue();
        }

        @Nonnull
        @CheckReturnValue
        public Serializable getValue();

        public void setValue(@Nonnull Serializable var1);
    }

    public static interface WithTime
    extends ObjectInstance {
        @Nonnull
        @CheckReturnValue
        public DateTime getTime();

        public void setTime(@Nonnull DateTime var1);
    }

    public static interface WithStatus
    extends ObjectInstance {
        @Nonnull
        @CheckReturnValue
        public ControlStatusCode getStatus();

        public void setStatus(@Nonnull Optional<ControlStatusCode> var1);
    }

    public static interface WithFlags
    extends ObjectInstance {
        @Nonnull
        @CheckReturnValue
        public ObjectFlags getFlags();

        public void setFlags(@Nonnull Optional<ObjectFlags> var1);
    }

    public static interface Packed
    extends ObjectInstance {
        @CheckReturnValue
        public int get(int var1);

        public void put(int var1, int var2);
    }
}

