/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.pap.dnp3.object;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.pap.dnp3.object.ObjectHeader;

public final class ObjectRange {
    public static final ObjectRange NONE = new ObjectRange(0);
    private static final Object[] _NOTHING = new Object[0];
    private final int _count;
    private final int _startIndex;
    private final int _stopIndex;

    private ObjectRange(int count) {
        this._count = count;
        this._startIndex = 0;
        this._stopIndex = 0;
    }

    private ObjectRange(int startIndex, int stopIndex) {
        this._startIndex = startIndex;
        this._stopIndex = stopIndex;
        this._count = 0;
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectRange newCountInstance(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Negative or null count.");
        }
        return new ObjectRange(count);
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectRange newIndexInstance(int index) {
        return ObjectRange.newIndexInstance(index, index);
    }

    @Nonnull
    @CheckReturnValue
    public static ObjectRange newIndexInstance(int startIndex, int stopIndex) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("Negative start index.");
        }
        if (stopIndex < startIndex) {
            throw new IllegalArgumentException("Stop index less than start index.");
        }
        return new ObjectRange(startIndex, stopIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectRange) {
            ObjectRange other = (ObjectRange)object;
            return this._count == other._count && this._startIndex == other._startIndex && this._stopIndex == other._stopIndex;
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public Object getRange() {
        if (this == NONE) {
            return _NOTHING;
        }
        if (this._count > 0) {
            if (this._count <= 127) {
                return new byte[]{(byte)this._count};
            }
            if (this._count <= Short.MAX_VALUE) {
                return new short[]{(short)this._count};
            }
            return new int[]{this._count};
        }
        if (this._stopIndex <= 127) {
            return new byte[]{(byte)this._startIndex, (byte)this._stopIndex};
        }
        if (this._stopIndex <= Short.MAX_VALUE) {
            return new short[]{(short)this._startIndex, (short)this._stopIndex};
        }
        return new int[]{this._startIndex, this._stopIndex};
    }

    @Nonnull
    @CheckReturnValue
    public ObjectHeader.RangeCode getRangeCode() {
        if (this == NONE) {
            return ObjectHeader.RangeCode.NONE;
        }
        if (this._count > 0) {
            if (this._count <= 127) {
                return ObjectHeader.RangeCode.COUNT_BYTE;
            }
            if (this._count <= Short.MAX_VALUE) {
                return ObjectHeader.RangeCode.COUNT_SHORT;
            }
            return ObjectHeader.RangeCode.COUNT_INT;
        }
        if (this._stopIndex <= 127) {
            return ObjectHeader.RangeCode.START_STOP_INDEX_BYTE;
        }
        if (this._stopIndex <= Short.MAX_VALUE) {
            return ObjectHeader.RangeCode.START_STOP_INDEX_SHORT;
        }
        return ObjectHeader.RangeCode.START_STOP_INDEX_INT;
    }

    @CheckReturnValue
    public int getStartIndex() {
        return this._startIndex;
    }

    @CheckReturnValue
    public int getStopIndex() {
        return this._stopIndex;
    }

    public int hashCode() {
        return Integer.hashCode(this._count) ^ Integer.hashCode(this._startIndex) ^ Integer.hashCode(this._stopIndex);
    }

    @CheckReturnValue
    public boolean isMultiple() {
        return this._stopIndex > this._startIndex || this._count > 1;
    }

    public String toString() {
        return "[" + (this._count > 0 ? String.valueOf(this._count) : this._startIndex + ":" + this._stopIndex) + "]";
    }
}

